/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChangeExceptionHandler;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class ChangeContext {
    private IFile[] fUnsavedFiles;
    private List fHandledUnsavedFiles;
    private IChangeExceptionHandler fExceptionHandler;
    private IChange fFailedChange;
    private boolean fTryToUndo;
    private List fPerformedChanges = new ArrayList();

    public ChangeContext(IChangeExceptionHandler handler) {
        this(handler, new IFile[0]);
    }

    public ChangeContext(IChangeExceptionHandler handler, IFile[] unsavedFiles) {
        this.fExceptionHandler = handler;
        Assert.isNotNull(this.fExceptionHandler);
        this.fUnsavedFiles = unsavedFiles;
        Assert.isNotNull(this.fUnsavedFiles);
        this.fHandledUnsavedFiles = new ArrayList(this.fUnsavedFiles.length);
    }

    public IFile[] getUnsavedFiles() {
        return this.fUnsavedFiles;
    }

    public void checkUnsavedFile(RefactoringStatus status, IFile file) {
        if (this.fHandledUnsavedFiles.contains(file)) {
            return;
        }
        int i = 0;
        while (i < this.fUnsavedFiles.length) {
            if (this.fUnsavedFiles[i].equals((Object)file)) {
                status.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_unsaved", file.getFullPath().toString()));
                this.fHandledUnsavedFiles.add(file);
                return;
            }
            ++i;
        }
    }

    public IChangeExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void setFailedChange(IChange change) {
        this.fFailedChange = change;
    }

    public IChange getFailedChange() {
        return this.fFailedChange;
    }

    public void setTryToUndo() {
        this.fTryToUndo = true;
    }

    public boolean getTryToUndo() {
        return this.fTryToUndo;
    }

    public void addPerformedChange(IChange change) {
        if (change instanceof ICompositeChange) {
            return;
        }
        this.fPerformedChanges.add(change);
    }

    public IChange[] getPerformedChanges() {
        return this.fPerformedChanges.toArray(new IChange[this.fPerformedChanges.size()]);
    }

    public void clearPerformedChanges() {
        this.fPerformedChanges = new ArrayList(1);
    }
}

