/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public abstract class Change
implements IChange {
    private boolean fIsActive = true;
    static /* synthetic */ Class class$0;

    public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        pm.beginTask("", 1);
        RefactoringStatus result = new RefactoringStatus();
        IResource resource = Change.getResource(this.getModifiedLanguageElement());
        if (resource != null) {
            pm.subTask(RefactoringCoreMessages.getFormattedString("Change.checking_for", resource.getName()));
            Change.checkIfModifiable(resource, result, context);
        }
        pm.worked(1);
        return result;
    }

    public void performed() {
    }

    public void setActive(boolean active) {
        this.fIsActive = active;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    protected void handleException(ChangeContext context, Exception exception) throws ChangeAbortException {
        if (exception instanceof ChangeAbortException) {
            throw (ChangeAbortException)exception;
        }
        context.getExceptionHandler().handle(context, this, exception);
    }

    protected static void checkIfModifiable(Object element, RefactoringStatus status, ChangeContext context) {
        IResource resource = Change.getResource(element);
        if (resource != null) {
            Change.checkIfModifiable(resource, status, context);
        }
    }

    protected static void checkIfModifiable(IResource resource, RefactoringStatus status, ChangeContext context) {
        if (resource.isReadOnly()) {
            status.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_read_only", resource.getFullPath().toString()));
        }
        if (resource instanceof IFile) {
            context.checkUnsavedFile(status, (IFile)resource);
        }
    }

    protected static void handleJavaModelException(JavaModelException e, RefactoringStatus status) {
        if (e.isDoesNotExist()) {
            return;
        }
        status.addFatalError(RefactoringCoreMessages.getString("Change.unexpected_exception"));
        JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, JavaCore.getJavaCore().getDescriptor().getUniqueIdentifier(), 4, RefactoringCoreMessages.getString("Change.internal_Error"), (Throwable)e));
    }

    private static IResource getResource(Object element) {
        ICompilationUnit cunit;
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof ICompilationUnit && (cunit = (ICompilationUnit)element).isWorkingCopy()) {
            element = cunit.getOriginalElement();
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public abstract void perform(ChangeContext var1, IProgressMonitor var2) throws JavaModelException, ChangeAbortException;

    public abstract IChange getUndoChange();

    public abstract String getName();

    public abstract Object getModifiedLanguageElement();
}

