/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class SearchResult {
    private IResource fResource;
    private IJavaElement fEnclosingElement;
    private int fStart;
    private int fEnd;
    private int fAccuracy;

    public SearchResult(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
        this.fResource = resource;
        this.fStart = start;
        this.fEnd = end;
        this.fEnclosingElement = enclosingElement;
        this.fAccuracy = accuracy;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public IJavaElement getEnclosingElement() {
        return this.fEnclosingElement;
    }

    public int getAccuracy() {
        return this.fAccuracy;
    }

    public String toString() {
        return "\n<Search Result\n\tstart:" + this.fStart + "\n\tend:" + this.fEnd + "\n\tresource:" + this.fResource.getFullPath() + "\n\tjavaElement:" + this.fEnclosingElement + "(instanceof " + this.fEnclosingElement.getClass() + ")" + this.getElementSourceRange() + "\n\tAccuracy:" + this.fAccuracy + "/>";
    }

    private String getElementSourceRange() {
        try {
            if (this.fEnclosingElement instanceof ISourceReference) {
                return ((ISourceReference)this.fEnclosingElement).getSourceRange().toString();
            }
            return "";
        }
        catch (JavaModelException javaModelException) {
            return "<Exception>";
        }
    }

    public ICompilationUnit getCompilationUnit() {
        IJavaElement jElement = JavaCore.create((IResource)this.getResource());
        if (jElement == null || jElement.getElementType() != 5) {
            return null;
        }
        return (ICompilationUnit)jElement;
    }
}

