/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public abstract class AbstractJavaElementRenameChange
extends Change {
    private String fNewName;
    private String fOldName;
    private IPath fResourcePath;
    private IChange fUndoChange;

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName) {
        Assert.isNotNull(newName, "new name");
        Assert.isNotNull(oldName, "old name");
        this.fResourcePath = resourcePath;
        this.fOldName = oldName;
        this.fNewName = newName;
    }

    protected IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public Object getModifiedLanguageElement() {
        return JavaCore.create((IResource)this.getResource());
    }

    public final IChange getUndoChange() {
        return this.fUndoChange;
    }

    protected abstract IChange createUndoChange() throws JavaModelException;

    protected abstract void doRename(IProgressMonitor var1) throws Exception;

    public final void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        block5: {
            try {
                try {
                    pm.beginTask(RefactoringCoreMessages.getString("AbstractRenameChange.Renaming"), 1);
                    if (this.isActive()) {
                        this.fUndoChange = this.createUndoChange();
                        this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        break block5;
                    }
                    this.fUndoChange = new NullChange();
                }
                catch (Exception e) {
                    this.handleException(context, e);
                    this.fUndoChange = new NullChange();
                    this.setActive(false);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                pm.done();
                throw throwable;
            }
        }
        Object var4_6 = null;
        pm.done();
    }

    protected String getNewName() {
        return this.fNewName;
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    protected String getOldName() {
        return this.fOldName;
    }

    protected static RefactoringStatus checkIfModifiable(IPackageFragmentRoot root, ChangeContext context, IProgressMonitor pm) {
        if (root == null) {
            return null;
        }
        if (!root.exists()) {
            return null;
        }
        if (root.isArchive()) {
            return null;
        }
        if (root.isExternal()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        try {
            IJavaElement[] packs = root.getChildren();
            if (packs == null || packs.length == 0) {
                return null;
            }
            pm.beginTask("", packs.length);
            int i = 0;
            while (i < packs.length) {
                result.merge(AbstractJavaElementRenameChange.checkIfModifiable((IPackageFragment)packs[i], context, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                ++i;
            }
            pm.done();
        }
        catch (JavaModelException e) {
            Change.handleJavaModelException(e, result);
        }
        return result;
    }

    protected static RefactoringStatus checkIfModifiable(IPackageFragment pack, ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit[] units = pack.getCompilationUnits();
        if (units == null || units.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", units.length);
        int i = 0;
        while (i < units.length) {
            pm.subTask(String.valueOf(RefactoringCoreMessages.getString("AbstractJavaElementRenameChange.checking_change")) + pack.getElementName());
            Change.checkIfModifiable(units[i], result, context);
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }
}

