/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.ui.JavaUI;

public class JavaDocVMInstallListener
implements IVMInstallChangedListener {
    public void init() {
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                this.updateJavadocLocations(installs[j]);
                ++j;
            }
            ++i;
        }
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void remove() {
        JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    private void updateJavadocLocations(IVMInstall install) {
        LibraryLocation[] locations;
        URL url = install.getJavadocLocation();
        if (url != null && (locations = JavaRuntime.getLibraryLocations((IVMInstall)install)) != null) {
            int i = 0;
            while (i < locations.length) {
                IPath path = locations[i].getSystemLibraryPath();
                if (path != null) {
                    JavaUI.setLibraryJavadocLocation(path, url);
                }
                ++i;
            }
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_JAVADOC_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property)) {
            this.updateJavadocLocations((IVMInstall)event.getSource());
        }
    }

    public void vmAdded(IVMInstall vm) {
        this.updateJavadocLocations(vm);
    }

    public void vmRemoved(IVMInstall vm) {
    }
}

