/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocVMInstallListener;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaDocLocations {
    private static final QualifiedName QUALIFIED_NAME = new QualifiedName("org.eclipse.jdt.ui", "jdoclocation");
    private static final String NODE_ROOT = "javadoclocation";
    private static final String NODE_ENTRY = "location_01";
    private static final String NODE_PATH = "path";
    private static final String NODE_URL = "url";
    private static final String STORE_FILE = "javadoclocations.xml";
    private static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    private static Map fgJavadocLocations = null;
    private static JavaDocVMInstallListener fgVMInstallListener = null;

    private static Map getJavaDocLocations() {
        if (fgJavadocLocations == null) {
            fgJavadocLocations = new HashMap();
            try {
                JavaDocLocations.initJavadocLocations();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return fgJavadocLocations;
    }

    private static IPath canonicalizedPath(IPath externalPath) {
        if (externalPath == null || IS_CASE_SENSITIVE) {
            return externalPath;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        try {
            return new Path(externalPath.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
    }

    private static void setJavadocBaseLocation(IPath path, URL url, boolean save) {
        boolean needsSave;
        Object old;
        if (url == null) {
            old = JavaDocLocations.getJavaDocLocations().remove(path);
            needsSave = save && old != null;
        } else {
            old = JavaDocLocations.getJavaDocLocations().put(path, url);
            boolean bl = needsSave = save && !url.equals(old);
        }
        if (needsSave) {
            try {
                JavaDocLocations.storeLocations();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private static URL getJavadocBaseLocation(IPath path) {
        return (URL)JavaDocLocations.getJavaDocLocations().get(path);
    }

    public static void setLibraryJavadocLocation(IPath archivePath, URL url) {
        JavaDocLocations.setJavadocBaseLocation(JavaDocLocations.canonicalizedPath(archivePath), url, true);
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        JavaDocLocations.setJavadocBaseLocation(project.getProject().getFullPath(), url, true);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        return JavaDocLocations.getJavadocBaseLocation(project.getProject().getFullPath());
    }

    public static URL getLibraryJavadocLocation(IPath archivePath) {
        return JavaDocLocations.getJavadocBaseLocation(JavaDocLocations.canonicalizedPath(archivePath));
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            return JavaDocLocations.getLibraryJavadocLocation(root.getPath());
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    private static File getStoreFile() {
        IPath path = JavaPlugin.getDefault().getStateLocation();
        path = path.append(STORE_FILE);
        return path.toFile();
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    private static synchronized void storeLocations() throws CoreException {
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(JavaDocLocations.getStoreFile());
                JavaDocLocations.saveToStream(fgJavadocLocations, writer);
            }
            catch (IOException e) {
                throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.writeFile"));
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var2_4 = null;
        try {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {}
    }

    private static boolean loadOldForCompatibility() {
        block7: {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                String xmlString = root.getPersistentProperty(QUALIFIED_NAME);
                if (xmlString == null) break block7;
                StringReader reader = new StringReader(xmlString);
                try {
                    JavaDocLocations.loadFromStream(reader);
                    root.setPersistentProperty(QUALIFIED_NAME, null);
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
                return true;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadFromFile() throws CoreException {
        File file = JavaDocLocations.getStoreFile();
        if (!file.exists()) return false;
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(JavaDocLocations.getStoreFile());
                JavaDocLocations.loadFromStream(reader);
                Object var3_2 = null;
            }
            catch (IOException e) {
                throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readFile"));
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                if (reader == null) throw throwable;
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (reader == null) return true;
        ((Reader)reader).close();
        return true;
    }

    private static void saveToStream(Map locations, Writer writer) throws CoreException {
        DocumentImpl document = new DocumentImpl();
        Element rootElement = document.createElement(NODE_ROOT);
        document.appendChild(rootElement);
        Iterator iter = locations.keySet().iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            URL url = JavaDocLocations.getJavadocBaseLocation(path);
            Element varElement = document.createElement(NODE_ENTRY);
            varElement.setAttribute(NODE_PATH, path.toString());
            varElement.setAttribute(NODE_URL, url.toExternalForm());
            rootElement.appendChild(varElement);
        }
        try {
            OutputFormat format = new OutputFormat();
            format.setIndenting(true);
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer(writer, format);
            serializer.asDOMSerializer().serialize((Document)document);
        }
        catch (IOException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.serializeXML"));
        }
    }

    private static void loadFromStream(Reader reader) throws CoreException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
        }
        catch (SAXException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        catch (ParserConfigurationException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        catch (IOException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        if (cpElement == null) {
            return;
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase(NODE_ENTRY)) {
                String varPath = element.getAttribute(NODE_PATH);
                String varURL = element.getAttribute(NODE_URL);
                try {
                    JavaDocLocations.setJavadocBaseLocation((IPath)new Path(varPath), new URL(varURL), false);
                }
                catch (MalformedURLException e) {
                    throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
                }
            }
            ++i;
        }
    }

    public static void shutdownJavadocLocations() throws CoreException {
        if (fgVMInstallListener == null) {
            return;
        }
        fgVMInstallListener.remove();
        fgVMInstallListener = null;
        fgJavadocLocations = null;
    }

    private static synchronized void initJavadocLocations() throws CoreException {
        try {
            if (JavaDocLocations.loadOldForCompatibility()) {
                JavaDocLocations.storeLocations();
            } else {
                JavaDocLocations.loadFromFile();
            }
        }
        catch (Throwable throwable) {
            Object var0_1 = null;
            fgVMInstallListener = new JavaDocVMInstallListener();
            fgVMInstallListener.init();
            throw throwable;
        }
        Object var0_2 = null;
        fgVMInstallListener = new JavaDocVMInstallListener();
        fgVMInstallListener.init();
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                JavaDocLocations.appendTypePath(((IClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, pathBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, pathBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaElement cont = JavaModelUtil.findTypeContainer(element.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = JavaModelUtil.getTypeQualifiedName(type);
        buf.append(packPath);
        buf.append('/');
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) throws JavaModelException {
        buf.append('#');
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append('#');
        buf.append(meth.getElementName());
        buf.append('(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        int i = 0;
        while (i < params.length) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName(curr = params[i], declaringType)) != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                while (dim > 0) {
                    buf.append("[]");
                    --dim;
                }
            }
            ++i;
        }
        buf.append(')');
    }
}

