/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;

public class TokenScanner {
    private IScanner fScanner;
    private int fEndPosition;

    public TokenScanner(IScanner scanner) {
        this.fScanner = scanner;
        this.fEndPosition = this.fScanner.getSource().length - 1;
    }

    public IScanner getScanner() {
        return this.fScanner;
    }

    public void setOffset(int offset) {
        this.fScanner.resetTo(offset, this.fEndPosition);
    }

    public int getCurrentEndOffset() throws InvalidInputException {
        return this.fScanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() throws InvalidInputException {
        return this.fScanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() throws InvalidInputException {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public int readNext(boolean ignoreComments) throws InvalidInputException {
        int curr = 0;
        do {
            if ((curr = this.fScanner.getNextToken()) != 158) continue;
            throw new InvalidInputException("End of File");
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    public int readNext(int offset, boolean ignoreComments) throws InvalidInputException {
        this.setOffset(offset);
        return this.readNext(ignoreComments);
    }

    public int getNextStartOffset(int offset, boolean ignoreComments) throws InvalidInputException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int offset, boolean ignoreComments) throws InvalidInputException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentEndOffset();
    }

    public void readToToken(int tok) throws InvalidInputException {
        int curr = 0;
        do {
            if ((curr = this.fScanner.getNextToken()) != 158) continue;
            throw new InvalidInputException("End of File");
        } while (curr != tok);
    }

    public void readToToken(int tok, int offset) throws InvalidInputException {
        this.setOffset(offset);
        this.readToToken(tok);
    }

    public int getTokenStartOffset(int token, int startOffset) throws InvalidInputException {
        this.readToToken(token, startOffset);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(int token, int startOffset) throws InvalidInputException {
        this.readToToken(token, startOffset);
        return this.getCurrentEndOffset();
    }

    public int getTokenCommentStart(int startOffset, TextBuffer buffer) throws InvalidInputException {
        int curr = 0;
        int res = -1;
        int lastCommentEndLine = -1;
        this.setOffset(startOffset);
        do {
            if ((curr = this.fScanner.getNextToken()) == 158) {
                throw new InvalidInputException("End of File");
            }
            int startLine = buffer.getLineOfOffset(this.getCurrentStartOffset());
            if (lastCommentEndLine == -1 || startLine - lastCommentEndLine > 1) {
                res = this.getCurrentStartOffset();
            }
            lastCommentEndLine = buffer.getLineOfOffset(this.getCurrentEndOffset() - 1);
        } while (TokenScanner.isComment(curr));
        return res;
    }

    public int readAfterTokens(int[] tokens, boolean ignoreComments, int startOffset, int defaultPos) throws InvalidInputException {
        this.setOffset(startOffset);
        int pos = defaultPos;
        block0: while (true) {
            int curr = this.readNext(ignoreComments);
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i] == curr) {
                    pos = this.getCurrentEndOffset();
                    continue block0;
                }
                ++i;
            }
            break;
        }
        return pos;
    }

    public static boolean isComment(int token) {
        return token == 1002 || token == 1003 || token == 1001;
    }
}

