/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class SimpleNameRenamer
extends ASTVisitor {
    private ASTRewrite fRewriter;
    private IBinding[] fBindings;
    private String[] fNewNames;

    private SimpleNameRenamer(ASTRewrite rewriter, IBinding[] bindings, String[] newNames) {
        this.fRewriter = rewriter;
        this.fBindings = bindings;
        this.fNewNames = newNames;
    }

    public static void perform(ASTRewrite rewriter, IBinding[] bindings, String[] newNames, ASTNode node) {
        SimpleNameRenamer changer = new SimpleNameRenamer(rewriter, bindings, newNames);
        node.accept((ASTVisitor)changer);
    }

    public static void perform(ASTRewrite rewriter, IBinding[] bindings, String[] newNames, ASTNode[] nodes) {
        SimpleNameRenamer changer = new SimpleNameRenamer(rewriter, bindings, newNames);
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept((ASTVisitor)changer);
            ++i;
        }
    }

    public boolean visit(MethodDeclaration node) {
        TypeDeclaration decl;
        String newName;
        if (node.isConstructor() && (newName = this.getNewName((IBinding)(decl = (TypeDeclaration)ASTNodes.getParent((ASTNode)node, 55)).resolveBinding())) != null) {
            this.rename(node.getName(), newName);
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        String newName = this.getNewName(node.resolveBinding());
        if (newName != null) {
            this.rename(node, newName);
        }
        return true;
    }

    private String getNewName(IBinding binding) {
        if (binding == null) {
            return null;
        }
        int i = 0;
        while (i < this.fBindings.length) {
            if (Bindings.equals(binding, this.fBindings[i])) {
                return this.fNewNames[i];
            }
            ++i;
        }
        return null;
    }

    private void rename(SimpleName node, String newName) {
        SimpleName newNode = node.getAST().newSimpleName(newName);
        this.fRewriter.markAsReplaced((ASTNode)node, (ASTNode)newNode);
    }
}

