/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class LocalVariableIndex
extends ASTVisitor {
    private int fTopIndex;

    public static int perform(MethodDeclaration method) {
        return LocalVariableIndex.doPerform((BodyDeclaration)method);
    }

    public static int perform(Initializer initializer) {
        return LocalVariableIndex.doPerform((BodyDeclaration)initializer);
    }

    private static int doPerform(BodyDeclaration node) {
        LocalVariableIndex counter = new LocalVariableIndex();
        node.accept((ASTVisitor)counter);
        return counter.fTopIndex;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    private void handleVariableBinding(IVariableBinding binding) {
        if (binding == null) {
            return;
        }
        this.fTopIndex = Math.max(this.fTopIndex, binding.getVariableId());
    }
}

