/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.internal.corext.textmanipulation.CopySourceEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.util.Strings;

public final class CopyIndentedSourceEdit
extends CopySourceEdit {
    private String fDestinationIndent;
    private int fSourceIndentLevel;
    private int fTabWidth;

    public CopyIndentedSourceEdit(int offset, int length) {
        super(offset, length);
        this.initialize(0, "", 4);
    }

    public void initialize(int sourceIndentLevel, String destIndentString, int tabWidth) {
        this.fSourceIndentLevel = sourceIndentLevel;
        this.fDestinationIndent = destIndentString;
        this.fTabWidth = tabWidth;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        TextRange range = this.getTextRange();
        CopyIndentedSourceEdit result = new CopyIndentedSourceEdit(range.getOffset(), range.getLength());
        result.initialize(this.fSourceIndentLevel, this.fDestinationIndent, this.fTabWidth);
        return result;
    }

    protected String computeContent(TextBuffer buffer) {
        String str = super.computeContent(buffer);
        int destIndentLevel = Strings.computeIndent(this.fDestinationIndent, this.fTabWidth);
        if (destIndentLevel == this.fSourceIndentLevel) {
            return str;
        }
        return Strings.changeIndent(str, this.fSourceIndentLevel, this.fTabWidth, this.fDestinationIndent, buffer.getLineDelimiter());
    }
}

