/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;

public class Bindings {
    private Bindings() {
    }

    public static boolean equals(IBinding b1, IBinding b2) {
        Assert.isTrue(b1 != null);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        String k1 = b1.getKey();
        String k2 = b2.getKey();
        if (k1 == null || k2 == null) {
            return false;
        }
        if (k1 != null) {
            return k1.equals(k2);
        }
        return k2.equals(k1);
    }

    public static String asString(IMethodBinding method) {
        StringBuffer result = new StringBuffer(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding type) {
        StringBuffer buffer = new StringBuffer();
        Bindings.createName(type, false, buffer);
        return buffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding type) {
        StringBuffer buffer = new StringBuffer();
        Bindings.createName(type, true, buffer);
        return buffer.toString();
    }

    private static void createName(ITypeBinding type, boolean includePackage, StringBuffer buffer) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, buffer);
                buffer.append('.');
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                buffer.append(baseType.getPackage().getName());
                buffer.append('.');
            }
        }
        if (!baseType.isAnonymous()) {
            buffer.append(type.getName());
        } else {
            buffer.append("$local$");
        }
    }

    private static void createName(ITypeBinding type, boolean includePackage, List list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String getFullyQualifiedImportName(ITypeBinding type) {
        if (type.isArray()) {
            return Bindings.getFullyQualifiedName(type.getElementType());
        }
        if (type.isAnonymous()) {
            return Bindings.getFullyQualifiedImportName(type.getSuperclass());
        }
        return Bindings.getFullyQualifiedName(type);
    }

    public static String[] getNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        return result.toArray(new String[result.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, true, result);
        return result.toArray(new String[result.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getDeclaringClass();
        while (parent != null) {
            type = parent;
            parent = type.getDeclaringClass();
        }
        return type;
    }

    public static Type createType(ITypeBinding binding, AST ast, boolean fullyQualify) {
        if (binding.isPrimitive()) {
            String name = binding.getName();
            return ast.newPrimitiveType(PrimitiveType.toCode((String)name));
        }
        if (binding.isArray()) {
            Type elementType = Bindings.createType(binding.getElementType(), ast, fullyQualify);
            return ast.newArrayType(elementType, binding.getDimensions());
        }
        if (fullyQualify) {
            return ast.newSimpleType(ast.newName(Bindings.getAllNameComponents(binding)));
        }
        return ast.newSimpleType(ast.newName(Bindings.getNameComponents(binding)));
    }

    public static boolean isRuntimeException(ITypeBinding thrownException, AST ast) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        ITypeBinding runTimeException = ast.resolveWellKnownType("java.lang.RuntimeException");
        while (thrownException != null) {
            if (runTimeException == thrownException) {
                return true;
            }
            thrownException = thrownException.getSuperclass();
        }
        return false;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        while (type != null) {
            IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
            if (method != null) {
                return method;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, ITypeBinding[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != methodParameters[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = Bindings.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static boolean findTypeInHierarchy(ITypeBinding hierarchyType, ITypeBinding type) {
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return false;
        }
        if (hierarchyType == type) {
            return true;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && Bindings.findTypeInHierarchy(superClass, type)) {
            return true;
        }
        if (type.isInterface()) {
            ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (Bindings.findTypeInHierarchy(superInterfaces[i], type)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

