/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class Binding2JavaModel {
    private Binding2JavaModel() {
    }

    /*
     * Unable to fully structure code
     */
    public static ICompilationUnit findCompilationUnit(ITypeBinding typeBinding, IJavaProject project) throws JavaModelException {
        if (typeBinding.isFromSource()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            typeBinding = typeBinding.getDeclaringClass();
lbl4:
            // 2 sources

            ** while (typeBinding != null && !typeBinding.isTopLevel())
        }
lbl5:
        // 1 sources

        if (typeBinding != null && (type = project.findType(packageName = (pack = typeBinding.getPackage()).isUnnamed() != false ? "" : pack.getName(), typeBinding.getName())) != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static IField find(IVariableBinding field, IJavaProject in) throws JavaModelException {
        Assert.isTrue(field.isField());
        ITypeBinding declaringClassBinding = field.getDeclaringClass();
        if (declaringClassBinding == null) {
            return null;
        }
        IType declaringClass = Binding2JavaModel.find(declaringClassBinding, in);
        if (declaringClass == null) {
            return null;
        }
        IField foundField = declaringClass.getField(field.getName());
        if (!foundField.exists()) {
            return null;
        }
        return foundField;
    }

    public static IType find(ITypeBinding type, IJavaProject scope) throws JavaModelException {
        if (type.isPrimitive()) {
            return null;
        }
        if (type.isNullType()) {
            return null;
        }
        if (type.isArray()) {
            return Binding2JavaModel.find(type.getElementType(), scope);
        }
        String[] typeElements = Bindings.getNameComponents(type);
        IJavaElement element = scope.findElement(Binding2JavaModel.getPathToCompilationUnit(type.getPackage(), typeElements[0]));
        IType candidate = null;
        if (element instanceof ICompilationUnit) {
            candidate = JavaModelUtil.toWorkingCopy((ICompilationUnit)element).getType(typeElements[0]);
        } else if (element instanceof IClassFile) {
            candidate = ((IClassFile)element).getType();
        } else if (element == null) {
            candidate = type.isMember() ? JavaModelUtil.findType(scope, Bindings.getFullyQualifiedImportName(type.getDeclaringClass())) : JavaModelUtil.findType(scope, Bindings.getFullyQualifiedImportName(type));
        }
        if (candidate == null || typeElements.length == 1) {
            return candidate;
        }
        return Binding2JavaModel.findTypeInType(typeElements, candidate);
    }

    public static IMethod find(IMethodBinding method, IType type) throws JavaModelException {
        IMethod[] candidates = type.getMethods();
        int i = 0;
        while (i < candidates.length) {
            IMethod candidate = candidates[i];
            if (candidate.getElementName().equals(method.getName()) && Binding2JavaModel.sameParameters(method, candidate)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    public static IMethod findIncludingSupertypes(IMethodBinding method, IType type, IProgressMonitor pm) throws JavaModelException {
        IMethod inThisType = Binding2JavaModel.find(method, type);
        if (inThisType != null) {
            return inThisType;
        }
        IType[] superTypes = JavaModelUtil.getAllSuperTypes(type, pm);
        int i = 0;
        while (i < superTypes.length) {
            IMethod m = Binding2JavaModel.find(method, superTypes[i]);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public static IMethod find(IMethodBinding method, IJavaProject scope) throws JavaModelException {
        IType type = Binding2JavaModel.find(method.getDeclaringClass(), scope);
        if (type == null) {
            return null;
        }
        return Binding2JavaModel.find(method, type);
    }

    private static IPath getPathToCompilationUnit(IPackageBinding packageBinding, String topLevelTypeName) {
        Path result = new Path("");
        String[] packageNames = packageBinding.getNameComponents();
        int i = 0;
        while (i < packageNames.length) {
            result = result.append(packageNames[i]);
            ++i;
        }
        return result.append(String.valueOf(topLevelTypeName) + ".java");
    }

    private static IType findTypeInType(String[] typeElements, IType jmType) {
        IType result = jmType;
        int i = 1;
        while (i < typeElements.length) {
            if (!(result = result.getType(typeElements[i])).exists()) {
                return null;
            }
            ++i;
        }
        return result == jmType ? null : result;
    }

    private static boolean sameParameters(IMethodBinding method, IMethod candidate) throws JavaModelException {
        String[] candidateParameters;
        ITypeBinding[] methodParamters = method.getParameterTypes();
        if (methodParamters.length != (candidateParameters = candidate.getParameterTypes()).length) {
            return false;
        }
        IType scope = candidate.getDeclaringType();
        int i = 0;
        while (i < methodParamters.length) {
            ITypeBinding methodParameter = methodParamters[i];
            String candidateParameter = candidateParameters[i];
            if (!Binding2JavaModel.sameParameter(methodParameter, candidateParameter, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding type, String candidate, IType scope) throws JavaModelException {
        if (type.getDimensions() != Signature.getArrayCount((String)candidate)) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (Binding2JavaModel.isPrimitiveType(candidate = Signature.getElementType((String)candidate)) || type.isPrimitive()) {
            return type.getName().equals(Signature.toString((String)candidate));
        }
        if (Binding2JavaModel.isResolvedType(candidate)) {
            return Signature.toString((String)candidate).equals(Bindings.getFullyQualifiedName(type));
        }
        String[][] qualifiedCandidates = scope.resolveType(Signature.toString((String)candidate));
        if (qualifiedCandidates == null || qualifiedCandidates.length == 0) {
            return false;
        }
        String packageName = type.getPackage().isUnnamed() ? "" : type.getPackage().getName();
        String typeName = Bindings.getTypeQualifiedName(type);
        int i = 0;
        while (i < qualifiedCandidates.length) {
            String[] qualifiedCandidate = qualifiedCandidates[i];
            if (qualifiedCandidate[0].equals(packageName) && qualifiedCandidate[1].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPrimitiveType(String s) {
        char c = s.charAt(0);
        return c != 'L' && c != 'Q';
    }

    private static boolean isResolvedType(String s) {
        int arrayCount = Signature.getArrayCount((String)s);
        return s.charAt(arrayCount) == 'L';
    }
}

