/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;

public class ASTWithExistingFlattener
extends ASTFlattener {
    private static final String KEY = "ExistingASTNode";
    private ArrayList fExistingNodes = new ArrayList(10);

    static ASTNode createPlaceholder(AST ast, Object data, int nodeType) {
        ReturnStatement placeHolder;
        switch (nodeType) {
            case 3: {
                placeHolder = ast.newSimpleName("z");
                break;
            }
            case 6: {
                placeHolder = ast.newSimpleType((Name)ast.newSimpleName("X"));
                break;
            }
            case 4: {
                placeHolder = ast.newReturnStatement();
                break;
            }
            case 2: {
                placeHolder = ast.newBlock();
                break;
            }
            case 1: {
                placeHolder = ast.newInitializer();
                break;
            }
            case 5: {
                placeHolder = ast.newSingleVariableDeclaration();
                break;
            }
            case 8: {
                placeHolder = ast.newVariableDeclarationFragment();
                break;
            }
            case 7: {
                placeHolder = ast.newJavadoc();
                break;
            }
            default: {
                return null;
            }
        }
        NodeMarker marker = new NodeMarker();
        marker.data = data;
        marker.offset = -1;
        marker.length = 0;
        placeHolder.setProperty(KEY, (Object)marker);
        return placeHolder;
    }

    private static NodeMarker getMarker(ASTNode node) {
        return (NodeMarker)node.getProperty(KEY);
    }

    public void reset() {
        super.reset();
        this.fExistingNodes.clear();
    }

    public NodeMarker[] getNodeMarkers() {
        return this.fExistingNodes.toArray(new NodeMarker[this.fExistingNodes.size()]);
    }

    public String getFormattedResult(int initialIndentationLevel, String lineDelimiter) {
        NodeMarker[] markers = this.getNodeMarkers();
        int nExistingNodes = markers.length;
        int[] positions = new int[nExistingNodes * 2];
        int i = 0;
        int k = 0;
        while (i < nExistingNodes) {
            int startPos = markers[i].offset;
            int length = markers[i].length;
            positions[k++] = startPos;
            positions[k++] = startPos + length - 1;
            ++i;
        }
        Hashtable map = JavaCore.getOptions();
        map.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(9999));
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter((Map)map);
        String formatted = formatter.format(this.getResult(), initialIndentationLevel, positions, lineDelimiter);
        int i2 = 0;
        int k2 = 0;
        while (i2 < nExistingNodes) {
            int startPos = positions[k2++];
            int endPos = positions[k2++] + 1;
            markers[i2].offset = startPos;
            markers[i2].length = endPos - startPos;
            ++i2;
        }
        return formatted;
    }

    public void preVisit(ASTNode node) {
        NodeMarker marker = ASTWithExistingFlattener.getMarker(node);
        if (marker != null) {
            marker.offset = this.fResult.length();
            this.fExistingNodes.add(marker);
        }
    }

    public void postVisit(ASTNode node) {
        NodeMarker marker = ASTWithExistingFlattener.getMarker(node);
        if (marker != null) {
            marker.length = this.fResult.length() - marker.offset;
        }
    }

    public static class NodeMarker {
        public Object data;
        public int offset;
        public int length;
    }
}

