/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;

public class ASTRewriteClear
extends ASTVisitor {
    private ASTRewrite fRewrite;

    public ASTRewriteClear(ASTRewrite rewrite) {
        this.fRewrite = rewrite;
    }

    private void clearList(List list) {
        int i = list.size() - 1;
        while (i >= 0) {
            ASTNode element = (ASTNode)list.get(i);
            if (this.fRewrite.isInserted(element)) {
                list.remove(i);
            }
            --i;
        }
    }

    private boolean isInserted(ASTNode node) {
        return node != null && this.fRewrite.isInserted(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.clearList(node.bodyDeclarations());
        return true;
    }

    public boolean visit(ArrayCreation node) {
        this.clearList(node.dimensions());
        if (this.isInserted((ASTNode)node.getInitializer())) {
            node.setInitializer(null);
        }
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        this.clearList(node.expressions());
        return true;
    }

    public boolean visit(AssertStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        if (this.isInserted((ASTNode)node.getMessage())) {
            node.setMessage(null);
        }
        return true;
    }

    public boolean visit(Block node) {
        this.clearList(node.statements());
        return true;
    }

    public boolean visit(BreakStatement node) {
        if (this.isInserted((ASTNode)node.getLabel())) {
            node.setLabel(null);
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        this.clearList(node.arguments());
        if (this.isInserted((ASTNode)node.getAnonymousClassDeclaration())) {
            node.setAnonymousClassDeclaration(null);
        }
        return true;
    }

    public boolean visit(CompilationUnit node) {
        if (this.isInserted((ASTNode)node.getPackage())) {
            node.setPackage(null);
        }
        this.clearList(node.imports());
        this.clearList(node.types());
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        this.clearList(node.arguments());
        return true;
    }

    public boolean visit(ContinueStatement node) {
        if (this.isInserted((ASTNode)node.getLabel())) {
            node.setLabel(null);
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        if (this.isInserted((ASTNode)node.getJavadoc())) {
            node.setJavadoc(null);
        }
        this.clearList(node.fragments());
        return true;
    }

    public boolean visit(ForStatement node) {
        this.clearList(node.initializers());
        this.clearList(node.updaters());
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        return true;
    }

    public boolean visit(IfStatement node) {
        if (this.isInserted((ASTNode)node.getElseStatement())) {
            node.setElseStatement(null);
        }
        return true;
    }

    public boolean visit(InfixExpression node) {
        this.clearList(node.extendedOperands());
        return true;
    }

    public boolean visit(Initializer node) {
        if (this.isInserted((ASTNode)node.getJavadoc())) {
            node.setJavadoc(null);
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.isInserted((ASTNode)node.getJavadoc())) {
            node.setJavadoc(null);
        }
        if (this.isInserted((ASTNode)node.getReturnType())) {
            node.setReturnType((Type)node.getAST().newPrimitiveType(PrimitiveType.VOID));
        }
        this.clearList(node.parameters());
        this.clearList(node.thrownExceptions());
        if (this.isInserted((ASTNode)node.getBody())) {
            node.setBody(null);
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        this.clearList(node.arguments());
        return true;
    }

    public boolean visit(ReturnStatement node) {
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (this.isInserted((ASTNode)node.getInitializer())) {
            node.setInitializer(null);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        this.clearList(node.arguments());
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        if (this.isInserted((ASTNode)node.getQualifier())) {
            node.setQualifier(null);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isInserted((ASTNode)node.getQualifier())) {
            node.setQualifier(null);
        }
        this.clearList(node.arguments());
        return true;
    }

    public boolean visit(SwitchCase node) {
        if (this.isInserted((ASTNode)node.getExpression())) {
            node.setExpression(null);
        }
        return true;
    }

    public boolean visit(SwitchStatement node) {
        this.clearList(node.statements());
        return true;
    }

    public boolean visit(ThisExpression node) {
        if (this.isInserted((ASTNode)node.getQualifier())) {
            node.setQualifier(null);
        }
        return true;
    }

    public boolean visit(TryStatement node) {
        this.clearList(node.catchClauses());
        if (this.isInserted((ASTNode)node.getFinally())) {
            node.setFinally(null);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.isInserted((ASTNode)node.getJavadoc())) {
            node.setJavadoc(null);
        }
        if (this.isInserted((ASTNode)node.getSuperclass())) {
            node.setSuperclass(null);
        }
        this.clearList(node.superInterfaces());
        this.clearList(node.bodyDeclarations());
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.clearList(node.fragments());
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.isInserted((ASTNode)node.getInitializer())) {
            node.setInitializer(null);
        }
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.clearList(node.fragments());
        return true;
    }

    public void postVisit(ASTNode node) {
        if (this.fRewrite.isInserted(node)) {
            Assert.isTrue(false, "Inserted node not removed " + node + ", parent: " + node.getParent());
        }
    }
}

