/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTWithExistingFlattener;
import org.eclipse.jdt.internal.corext.dom.CopyIndentedSourceEdit;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.textmanipulation.CopyTargetEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ASTRewriteAnalyzer
extends ASTVisitor {
    protected TextBuffer fTextBuffer;
    private TextEdit fCurrentEdit;
    private TokenScanner fTokenScanner;
    private ASTRewrite fRewrite;
    private HashMap fGroupDescriptions;
    private final int[] MODIFIERS = new int[]{103, 102, 101, 94, 99, 98, 100, 106, 104, 105, 85};

    public ASTRewriteAnalyzer(TextBuffer textBuffer, TextEdit rootEdit, ASTRewrite rewrite, HashMap resGroupDescriptions) {
        this.fTextBuffer = textBuffer;
        this.fTokenScanner = null;
        this.fRewrite = rewrite;
        this.fCurrentEdit = rootEdit;
        this.fGroupDescriptions = resGroupDescriptions;
    }

    final ListRewriter getDefaultRewriter() {
        return new ListRewriter();
    }

    final TokenScanner getScanner() {
        if (this.fTokenScanner == null) {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(this.fTextBuffer.getContent().toCharArray());
            this.fTokenScanner = new TokenScanner(scanner);
        }
        return this.fTokenScanner;
    }

    public static Object createSourceCopy(int offset, int length) {
        return new CopyIndentedSourceEdit(offset, length);
    }

    final boolean isChanged(ASTNode node) {
        return this.isInserted(node) || this.isRemoved(node) || this.isReplaced(node);
    }

    final boolean isInsertOrRemove(ASTNode node) {
        return this.isInserted(node) || this.isRemoved(node);
    }

    final boolean isInserted(ASTNode node) {
        return this.fRewrite.isInserted(node);
    }

    final boolean isReplaced(ASTNode node) {
        return this.fRewrite.isReplaced(node);
    }

    final boolean isRemoved(ASTNode node) {
        return this.fRewrite.isRemoved(node);
    }

    final boolean isModified(ASTNode node) {
        return this.fRewrite.isModified(node);
    }

    final ASTNode getModifiedNode(ASTNode node) {
        return this.fRewrite.getModifiedNode(node);
    }

    final ASTNode getReplacingNode(ASTNode node) {
        return this.fRewrite.getReplacingNode(node);
    }

    final String getDescription(ASTNode node) {
        if (this.fGroupDescriptions != null) {
            Assert.isTrue(this.isChanged(node) || this.isModified(node), "Tries to get description of node that is not changed or modified");
            return this.fRewrite.getDescription(node);
        }
        return null;
    }

    final TextEdit doTextInsert(int offset, String insertString, String description) {
        SimpleTextEdit edit = SimpleTextEdit.createInsert(offset, insertString);
        this.fCurrentEdit.add(edit);
        if (description != null) {
            this.addDescription(description, edit);
        }
        return edit;
    }

    final void addDescription(String description, TextEdit edit) {
        GroupDescription groupDesc = (GroupDescription)this.fGroupDescriptions.get(description);
        if (groupDesc == null) {
            groupDesc = new GroupDescription(description);
            this.fGroupDescriptions.put(description, groupDesc);
        }
        groupDesc.addTextEdit(edit);
    }

    final TextEdit doTextRemove(int offset, int len, String description) {
        SimpleTextEdit edit = SimpleTextEdit.createDelete(offset, len);
        this.fCurrentEdit.add(edit);
        if (description != null) {
            this.addDescription(description, edit);
        }
        return edit;
    }

    final TextEdit doTextRemoveAndVisit(int offset, int len, ASTNode node) {
        TextEdit edit;
        this.fCurrentEdit = edit = this.doTextRemove(offset, len, this.getDescription(node));
        this.doVisit(node);
        this.fCurrentEdit = edit.getParent();
        return edit;
    }

    final void doVisit(ASTNode node) {
        node.accept((ASTVisitor)this);
    }

    final TextEdit doTextReplace(int offset, int len, String insertString, String description) {
        SimpleTextEdit edit = SimpleTextEdit.createReplace(offset, len, insertString);
        this.fCurrentEdit.add(edit);
        if (description != null) {
            this.addDescription(description, edit);
        }
        return edit;
    }

    final TextEdit doTextCopy(ASTNode copiedNode, int destOffset, int sourceIndentLevel, String destIndentString, int tabWidth, String description) {
        CopyIndentedSourceEdit sourceEdit = (CopyIndentedSourceEdit)this.fRewrite.getCopySourceEdit(copiedNode);
        if (sourceEdit == null) {
            Assert.isTrue(false, "Copy source not annotated" + copiedNode.toString());
        }
        sourceEdit.initialize(sourceIndentLevel, destIndentString, tabWidth);
        CopyTargetEdit targetEdit = new CopyTargetEdit(destOffset, sourceEdit);
        this.fCurrentEdit.add(targetEdit);
        if (description != null) {
            this.addDescription(description, sourceEdit);
            this.addDescription(description, targetEdit);
        }
        return targetEdit;
    }

    private int getPosBeforeSpaces(int pos) {
        while (pos > 0 && Strings.isIndentChar(this.fTextBuffer.getChar(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private void checkNoModification(ASTNode node) {
        if (this.isModified(node)) {
            Assert.isTrue(false, "Can not modify " + node.getClass().getName());
        }
    }

    private void checkNoChange(ASTNode node) {
        if (this.isChanged(node)) {
            Assert.isTrue(false, "Can not insert or replace node in " + node.getParent().getClass().getName());
        }
    }

    private void checkNoInsertOrRemove(ASTNode node) {
        if (this.isInserted(node) || this.isRemoved(node)) {
            Assert.isTrue(false, "Can not insert or remove node " + node + " in " + node.getParent().getClass().getName());
        }
    }

    private int rewriteRequiredNode(ASTNode node) {
        this.checkNoInsertOrRemove(node);
        if (this.isReplaced(node)) {
            int offset = node.getStartPosition();
            this.doTextRemoveAndVisit(offset, node.getLength(), node);
            this.doTextInsert(offset, this.getReplacingNode(node), this.getIndent(offset), true, this.getDescription(node));
        } else {
            this.doVisit(node);
        }
        return node.getStartPosition() + node.getLength();
    }

    private int rewriteNode(ASTNode node, int offset, String prefix) {
        if (this.isInserted(node)) {
            String description = this.getDescription(node);
            this.doTextInsert(offset, prefix, description);
            this.doTextInsert(offset, node, this.getIndent(offset), true, description);
            return offset;
        }
        if (this.isRemoved(node)) {
            int len = node.getStartPosition() + node.getLength() - offset;
            this.doTextRemoveAndVisit(offset, len, node);
        } else if (this.isReplaced(node)) {
            this.doTextRemoveAndVisit(node.getStartPosition(), node.getLength(), node);
            this.doTextInsert(node.getStartPosition(), this.getReplacingNode(node), this.getIndent(offset), true, this.getDescription(node));
        } else {
            this.doVisit(node);
        }
        return node.getStartPosition() + node.getLength();
    }

    private int rewriteOptionalQualifier(ASTNode node, int startPos) {
        if (this.isInserted(node)) {
            String description = this.getDescription(node);
            this.doTextInsert(startPos, node, this.getIndent(startPos), true, description);
            this.doTextInsert(startPos, ".", description);
            return startPos;
        }
        if (this.isRemoved(node)) {
            try {
                int dotStart = node.getStartPosition() + node.getLength();
                int dotEnd = this.getScanner().getTokenEndOffset(6, dotStart);
                this.doTextRemoveAndVisit(startPos, dotEnd - startPos, node);
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else if (this.isReplaced(node)) {
            this.doTextRemoveAndVisit(startPos, node.getLength(), node);
            this.doTextInsert(startPos, this.getReplacingNode(node), this.getIndent(startPos), true, this.getDescription(node));
        } else {
            this.doVisit(node);
        }
        return node.getStartPosition() + node.getLength();
    }

    private int rewriteParagraphList(List list, int insertPos, int insertIndent, int separator) {
        boolean hasChanges = false;
        boolean hasExisting = false;
        int i = 0;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            hasChanges |= this.isChanged(elem);
            hasExisting |= !this.isInserted(elem);
            ++i;
        }
        if (!hasChanges) {
            return this.visitList(list, insertPos);
        }
        ParagraphListRewriter listRewriter = new ParagraphListRewriter(insertIndent, separator);
        StringBuffer lead = new StringBuffer();
        if (!hasExisting) {
            lead.append(this.fTextBuffer.getLineDelimiter());
            lead.append(this.fTextBuffer.getLineDelimiter());
            lead.append(CodeFormatterUtil.createIndentString(insertIndent));
        }
        return listRewriter.rewriteList(list, insertPos, lead.toString());
    }

    private int rewriteRequiredParagraph(ASTNode elem) {
        this.checkNoInsertOrRemove(elem);
        if (this.isReplaced(elem)) {
            this.replaceParagraph(elem);
        } else {
            this.doVisit(elem);
        }
        return elem.getStartPosition() + elem.getLength();
    }

    private ASTNode rewriteParagraph(ASTNode elem, ASTNode sibling, int insertPos, int insertIndent, int additionalNewLine, boolean useIndentOfSibling) {
        if (elem == null) {
            return sibling;
        }
        if (this.isInserted(elem)) {
            this.insertParagraph(elem, sibling, insertPos, insertIndent, additionalNewLine, useIndentOfSibling);
            return sibling;
        }
        if (this.isRemoved(elem)) {
            this.removeParagraph(elem);
        } else if (this.isReplaced(elem)) {
            this.replaceParagraph(elem);
        } else {
            this.doVisit(elem);
        }
        return elem;
    }

    private void rewriteMethodBody(MethodDeclaration methodDecl, Block body, int startPos) {
        if (this.isInserted((ASTNode)body)) {
            int endPos = methodDecl.getStartPosition() + methodDecl.getLength();
            String description = this.getDescription((ASTNode)body);
            this.doTextRemove(startPos, endPos - startPos, description);
            this.doTextInsert(startPos, " ", description);
            this.doTextInsert(startPos, (ASTNode)body, this.getIndent(methodDecl.getStartPosition()), true, description);
        } else if (this.isRemoved((ASTNode)body)) {
            int endPos = methodDecl.getStartPosition() + methodDecl.getLength();
            this.doTextRemoveAndVisit(startPos, endPos - startPos, (ASTNode)body);
            this.doTextInsert(startPos, ";", this.getDescription((ASTNode)body));
        } else if (this.isReplaced((ASTNode)body)) {
            this.doTextRemoveAndVisit(body.getStartPosition(), body.getLength(), (ASTNode)body);
            this.doTextInsert(body.getStartPosition(), this.getReplacingNode((ASTNode)body), this.getIndent(body.getStartPosition()), true, this.getDescription((ASTNode)body));
        } else {
            this.doVisit((ASTNode)body);
        }
    }

    private void rewriteExtraDimensions(int oldDim, int newDim, int pos, String description) {
        block5: {
            block4: {
                if (oldDim >= newDim) break block4;
                int i = oldDim;
                while (i < newDim) {
                    this.doTextInsert(pos, "[]", description);
                    ++i;
                }
                break block5;
            }
            if (newDim >= oldDim) break block5;
            try {
                this.getScanner().setOffset(pos);
                int i = newDim;
                while (i < oldDim) {
                    this.getScanner().readToToken(166);
                    ++i;
                }
                this.doTextRemove(pos, this.getScanner().getCurrentEndOffset() - pos, description);
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        }
    }

    final int getNextExistingStartPos(List list, int listStartIndex, int defaultOffset) {
        int i = listStartIndex;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            if (!this.isInserted(elem)) {
                return elem.getStartPosition();
            }
            ++i;
        }
        return defaultOffset;
    }

    final ASTNode findPreviousExistingNode(List list, ASTNode node) {
        ASTNode res = null;
        int i = 0;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            if (elem == node) {
                return res;
            }
            if (!this.isInserted(elem)) {
                res = elem;
            }
            ++i;
        }
        return null;
    }

    private boolean hasChanges(List list) {
        int i = 0;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            if (this.isChanged(elem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAllRemoved(List list) {
        int i = 0;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            if (!this.isRemoved(elem)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int visitList(List list, int defaultPos) {
        ASTNode curr = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            curr = (ASTNode)iter.next();
            this.doVisit(curr);
        }
        if (curr == null) {
            return defaultPos;
        }
        return curr.getStartPosition() + curr.getLength();
    }

    private int getEndLineOffset(int offset) {
        TextRegion lineRegion = this.fTextBuffer.getLineInformationOfOffset(offset);
        int pos = lineRegion.getOffset() + lineRegion.getLength();
        int i = offset;
        while (i < pos) {
            char ch = this.fTextBuffer.getChar(i);
            if (!Character.isWhitespace(ch)) {
                if (ch == '/' && i + 1 < pos && this.fTextBuffer.getChar(i + 1) == '/') {
                    return pos;
                }
                return i;
            }
            ++i;
        }
        return pos;
    }

    private void removeParagraph(ASTNode elem) {
        int start = elem.getStartPosition();
        int end = start + elem.getLength();
        end = this.getEndLineOffset(end);
        int startLine = this.fTextBuffer.getLineOfOffset(start);
        if (startLine > 0) {
            TextRegion prevRegion = this.fTextBuffer.getLineInformation(startLine - 1);
            int cutPos = prevRegion.getOffset() + prevRegion.getLength();
            try {
                if (this.getScanner().getNextStartOffset(cutPos, true) == start) {
                    start = cutPos;
                }
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        }
        this.doTextRemoveAndVisit(start, end - start, elem);
    }

    private void replaceParagraph(ASTNode elem) {
        int startLine = this.fTextBuffer.getLineOfOffset(elem.getStartPosition());
        int indent = this.fTextBuffer.getLineIndent(startLine, CodeFormatterUtil.getTabWidth());
        this.doTextRemoveAndVisit(elem.getStartPosition(), elem.getLength(), elem);
        this.doTextInsert(elem.getStartPosition(), this.getReplacingNode(elem), indent, true, this.getDescription(elem));
    }

    private void insertParagraph(ASTNode elem, ASTNode sibling, int insertPos, int indent, int additionalNewLines, boolean useIndentOfSibling) {
        String description = this.getDescription(elem);
        String newLines = null;
        if (additionalNewLines > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < additionalNewLines) {
                buf.append(this.fTextBuffer.getLineDelimiter());
                ++i;
            }
            newLines = buf.toString();
        }
        if (sibling != null) {
            if (useIndentOfSibling) {
                indent = this.getIndent(sibling.getStartPosition());
            }
            int end = sibling.getStartPosition() + sibling.getLength();
            insertPos = this.getEndLineOffset(end);
            if (newLines != null) {
                this.doTextInsert(insertPos, newLines, description);
                newLines = null;
            }
        }
        this.doTextInsert(insertPos, this.fTextBuffer.getLineDelimiter(), description);
        this.doTextInsert(insertPos, elem, indent, false, description);
        if (newLines != null) {
            this.doTextInsert(insertPos, newLines, description);
        }
    }

    final int getIndent(int pos) {
        int line = this.fTextBuffer.getLineOfOffset(pos);
        return this.fTextBuffer.getLineIndent(line, CodeFormatterUtil.getTabWidth());
    }

    final void doTextInsert(int insertOffset, ASTNode node, int initialIndentLevel, boolean removeLeadingIndent, String description) {
        ASTWithExistingFlattener flattener = new ASTWithExistingFlattener();
        node.accept((ASTVisitor)flattener);
        String formatted = flattener.getFormattedResult(initialIndentLevel, this.fTextBuffer.getLineDelimiter());
        ASTWithExistingFlattener.NodeMarker[] markers = flattener.getNodeMarkers();
        int tabWidth = CodeFormatterUtil.getTabWidth();
        int currPos = 0;
        if (removeLeadingIndent) {
            while (currPos < formatted.length() && Strings.isIndentChar(formatted.charAt(currPos))) {
                ++currPos;
            }
        }
        int i = 0;
        while (i < markers.length) {
            int offset = markers[i].offset;
            if (offset != currPos) {
                String insertStr = formatted.substring(currPos, offset);
                this.doTextInsert(insertOffset, insertStr, description);
            }
            String destIndentString = Strings.getIndentString(this.getCurrentLine(formatted, offset), tabWidth);
            Object data = markers[i].data;
            if (data instanceof ASTNode) {
                ASTNode existingNode = (ASTNode)data;
                int srcIndentLevel = this.getIndent(existingNode.getStartPosition());
                this.doTextCopy(existingNode, insertOffset, srcIndentLevel, destIndentString, tabWidth, description);
            } else if (data instanceof String) {
                String str = Strings.changeIndent((String)data, 0, tabWidth, destIndentString, this.fTextBuffer.getLineDelimiter());
                this.doTextInsert(insertOffset, str, description);
            }
            currPos = offset + markers[i].length;
            ++i;
        }
        if (currPos < formatted.length()) {
            String insertStr = formatted.substring(currPos);
            this.doTextInsert(insertOffset, insertStr, description);
        }
    }

    private String getCurrentLine(String str, int pos) {
        int i = pos - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (Strings.isLineDelimiterChar(ch)) {
                return str.substring(i + 1, pos);
            }
            --i;
        }
        return str.substring(0, pos);
    }

    private void rewriteModifiers(int offset, int oldModifiers, int newModifiers, String description) {
        if (oldModifiers == newModifiers) {
            return;
        }
        try {
            int startPos;
            int tok = this.getScanner().readNext(offset, true);
            int endPos = startPos = this.getScanner().getCurrentStartOffset();
            block15: while (true) {
                boolean keep = true;
                switch (tok) {
                    case 103: {
                        keep = Modifier.isPublic((int)newModifiers);
                        break;
                    }
                    case 102: {
                        keep = Modifier.isProtected((int)newModifiers);
                        break;
                    }
                    case 101: {
                        keep = Modifier.isPrivate((int)newModifiers);
                        break;
                    }
                    case 94: {
                        keep = Modifier.isStatic((int)newModifiers);
                        break;
                    }
                    case 99: {
                        keep = Modifier.isFinal((int)newModifiers);
                        break;
                    }
                    case 98: {
                        keep = Modifier.isAbstract((int)newModifiers);
                        break;
                    }
                    case 100: {
                        keep = Modifier.isNative((int)newModifiers);
                        break;
                    }
                    case 106: {
                        keep = Modifier.isVolatile((int)newModifiers);
                        break;
                    }
                    case 104: {
                        keep = Modifier.isStrictfp((int)newModifiers);
                        break;
                    }
                    case 105: {
                        keep = Modifier.isTransient((int)newModifiers);
                        break;
                    }
                    case 85: {
                        keep = Modifier.isSynchronized((int)newModifiers);
                        break;
                    }
                    default: {
                        break block15;
                    }
                }
                tok = this.getScanner().readNext(true);
                int currPos = endPos;
                endPos = this.getScanner().getCurrentStartOffset();
                if (keep) continue;
                this.doTextRemove(currPos, endPos - currPos, description);
            }
            int addedModifiers = newModifiers & ~oldModifiers;
            if (addedModifiers != 0) {
                int visibilityModifiers;
                if (startPos != endPos && (visibilityModifiers = addedModifiers & 7) != 0) {
                    StringBuffer buf = new StringBuffer();
                    ASTFlattener.printModifiers(visibilityModifiers, buf);
                    this.doTextInsert(startPos, buf.toString(), description);
                    addedModifiers &= ~visibilityModifiers;
                }
                StringBuffer buf = new StringBuffer();
                ASTFlattener.printModifiers(addedModifiers, buf);
                this.doTextInsert(endPos, buf.toString(), description);
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    public void postVisit(ASTNode node) {
        TextEdit edit = (TextEdit)this.fRewrite.getCopySourceEdit(node);
        if (edit != null) {
            int endPos = node.getStartPosition() + node.getLength();
            if (edit.getTextRange().getExclusiveEnd() == endPos) {
                this.fCurrentEdit = this.fCurrentEdit.getParent();
            }
        }
    }

    public void preVisit(ASTNode node) {
        TextEdit edit = (TextEdit)this.fRewrite.getCopySourceEdit(node);
        if (edit != null && edit.getTextRange().getOffset() == node.getStartPosition()) {
            this.fCurrentEdit.add(edit);
            this.fCurrentEdit = edit;
        }
    }

    public boolean visit(CompilationUnit node) {
        PackageDeclaration packageDeclaration = node.getPackage();
        ASTNode last = this.rewriteParagraph((ASTNode)packageDeclaration, null, 0, 0, 1, false);
        List imports = node.imports();
        int startPos = last != null ? last.getStartPosition() + last.getLength() : 0;
        startPos = this.rewriteParagraphList(imports, startPos, 0, 0);
        List types = node.types();
        this.rewriteParagraphList(types, startPos, 0, -1);
        return false;
    }

    public boolean visit(TypeDeclaration typeDecl) {
        String keyword;
        boolean invertType = false;
        if (this.isModified((ASTNode)typeDecl)) {
            TypeDeclaration modifiedNode = (TypeDeclaration)this.getModifiedNode((ASTNode)typeDecl);
            int modfiedModifiers = modifiedNode.getModifiers();
            this.rewriteModifiers(typeDecl.getStartPosition(), typeDecl.getModifiers(), modfiedModifiers, this.getDescription((ASTNode)typeDecl));
            if (modifiedNode.isInterface() != typeDecl.isInterface()) {
                invertType = true;
                try {
                    int typeToken = typeDecl.isInterface() ? 180 : 165;
                    this.getScanner().readToToken(typeToken, typeDecl.getStartPosition());
                    String str = typeDecl.isInterface() ? "class" : "interface";
                    int start = this.getScanner().getCurrentStartOffset();
                    int end = this.getScanner().getCurrentEndOffset();
                    this.doTextReplace(start, end - start, str, this.getDescription((ASTNode)typeDecl));
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
        int pos = this.rewriteRequiredNode((ASTNode)typeDecl.getName());
        Name superClass = typeDecl.getSuperclass();
        if ((!typeDecl.isInterface() || invertType) && superClass != null) {
            if (this.isInserted((ASTNode)superClass)) {
                String str = " extends " + ASTNodes.asString((ASTNode)superClass);
                this.doTextInsert(pos, str, this.getDescription((ASTNode)superClass));
            } else {
                if (this.isRemoved((ASTNode)superClass)) {
                    int endPos = superClass.getStartPosition() + superClass.getLength();
                    this.doTextRemoveAndVisit(pos, endPos - pos, (ASTNode)superClass);
                } else if (this.isReplaced((ASTNode)superClass)) {
                    this.doTextRemoveAndVisit(superClass.getStartPosition(), superClass.getLength(), (ASTNode)superClass);
                    this.doTextInsert(superClass.getStartPosition(), this.getReplacingNode((ASTNode)superClass), 0, false, this.getDescription((ASTNode)superClass));
                } else {
                    this.doVisit((ASTNode)superClass);
                }
                pos = superClass.getStartPosition() + superClass.getLength();
            }
        }
        List interfaces = typeDecl.superInterfaces();
        String string = keyword = typeDecl.isInterface() != invertType ? " extends " : " implements ";
        if (invertType && !this.isAllRemoved(interfaces)) {
            int firstStart = this.getNextExistingStartPos(interfaces, 0, pos);
            this.doTextReplace(pos, firstStart - pos, keyword, this.getDescription((ASTNode)typeDecl));
            keyword = "";
            pos = firstStart;
        }
        pos = this.hasChanges(interfaces) ? this.getDefaultRewriter().rewriteList(interfaces, pos, keyword, ", ") : this.visitList(interfaces, pos);
        List members = typeDecl.bodyDeclarations();
        try {
            int startIndent = this.getIndent(typeDecl.getStartPosition()) + 1;
            int startPos = this.getScanner().getTokenEndOffset(110, pos);
            this.rewriteParagraphList(members, startPos, startIndent, -1);
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public boolean visit(MethodDeclaration methodDecl) {
        boolean willBeConstructor = methodDecl.isConstructor();
        if (this.isModified((ASTNode)methodDecl)) {
            MethodDeclaration modifiedNode = (MethodDeclaration)this.getModifiedNode((ASTNode)methodDecl);
            this.rewriteModifiers(methodDecl.getStartPosition(), methodDecl.getModifiers(), modifiedNode.getModifiers(), this.getDescription((ASTNode)methodDecl));
            willBeConstructor = modifiedNode.isConstructor();
        }
        Type returnType = methodDecl.getReturnType();
        if (!willBeConstructor || this.isRemoved((ASTNode)returnType)) {
            try {
                int startPos = methodDecl.getStartPosition();
                if (this.isInsertOrRemove((ASTNode)returnType)) {
                    startPos = this.getScanner().readAfterTokens(this.MODIFIERS, true, startPos, startPos);
                }
                if (startPos == methodDecl.getName().getStartPosition()) {
                    this.rewriteNode((ASTNode)returnType, startPos, "");
                    if (this.isInserted((ASTNode)returnType)) {
                        this.doTextInsert(startPos, " ", this.getDescription((ASTNode)returnType));
                    }
                } else {
                    this.rewriteNode((ASTNode)returnType, startPos, " ");
                }
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        }
        int pos = this.rewriteRequiredNode((ASTNode)methodDecl.getName());
        try {
            List parameters = methodDecl.parameters();
            if (this.hasChanges(parameters)) {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                pos = this.getDefaultRewriter().rewriteList(parameters, pos, "", ", ");
            } else {
                pos = this.visitList(parameters, pos);
            }
            if (this.isModified((ASTNode)methodDecl)) {
                int newDim;
                MethodDeclaration modifedNode = (MethodDeclaration)this.getModifiedNode((ASTNode)methodDecl);
                int oldDim = methodDecl.getExtraDimensions();
                if (oldDim != (newDim = modifedNode.getExtraDimensions())) {
                    int offset = this.getScanner().getTokenEndOffset(86, pos);
                    this.rewriteExtraDimensions(oldDim, newDim, offset, this.getDescription((ASTNode)methodDecl));
                }
            }
            List exceptions = methodDecl.thrownExceptions();
            boolean hasExceptionChanges = this.hasChanges(exceptions);
            Block body = methodDecl.getBody();
            if (hasExceptionChanges || body != null && this.isInsertOrRemove((ASTNode)body)) {
                pos = this.getScanner().getTokenEndOffset(86, pos);
                int dim = methodDecl.getExtraDimensions();
                while (dim > 0) {
                    pos = this.getScanner().getTokenEndOffset(166, pos);
                    --dim;
                }
            }
            pos = hasExceptionChanges ? this.getDefaultRewriter().rewriteList(exceptions, pos, " throws ", ", ") : this.visitList(exceptions, pos);
            if (body != null) {
                this.rewriteMethodBody(methodDecl, body, pos);
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public boolean visit(Block block) {
        List list = block.statements();
        int startPos = block.getStartPosition() + 1;
        int startIndent = 0;
        if (!list.isEmpty() && this.isInserted((ASTNode)list.get(0))) {
            startIndent = this.getIndent(block.getStartPosition()) + 1;
        }
        ASTNode last = null;
        int i = 0;
        while (i < list.size()) {
            ASTNode elem = (ASTNode)list.get(i);
            last = this.rewriteParagraph(elem, last, startPos, startIndent, 0, true);
            ++i;
        }
        return false;
    }

    public boolean visit(ReturnStatement node) {
        Expression expression = node.getExpression();
        if (expression != null) {
            if (this.isChanged((ASTNode)expression)) {
                try {
                    int offset = this.getScanner().getTokenEndOffset(124, node.getStartPosition());
                    this.rewriteNode((ASTNode)expression, offset, " ");
                }
                catch (InvalidInputException e) {
                    JavaPlugin.log(e);
                }
            } else {
                this.doVisit((ASTNode)expression);
            }
        }
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        List declarations = node.bodyDeclarations();
        int startPos = node.getStartPosition() + 1;
        int startIndent = this.getIndent(node.getStartPosition()) + 1;
        this.rewriteParagraphList(declarations, startPos, startIndent, -1);
        return false;
    }

    public boolean visit(ArrayAccess node) {
        this.rewriteRequiredNode((ASTNode)node.getArray());
        this.rewriteRequiredNode((ASTNode)node.getIndex());
        return false;
    }

    public boolean visit(ArrayCreation node) {
        int nOldBrackets;
        ArrayType arrayType = node.getType();
        int nNewBrackets = nOldBrackets = arrayType.getDimensions();
        String description = null;
        this.checkNoInsertOrRemove((ASTNode)arrayType);
        if (this.isReplaced((ASTNode)arrayType)) {
            ArrayType replacingType = (ArrayType)this.getReplacingNode((ASTNode)arrayType);
            description = this.getDescription((ASTNode)arrayType);
            Assert.isTrue(replacingType != null, "Cant remove array type in ArrayCreation");
            Type newType = replacingType.getElementType();
            Type oldType = arrayType.getElementType();
            if (!newType.equals((Object)oldType)) {
                this.doTextRemove(oldType.getStartPosition(), oldType.getLength(), description);
                this.doTextInsert(oldType.getStartPosition(), (ASTNode)newType, 0, false, description);
            }
            nNewBrackets = replacingType.getDimensions();
        }
        this.doVisit((ASTNode)arrayType);
        List dimExpressions = node.dimensions();
        try {
            int offset = this.getScanner().getTokenStartOffset(15, arrayType.getStartPosition());
            int i = 0;
            while (i < dimExpressions.size()) {
                ASTNode elem = (ASTNode)dimExpressions.get(i);
                if (this.isInserted(elem)) {
                    description = this.getDescription(elem);
                    this.doTextInsert(offset, "[", description);
                    this.doTextInsert(offset, elem, 0, false, description);
                    this.doTextInsert(offset, "]", description);
                    --nNewBrackets;
                } else {
                    int elemEnd = elem.getStartPosition() + elem.getLength();
                    int endPos = this.getScanner().getTokenEndOffset(166, elemEnd);
                    if (this.isRemoved(elem)) {
                        description = this.getDescription(elem);
                        this.doTextRemoveAndVisit(offset, endPos - offset, elem);
                    } else if (this.isReplaced(elem)) {
                        description = this.getDescription(elem);
                        this.doTextRemoveAndVisit(elem.getStartPosition(), elem.getLength(), elem);
                        this.doTextInsert(elem.getStartPosition(), this.getReplacingNode(elem), 0, false, description);
                        --nNewBrackets;
                    } else {
                        this.doVisit(elem);
                        --nNewBrackets;
                    }
                    offset = endPos;
                    --nOldBrackets;
                }
                ++i;
            }
            this.rewriteExtraDimensions(nOldBrackets, nNewBrackets, offset, description);
            ArrayInitializer initializer = node.getInitializer();
            if (initializer != null) {
                int pos = node.getStartPosition() + node.getLength();
                if (this.isRemoved((ASTNode)initializer)) {
                    pos = this.getPosBeforeSpaces(initializer.getStartPosition());
                }
                this.rewriteNode((ASTNode)initializer, pos, " ");
            }
        }
        catch (InvalidInputException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        List expressions = node.expressions();
        if (this.hasChanges(expressions)) {
            this.getDefaultRewriter().rewriteList(expressions, node.getStartPosition() + 1, "", ", ");
        } else {
            this.visitList(expressions, node.getStartPosition() + 1);
        }
        return false;
    }

    public boolean visit(ArrayType node) {
        this.rewriteRequiredNode((ASTNode)node.getComponentType());
        return false;
    }

    public boolean visit(AssertStatement node) {
        int offset = this.rewriteRequiredNode((ASTNode)node.getExpression());
        if (node.getMessage() != null) {
            this.rewriteNode((ASTNode)node.getMessage(), offset, " : ");
        }
        return false;
    }

    public boolean visit(Assignment node) {
        Expression leftHand = node.getLeftHandSide();
        int pos = this.rewriteRequiredNode((ASTNode)leftHand);
        if (this.isModified((ASTNode)node)) {
            try {
                this.getScanner().readNext(pos, true);
                Assignment.Operator modifiedOp = ((Assignment)this.getModifiedNode((ASTNode)node)).getOperator();
                this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), modifiedOp.toString(), this.getDescription((ASTNode)node));
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        }
        Expression rightHand = node.getRightHandSide();
        this.rewriteRequiredNode((ASTNode)rightHand);
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(BreakStatement node) {
        SimpleName label = node.getLabel();
        if (label != null) {
            if (this.isChanged((ASTNode)label)) {
                try {
                    int offset = this.getScanner().getTokenEndOffset(119, node.getStartPosition());
                    this.rewriteNode((ASTNode)label, offset, " ");
                }
                catch (InvalidInputException e) {
                    JavaPlugin.log(e);
                }
            } else {
                this.doVisit((ASTNode)label);
            }
        }
        return false;
    }

    public boolean visit(CastExpression node) {
        this.rewriteRequiredNode((ASTNode)node.getType());
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        return false;
    }

    public boolean visit(CatchClause node) {
        this.rewriteRequiredNode((ASTNode)node.getException());
        this.rewriteRequiredParagraph((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        Expression expression = node.getExpression();
        if (expression != null) {
            this.rewriteOptionalQualifier((ASTNode)expression, node.getStartPosition());
        }
        Name name = node.getName();
        int pos = this.rewriteRequiredNode((ASTNode)name);
        List arguments = node.arguments();
        if (this.hasChanges(arguments)) {
            try {
                int startpos = this.getScanner().getTokenEndOffset(7, pos);
                this.getDefaultRewriter().rewriteList(arguments, startpos, "", ", ");
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(arguments, 0);
        }
        AnonymousClassDeclaration decl = node.getAnonymousClassDeclaration();
        if (decl != null) {
            pos = node.getStartPosition() + node.getLength();
            if (this.isRemoved((ASTNode)decl)) {
                pos = this.getPosBeforeSpaces(decl.getStartPosition());
            }
            this.rewriteNode((ASTNode)decl, pos, " ");
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        this.rewriteRequiredNode((ASTNode)node.getThenExpression());
        this.rewriteRequiredNode((ASTNode)node.getElseExpression());
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        List arguments = node.arguments();
        if (this.hasChanges(arguments)) {
            try {
                int startpos = this.getScanner().getTokenEndOffset(7, node.getStartPosition());
                this.getDefaultRewriter().rewriteList(arguments, startpos, "", ", ");
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(arguments, 0);
        }
        return false;
    }

    public boolean visit(ContinueStatement node) {
        SimpleName label = node.getLabel();
        if (label != null) {
            if (this.isChanged((ASTNode)label)) {
                try {
                    int offset = this.getScanner().getTokenEndOffset(120, node.getStartPosition());
                    this.rewriteNode((ASTNode)label, offset, " ");
                }
                catch (InvalidInputException e) {
                    JavaPlugin.log(e);
                }
            } else {
                this.doVisit((ASTNode)label);
            }
        }
        return false;
    }

    public boolean visit(DoStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getBody());
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        this.rewriteRequiredNode((ASTNode)node.getName());
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (this.isModified((ASTNode)node)) {
            FieldDeclaration modifedNode = (FieldDeclaration)this.getModifiedNode((ASTNode)node);
            this.rewriteModifiers(node.getStartPosition(), node.getModifiers(), modifedNode.getModifiers(), this.getDescription((ASTNode)node));
        }
        Type type = node.getType();
        this.rewriteRequiredNode((ASTNode)type);
        List fragments = node.fragments();
        if (this.hasChanges(fragments)) {
            int startPos = this.getNextExistingStartPos(fragments, 0, type.getStartPosition() + type.getLength());
            this.getDefaultRewriter().rewriteList(fragments, startPos, "", ", ");
        } else {
            this.visitList(fragments, 0);
        }
        return false;
    }

    public boolean visit(ForStatement node) {
        try {
            List updaters;
            int pos = node.getStartPosition();
            List initializers = node.initializers();
            if (this.hasChanges(initializers)) {
                int startOffset = this.getScanner().getTokenEndOffset(7, pos);
                pos = this.getDefaultRewriter().rewriteList(initializers, startOffset, "", ", ");
            } else {
                pos = this.visitList(initializers, pos);
            }
            pos = this.getScanner().getTokenEndOffset(64, pos);
            Expression expression = node.getExpression();
            if (expression != null) {
                this.rewriteNode((ASTNode)expression, pos, "");
            }
            if (this.hasChanges(updaters = node.updaters())) {
                int startOffset = this.getScanner().getTokenEndOffset(64, pos);
                this.getDefaultRewriter().rewriteList(updaters, startOffset, "", ", ");
            } else {
                this.visitList(updaters, 0);
            }
        }
        catch (InvalidInputException e) {
            JavaPlugin.log(e);
        }
        this.rewriteRequiredNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(IfStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        Statement thenStatement = node.getThenStatement();
        this.rewriteRequiredNode((ASTNode)thenStatement);
        Statement elseStatement = node.getElseStatement();
        if (elseStatement != null) {
            int startPos = thenStatement.getStartPosition() + thenStatement.getLength();
            this.rewriteNode((ASTNode)elseStatement, startPos, " else ");
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        Name name = node.getName();
        this.rewriteRequiredNode((ASTNode)name);
        if (this.isModified((ASTNode)node)) {
            ImportDeclaration modifiedNode = (ImportDeclaration)this.getModifiedNode((ASTNode)node);
            if (!node.isOnDemand() && modifiedNode.isOnDemand()) {
                this.doTextInsert(name.getStartPosition() + name.getLength(), ".*", this.getDescription((ASTNode)node));
            } else if (node.isOnDemand() && !modifiedNode.isOnDemand()) {
                try {
                    int startPos = name.getStartPosition() + name.getLength();
                    int endPos = this.getScanner().getTokenStartOffset(64, startPos);
                    this.doTextRemove(startPos, endPos - startPos, this.getDescription((ASTNode)node));
                }
                catch (InvalidInputException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return false;
    }

    private void replaceOperation(int posBeforeOperation, String newOperation, String description) {
        try {
            this.getScanner().readNext(posBeforeOperation, true);
            this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), newOperation, description);
        }
        catch (InvalidInputException e) {
            JavaPlugin.log(e);
        }
    }

    public boolean visit(InfixExpression node) {
        InfixExpression.Operator modifiedOp;
        String newOperation;
        Expression leftHand = node.getLeftOperand();
        int pos = this.rewriteRequiredNode((ASTNode)leftHand);
        String operation = node.getOperator().toString();
        boolean needsNewOperation = false;
        if (this.isModified((ASTNode)node) && !(newOperation = (modifiedOp = ((InfixExpression)this.getModifiedNode((ASTNode)node)).getOperator()).toString()).equals(operation)) {
            operation = newOperation;
            needsNewOperation = true;
            this.replaceOperation(pos, operation, this.getDescription((ASTNode)node));
        }
        Expression rightHand = node.getRightOperand();
        pos = this.rewriteRequiredNode((ASTNode)rightHand);
        List extendedOperands = node.extendedOperands();
        if (needsNewOperation || this.hasChanges(extendedOperands)) {
            String prefixString = String.valueOf(' ') + operation + ' ';
            int i = 0;
            while (i < extendedOperands.size()) {
                ASTNode elem = (ASTNode)extendedOperands.get(i);
                if (needsNewOperation && !this.isRemoved(elem) && !this.isInserted(elem)) {
                    this.replaceOperation(pos, operation, this.getDescription((ASTNode)node));
                }
                pos = this.rewriteNode(elem, pos, prefixString);
                ++i;
            }
        } else {
            this.visitList(extendedOperands, 0);
        }
        return false;
    }

    public boolean visit(Initializer node) {
        if (this.isModified((ASTNode)node)) {
            Initializer modifedNode = (Initializer)this.getModifiedNode((ASTNode)node);
            this.rewriteModifiers(node.getStartPosition(), node.getModifiers(), modifedNode.getModifiers(), this.getDescription((ASTNode)node));
        }
        this.rewriteRequiredNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        this.rewriteRequiredNode((ASTNode)node.getLeftOperand());
        this.rewriteRequiredNode((ASTNode)node.getRightOperand());
        return false;
    }

    public boolean visit(Javadoc node) {
        this.checkNoChange((ASTNode)node);
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getLabel());
        this.rewriteRequiredNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(MethodInvocation node) {
        Expression optExpression = node.getExpression();
        if (optExpression != null) {
            this.rewriteOptionalQualifier((ASTNode)optExpression, node.getStartPosition());
        }
        int pos = this.rewriteRequiredNode((ASTNode)node.getName());
        List arguments = node.arguments();
        if (this.hasChanges(arguments)) {
            try {
                int startOffset = this.getScanner().getTokenEndOffset(7, pos);
                this.getDefaultRewriter().rewriteList(arguments, startOffset, "", ", ");
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(arguments, 0);
        }
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        this.rewriteRequiredNode((ASTNode)node.getName());
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        return false;
    }

    public boolean visit(PostfixExpression node) {
        String oldOperation;
        PostfixExpression.Operator modifiedOp;
        String newOperation;
        int pos = this.rewriteRequiredNode((ASTNode)node.getOperand());
        if (this.isModified((ASTNode)node) && !(newOperation = (modifiedOp = ((PostfixExpression)this.getModifiedNode((ASTNode)node)).getOperator()).toString()).equals(oldOperation = node.getOperator().toString())) {
            this.replaceOperation(pos, newOperation, this.getDescription((ASTNode)node));
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        String oldOperation;
        PrefixExpression.Operator modifiedOp;
        String newOperation;
        if (this.isModified((ASTNode)node) && !(newOperation = (modifiedOp = ((PrefixExpression)this.getModifiedNode((ASTNode)node)).getOperator()).toString()).equals(oldOperation = node.getOperator().toString())) {
            this.replaceOperation(node.getStartPosition(), newOperation, this.getDescription((ASTNode)node));
        }
        this.rewriteRequiredNode((ASTNode)node.getOperand());
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.rewriteRequiredNode((ASTNode)node.getQualifier());
        this.rewriteRequiredNode((ASTNode)node.getName());
        return false;
    }

    public boolean visit(SimpleName node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(SimpleType node) {
        this.rewriteRequiredNode((ASTNode)node.getName());
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        Expression initializer;
        if (this.isModified((ASTNode)node)) {
            SingleVariableDeclaration modifedNode = (SingleVariableDeclaration)this.getModifiedNode((ASTNode)node);
            this.rewriteModifiers(node.getStartPosition(), node.getModifiers(), modifedNode.getModifiers(), this.getDescription((ASTNode)node));
        }
        this.rewriteRequiredNode((ASTNode)node.getType());
        int pos = this.rewriteRequiredNode((ASTNode)node.getName());
        if (this.isModified((ASTNode)node)) {
            String description = this.getDescription((ASTNode)node);
            SingleVariableDeclaration modifedNode = (SingleVariableDeclaration)this.getModifiedNode((ASTNode)node);
            this.rewriteExtraDimensions(node.getExtraDimensions(), modifedNode.getExtraDimensions(), pos, description);
        }
        if ((initializer = node.getInitializer()) != null) {
            this.rewriteNode((ASTNode)node, pos, " = ");
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.checkNoModification((ASTNode)node);
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        List arguments;
        int pos = node.getStartPosition();
        Expression optExpression = node.getExpression();
        if (optExpression != null) {
            pos = this.rewriteOptionalQualifier((ASTNode)optExpression, pos);
        }
        if (this.hasChanges(arguments = node.arguments())) {
            try {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                this.getDefaultRewriter().rewriteList(arguments, pos, "", ", ");
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(arguments, 0);
        }
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        int pos = node.getStartPosition();
        Name optExpression = node.getQualifier();
        if (optExpression != null) {
            pos = this.rewriteOptionalQualifier((ASTNode)optExpression, pos);
        }
        this.rewriteRequiredNode((ASTNode)node.getName());
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        int pos = node.getStartPosition();
        Name optExpression = node.getQualifier();
        if (optExpression != null) {
            pos = this.rewriteOptionalQualifier((ASTNode)optExpression, pos);
        }
        this.rewriteRequiredNode((ASTNode)node.getName());
        List arguments = node.arguments();
        if (this.hasChanges(arguments)) {
            try {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                this.getDefaultRewriter().rewriteList(arguments, pos, "", ", ");
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(arguments, 0);
        }
        return false;
    }

    public boolean visit(SwitchCase node) {
        Expression expression = node.getExpression();
        if (expression != null) {
            this.rewriteRequiredNode((ASTNode)expression);
        }
        return false;
    }

    public boolean visit(SwitchStatement node) {
        int pos = this.rewriteRequiredNode((ASTNode)node.getExpression());
        List statements = node.statements();
        if (this.hasChanges(statements)) {
            try {
                pos = this.getScanner().getTokenEndOffset(110, pos);
                int insertIndent = this.getIndent(node.getStartPosition()) + 1;
                ASTNode last = null;
                int i = 0;
                while (i < statements.size()) {
                    ASTNode elem = (ASTNode)statements.get(i);
                    int currIndent = elem.getNodeType() == 49 ? insertIndent : insertIndent + 1;
                    last = this.rewriteParagraph(elem, last, pos, currIndent, 0, false);
                    ++i;
                }
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.visitList(statements, pos);
        }
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        this.rewriteRequiredNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(ThisExpression node) {
        Name optExpression = node.getQualifier();
        if (optExpression != null) {
            this.rewriteOptionalQualifier((ASTNode)optExpression, node.getStartPosition());
        }
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        return false;
    }

    public boolean visit(TryStatement node) {
        int pos = this.rewriteRequiredNode((ASTNode)node.getBody());
        List catchBlocks = node.catchClauses();
        pos = this.hasChanges(catchBlocks) ? this.getDefaultRewriter().rewriteList(catchBlocks, pos, " ", " ") : this.visitList(catchBlocks, pos);
        Block finallyBlock = node.getFinally();
        if (finallyBlock != null) {
            this.rewriteNode((ASTNode)finallyBlock, pos, " finally ");
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getTypeDeclaration());
        return false;
    }

    public boolean visit(TypeLiteral node) {
        this.rewriteRequiredNode((ASTNode)node.getType());
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (this.isModified((ASTNode)node)) {
            VariableDeclarationExpression modifedNode = (VariableDeclarationExpression)this.getModifiedNode((ASTNode)node);
            this.rewriteModifiers(node.getStartPosition(), node.getModifiers(), modifedNode.getModifiers(), this.getDescription((ASTNode)node));
        }
        Type type = node.getType();
        this.rewriteRequiredNode((ASTNode)type);
        List fragments = node.fragments();
        if (this.hasChanges(fragments)) {
            int startPos = this.getNextExistingStartPos(fragments, 0, type.getStartPosition() + type.getLength());
            this.getDefaultRewriter().rewriteList(fragments, startPos, "", ", ");
        } else {
            this.visitList(fragments, 0);
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        Expression initializer;
        int pos = this.rewriteRequiredNode((ASTNode)node.getName());
        if (this.isModified((ASTNode)node)) {
            String description = this.getDescription((ASTNode)node);
            VariableDeclarationFragment modifedNode = (VariableDeclarationFragment)this.getModifiedNode((ASTNode)node);
            this.rewriteExtraDimensions(node.getExtraDimensions(), modifedNode.getExtraDimensions(), pos, description);
        }
        if ((initializer = node.getInitializer()) != null) {
            if (this.isRemoved((ASTNode)initializer)) {
                int dim = node.getExtraDimensions();
                if (dim > 0) {
                    try {
                        int i = 0;
                        while (i < dim) {
                            pos = this.getScanner().getTokenEndOffset(166, pos);
                            ++i;
                        }
                    }
                    catch (InvalidInputException e) {
                        JavaPlugin.log(e);
                    }
                }
            } else {
                pos = node.getStartPosition() + node.getLength();
            }
            this.rewriteNode((ASTNode)initializer, pos, " = ");
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (this.isModified((ASTNode)node)) {
            VariableDeclarationStatement modifedNode = (VariableDeclarationStatement)this.getModifiedNode((ASTNode)node);
            this.rewriteModifiers(node.getStartPosition(), node.getModifiers(), modifedNode.getModifiers(), this.getDescription((ASTNode)node));
        }
        Type type = node.getType();
        this.rewriteRequiredNode((ASTNode)type);
        List fragments = node.fragments();
        if (this.hasChanges(fragments)) {
            int startPos = this.getNextExistingStartPos(fragments, 0, type.getStartPosition() + type.getLength());
            this.getDefaultRewriter().rewriteList(fragments, startPos, "", ", ");
        } else {
            this.visitList(fragments, 0);
        }
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.rewriteRequiredNode((ASTNode)node.getExpression());
        this.rewriteRequiredNode((ASTNode)node.getBody());
        return false;
    }

    private class ListRewriter {
        protected String fContantSeparator;
        protected int fStartPos;
        protected List fList;

        ListRewriter() {
        }

        protected String getSeparatorString(ASTNode node) {
            return this.fContantSeparator;
        }

        protected int getInitialIndent() {
            return ASTRewriteAnalyzer.this.getIndent(this.fStartPos);
        }

        protected int getNodeIndent(ASTNode node) {
            if (ASTRewriteAnalyzer.this.isInserted(node)) {
                ASTNode prev = ASTRewriteAnalyzer.this.findPreviousExistingNode(this.fList, node);
                if (prev == null) {
                    return this.getInitialIndent();
                }
                return ASTRewriteAnalyzer.this.getIndent(prev.getStartPosition());
            }
            return ASTRewriteAnalyzer.this.getIndent(node.getStartPosition());
        }

        protected int getStartOfNextNode(int nextIndex, int defaultPos) {
            return ASTRewriteAnalyzer.this.getNextExistingStartPos(this.fList, nextIndex, defaultPos);
        }

        public int rewriteList(List list, int startPos, String keyword, String separator) {
            this.fContantSeparator = separator;
            return this.rewriteList(list, startPos, keyword);
        }

        public int rewriteList(List list, int startPos, String keyword) {
            ASTNode elem;
            this.fList = list;
            this.fStartPos = startPos;
            int currPos = startPos;
            int before = 0;
            int after = 0;
            int i = 0;
            while (i < list.size()) {
                elem = (ASTNode)list.get(i);
                if (ASTRewriteAnalyzer.this.isInserted(elem)) {
                    ++after;
                } else {
                    if (++before == 1) {
                        currPos = this.getStartOfNextNode(0, startPos);
                    }
                    if (!ASTRewriteAnalyzer.this.isRemoved(elem)) {
                        ++after;
                    }
                }
                ++i;
            }
            if (after == 0) {
                if (before != 0) {
                    currPos = startPos;
                } else {
                    return startPos;
                }
            }
            if (before == 0 && keyword.length() > 0) {
                String description = ASTRewriteAnalyzer.this.getDescription((ASTNode)list.get(0));
                ASTRewriteAnalyzer.this.doTextInsert(startPos, keyword, description);
            }
            i = 0;
            while (i < list.size()) {
                elem = (ASTNode)list.get(i);
                if (ASTRewriteAnalyzer.this.isInserted(elem)) {
                    String description = ASTRewriteAnalyzer.this.getDescription(elem);
                    ASTRewriteAnalyzer.this.doTextInsert(currPos, elem, this.getNodeIndent(elem), true, description);
                    if (--after != 0) {
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(elem), description);
                    }
                } else {
                    String description;
                    --before;
                    int currEnd = elem.getStartPosition() + elem.getLength();
                    int nextStart = this.getStartOfNextNode(i + 1, currEnd);
                    if (ASTRewriteAnalyzer.this.isRemoved(elem)) {
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, nextStart - currPos, elem);
                    } else if (ASTRewriteAnalyzer.this.isReplaced(elem)) {
                        description = ASTRewriteAnalyzer.this.getDescription(elem);
                        ASTNode changed = ASTRewriteAnalyzer.this.getReplacingNode(elem);
                        if (--after == 0) {
                            ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, nextStart - currPos, elem);
                            ASTRewriteAnalyzer.this.doTextInsert(currPos, changed, this.getNodeIndent(elem), true, description);
                        } else if (before == 0) {
                            ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, elem);
                            ASTRewriteAnalyzer.this.doTextInsert(currPos, changed, this.getNodeIndent(elem), true, description);
                            ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(elem), description);
                        } else {
                            ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, elem);
                            ASTRewriteAnalyzer.this.doTextInsert(currPos, changed, this.getNodeIndent(elem), true, description);
                        }
                    } else {
                        ASTRewriteAnalyzer.this.doVisit(elem);
                        if (--after == 0 && before != 0) {
                            description = ASTRewriteAnalyzer.this.getDescription((ASTNode)list.get(i + 1));
                            ASTRewriteAnalyzer.this.doTextRemove(currEnd, nextStart - currEnd, description);
                        } else if (after != 0 && before == 0) {
                            description = ASTRewriteAnalyzer.this.getDescription((ASTNode)list.get(i + 1));
                            ASTRewriteAnalyzer.this.doTextInsert(currEnd, this.getSeparatorString(elem), description);
                        }
                    }
                    currPos = nextStart;
                }
                ++i;
            }
            return currPos;
        }
    }

    private class ParagraphListRewriter
    extends ListRewriter {
        public final int DEFAULT_SPACING = 1;
        private int fInitialIndent;
        private int fSeparatorLines;

        public ParagraphListRewriter(int initialIndent, int separator) {
            this.fInitialIndent = initialIndent;
            this.fSeparatorLines = separator;
        }

        protected int getInitialIndent() {
            return this.fInitialIndent;
        }

        protected String getSeparatorString(ASTNode node) {
            int newLines = this.fSeparatorLines == -1 ? this.getNewLines(node) : this.fSeparatorLines;
            String lineDelim = ASTRewriteAnalyzer.this.fTextBuffer.getLineDelimiter();
            StringBuffer buf = new StringBuffer(lineDelim);
            int i = 0;
            while (i < newLines) {
                buf.append(lineDelim);
                ++i;
            }
            buf.append(CodeFormatterUtil.createIndentString(this.getNodeIndent(node)));
            return buf.toString();
        }

        private int getNewLines(ASTNode curr) {
            int nodeType = curr.getNodeType();
            ASTNode last = null;
            int additionalLines = -1;
            int i = 0;
            while (i < this.fList.size()) {
                ASTNode elem = (ASTNode)this.fList.get(i);
                if (!ASTRewriteAnalyzer.this.isInserted(elem)) {
                    if (last != null) {
                        if (elem.getNodeType() == nodeType && last.getNodeType() == nodeType) {
                            return this.countEmptyLines(last);
                        }
                        if (additionalLines == -1) {
                            additionalLines = this.countEmptyLines(last);
                        }
                    }
                    last = elem;
                }
                ++i;
            }
            if (additionalLines != -1) {
                return additionalLines;
            }
            return 1;
        }

        private int countEmptyLines(ASTNode last) {
            int lastLine = ASTRewriteAnalyzer.this.fTextBuffer.getLineOfOffset(last.getStartPosition() + last.getLength());
            int scanLine = lastLine + 1;
            int numLines = ASTRewriteAnalyzer.this.fTextBuffer.getNumberOfLines();
            while (scanLine < numLines && Strings.containsOnlyWhitespaces(ASTRewriteAnalyzer.this.fTextBuffer.getLineContent(scanLine))) {
                ++scanLine;
            }
            return scanLine - lastLine - 1;
        }

        protected int getStartOfNextNode(int nextIndex, int currEnd) {
            try {
                int i = nextIndex;
                while (i < this.fList.size()) {
                    if (!ASTRewriteAnalyzer.this.isInserted((ASTNode)this.fList.get(i))) {
                        return ASTRewriteAnalyzer.this.getScanner().getTokenCommentStart(currEnd, ASTRewriteAnalyzer.this.fTextBuffer);
                    }
                    ++i;
                }
            }
            catch (InvalidInputException invalidInputException) {}
            return currEnd;
        }
    }
}

