/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteAnalyzer;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteClear;
import org.eclipse.jdt.internal.corext.dom.ASTWithExistingFlattener;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;

public final class ASTRewrite {
    public static final int UNKNOWN = -1;
    public static final int BODY_DECLARATION = 1;
    public static final int BLOCK = 2;
    public static final int EXPRESSION = 3;
    public static final int STATEMENT = 4;
    public static final int SINGLEVAR_DECLARATION = 5;
    public static final int TYPE = 6;
    public static final int JAVADOC = 7;
    public static final int VAR_DECLARATION_FRAGMENT = 8;
    private ASTNode fRootNode;
    private HashMap fChangedProperties;
    private HashMap fCopiedProperties;
    private boolean fHasInserts;

    public ASTRewrite(ASTNode node) {
        this.fRootNode = node;
        this.fChangedProperties = new HashMap();
        this.fCopiedProperties = new HashMap();
        this.fHasInserts = false;
    }

    public ASTNode getRootNode() {
        return this.fRootNode;
    }

    public void rewriteNode(TextBuffer textBuffer, TextEdit rootEdit, Collection resultingGroupDescription) {
        HashMap descriptions = resultingGroupDescription == null ? null : new HashMap(5);
        ASTRewriteAnalyzer visitor = new ASTRewriteAnalyzer(textBuffer, rootEdit, this, descriptions);
        this.fRootNode.accept((ASTVisitor)visitor);
        if (resultingGroupDescription != null) {
            resultingGroupDescription.addAll(descriptions.values());
        }
    }

    public void removeModifications() {
        if (this.fHasInserts) {
            this.fRootNode.accept((ASTVisitor)new ASTRewriteClear(this));
            this.fHasInserts = false;
        }
        this.fChangedProperties.clear();
        this.fCopiedProperties.clear();
    }

    public final void markAsInserted(ASTNode node, String description) {
        ASTInsert insert = new ASTInsert();
        insert.description = description;
        this.setChangeProperty(node, insert);
        this.fHasInserts = true;
    }

    public final void markAsInserted(ASTNode node) {
        this.markAsInserted(node, null);
    }

    public boolean hasInserts() {
        return this.fHasInserts;
    }

    public final void markAsRemoved(ASTNode node, String description) {
        this.assertIsInside(node);
        ASTRemove remove = new ASTRemove();
        remove.description = description;
        this.setChangeProperty(node, remove);
    }

    public final void markAsRemoved(ASTNode node) {
        this.markAsRemoved(node, null);
    }

    public final void markAsReplaced(ASTNode node, ASTNode replacingNode, String description) {
        Assert.isTrue(replacingNode != null, "Tries to replace with null (use remove instead)");
        Assert.isTrue(replacingNode.getStartPosition() == -1, "Tries to replace with existing node");
        this.assertIsInside(node);
        ASTReplace replace = new ASTReplace();
        replace.replacingNode = replacingNode;
        replace.description = description;
        this.setChangeProperty(node, replace);
    }

    public final void markAsReplaced(ASTNode node, ASTNode replacingNode) {
        this.markAsReplaced(node, replacingNode, null);
    }

    public final void markAsModified(ASTNode node, ASTNode modifiedNode, String description) {
        Assert.isTrue(node.getClass().equals(modifiedNode.getClass()), "Tries to modify with a node of different type");
        this.assertIsInside(node);
        ASTModify modify = new ASTModify();
        modify.modifiedNode = modifiedNode;
        modify.description = description;
        this.setChangeProperty(node, modify);
    }

    public final void markAsModified(ASTNode node, ASTNode modifiedNode) {
        this.markAsModified(node, modifiedNode, null);
    }

    public final ASTNode createCopy(ASTNode node) {
        Assert.isTrue(node.getStartPosition() != -1, "Tries to copy a non-existing node");
        Assert.isTrue(this.getCopySourceEdit(node) == null, "Node used as more than one copy source");
        this.assertIsInside(node);
        Object copySource = ASTRewriteAnalyzer.createSourceCopy(node.getStartPosition(), node.getLength());
        this.setCopySourceEdit(node, copySource);
        int placeHolderType = ASTRewrite.getPlaceholderType(node);
        if (placeHolderType == -1) {
            Assert.isTrue(false, "Can not create copy for elements of type " + node.getClass().getName());
        }
        return ASTWithExistingFlattener.createPlaceholder(node.getAST(), node, placeHolderType);
    }

    public final ASTNode createCopy(ASTNode startNode, ASTNode endNode) {
        Assert.isTrue(startNode.getStartPosition() != -1, "Tries to copy a non-existing node");
        Assert.isTrue(endNode.getStartPosition() != -1, "Tries to copy a non-existing node");
        Assert.isTrue(this.getCopySourceEdit(startNode) == null, "Start node used as more than one copy source ");
        Assert.isTrue(this.getCopySourceEdit(endNode) == null, "End node used as more than one copy source ");
        Assert.isTrue(startNode.getParent() == endNode.getParent(), "Nodes must have same parent");
        this.assertIsInside(startNode);
        this.assertIsInside(endNode);
        int start = startNode.getStartPosition();
        int end = endNode.getStartPosition() + endNode.getLength();
        Assert.isTrue(start < end, "Start node must have smaller offset than end node");
        Object copySource = ASTRewriteAnalyzer.createSourceCopy(start, end - start);
        this.setCopySourceEdit(startNode, copySource);
        this.setCopySourceEdit(endNode, copySource);
        int placeHolderType = ASTRewrite.getPlaceholderType(startNode);
        if (placeHolderType == -1) {
            Assert.isTrue(false, "Can not create copy for elements of type " + startNode.getClass().getName());
        }
        return ASTWithExistingFlattener.createPlaceholder(startNode.getAST(), startNode, placeHolderType);
    }

    public final ASTNode createPlaceholder(String code, int nodeType) {
        return ASTWithExistingFlattener.createPlaceholder(this.fRootNode.getAST(), code, nodeType);
    }

    public static int getPlaceholderType(ASTNode existingNode) {
        if (existingNode instanceof Expression) {
            return 3;
        }
        if (existingNode instanceof Statement) {
            if (existingNode.getNodeType() == 8) {
                return 2;
            }
            return 4;
        }
        if (existingNode instanceof BodyDeclaration) {
            return 1;
        }
        if (existingNode instanceof SingleVariableDeclaration) {
            return 5;
        }
        if (existingNode instanceof VariableDeclarationFragment) {
            return 8;
        }
        if (existingNode instanceof Type) {
            return 6;
        }
        if (existingNode instanceof Javadoc) {
            return 7;
        }
        return -1;
    }

    public final boolean isInserted(ASTNode node) {
        return this.getChangeProperty(node) instanceof ASTInsert;
    }

    public final boolean isReplaced(ASTNode node) {
        return this.getChangeProperty(node) instanceof ASTReplace;
    }

    public final boolean isRemoved(ASTNode node) {
        return this.getChangeProperty(node) instanceof ASTRemove;
    }

    public final boolean isModified(ASTNode node) {
        return this.getChangeProperty(node) instanceof ASTModify;
    }

    public final String getDescription(ASTNode node) {
        Object info = this.getChangeProperty(node);
        if (info instanceof ASTChange) {
            return ((ASTChange)info).description;
        }
        return null;
    }

    public final ASTNode getModifiedNode(ASTNode node) {
        Object info = this.getChangeProperty(node);
        if (info instanceof ASTModify) {
            return ((ASTModify)info).modifiedNode;
        }
        return null;
    }

    public final ASTNode getReplacingNode(ASTNode node) {
        Object info = this.getChangeProperty(node);
        if (info instanceof ASTReplace) {
            return ((ASTReplace)info).replacingNode;
        }
        return null;
    }

    public void clearMark(ASTNode node) {
        this.setCopySourceEdit(node, null);
        this.setChangeProperty(node, null);
    }

    private final void setChangeProperty(ASTNode node, ASTChange change) {
        this.fChangedProperties.put(node, change);
    }

    private final Object getChangeProperty(ASTNode node) {
        return this.fChangedProperties.get(node);
    }

    private final void setCopySourceEdit(ASTNode node, Object copySource) {
        this.fCopiedProperties.put(node, copySource);
    }

    final Object getCopySourceEdit(ASTNode node) {
        return this.fCopiedProperties.get(node);
    }

    private void assertIsInside(ASTNode node) {
        int endPos = node.getStartPosition() + node.getLength();
        if (this.fRootNode.getStartPosition() > node.getStartPosition() || this.fRootNode.getStartPosition() + this.fRootNode.getLength() < endPos) {
            Assert.isTrue(false, "Node that is changed is not located inside of ASTRewrite root");
        }
    }

    private static class ASTChange {
        String description;

        ASTChange() {
        }
    }

    private static final class ASTInsert
    extends ASTChange {
        ASTInsert() {
        }
    }

    private static final class ASTRemove
    extends ASTChange {
        ASTRemove() {
        }
    }

    private static final class ASTReplace
    extends ASTChange {
        public ASTNode replacingNode;

        ASTReplace() {
        }
    }

    private static final class ASTModify
    extends ASTChange {
        public ASTNode modifiedNode;

        ASTModify() {
        }
    }
}

