/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;

public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARINING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int[] MODIFIERS = new int[]{1, 4, 2, 1024, 8, 16, 128, 64, 256, 32, 2048};
    private static final String[] MODIFIER_STRINGS = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "native", "synchronized", "strictfp"};

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public static String asFormattedString(ASTNode node, int indent, String lineDelim) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getFormattedResult(indent, lineDelim);
    }

    public static String modifierString(int mod) {
        StringBuffer result = new StringBuffer();
        int counter = 0;
        int i = 0;
        while (i < MODIFIERS.length) {
            if ((mod & MODIFIERS[i]) != 0) {
                if (counter++ > 0) {
                    result.append(" ");
                }
                result.append(MODIFIER_STRINGS[i]);
            }
            ++i;
        }
        return result.toString();
    }

    public static ASTNode findDeclaration(IBinding binding, ASTNode root) {
        if ((root = root.getRoot()) instanceof CompilationUnit) {
            return ((CompilationUnit)root).findDeclaringNode(binding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding binding, ASTNode root) {
        if (binding.isField()) {
            return null;
        }
        ASTNode result = ASTNodes.findDeclaration((IBinding)binding, root);
        if (result instanceof VariableDeclaration) {
            return (VariableDeclaration)result;
        }
        return null;
    }

    public static Type getType(VariableDeclaration declaration) {
        AST ast = new AST();
        Type type = null;
        if (declaration instanceof SingleVariableDeclaration) {
            type = ((SingleVariableDeclaration)declaration).getType();
        } else if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = ((VariableDeclarationFragment)declaration).getParent();
            if (parent instanceof VariableDeclarationExpression) {
                type = ((VariableDeclarationExpression)parent).getType();
            } else if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            }
        }
        if (type == null) {
            return null;
        }
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        int extraDim = 0;
        if (declaration.getNodeType() == 59) {
            extraDim = ((VariableDeclarationFragment)declaration).getExtraDimensions();
        } else if (declaration.getNodeType() == 44) {
            extraDim = ((SingleVariableDeclaration)declaration).getExtraDimensions();
        }
        int i = 0;
        while (i < extraDim) {
            type = ast.newArrayType(type);
            ++i;
        }
        return type;
    }

    public static int getModifiers(VariableDeclaration declaration) {
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).getModifiers();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).getModifiers();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).getModifiers();
            }
        }
        return 0;
    }

    public static boolean isSingleDeclaration(VariableDeclaration declaration) {
        if (declaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).fragments().size() == 1;
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean isLiteral(Expression expression) {
        if (expression == null) {
            return false;
        }
        int type = expression.getNodeType();
        return type == 9 || type == 13 || type == 33 || type == 34 || type == 45 || type == 57;
    }

    public static String getTypeName(Type type) {
        final StringBuffer buffer = new StringBuffer();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(PrimitiveType node) {
                buffer.append(node.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleName node) {
                buffer.append(node.getIdentifier());
                return false;
            }

            public boolean visit(QualifiedName node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public void endVisit(ArrayType node) {
                buffer.append("[]");
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static boolean needsParentheses(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 11;
    }

    public static boolean substituteMustBeParenthesized(Expression substitute, Expression location) {
        MethodInvocation mi;
        VariableDeclarationFragment vdf;
        if (!ASTNodes.needsParentheses(substitute)) {
            return false;
        }
        ASTNode parent = location.getParent();
        return !(parent instanceof VariableDeclarationFragment ? (vdf = (VariableDeclarationFragment)parent).getInitializer().equals((Object)location) : (parent instanceof MethodInvocation ? (mi = (MethodInvocation)parent).arguments().contains(location) : parent instanceof ReturnStatement));
    }

    public static ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull(parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static ASTNode getNextSibling(ASTNode node) {
        return NextSiblingVisitor.perform(node);
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength() - 1;
    }

    public static IMethodBinding getMethodBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || result.isField()) {
            return null;
        }
        return result;
    }

    public static IVariableBinding getFieldBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || !result.isField()) {
            return null;
        }
        return result;
    }

    public static ITypeBinding getTypeBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static int getDelimiterToken(ASTNode node) {
        List updaters;
        if (node instanceof VariableDeclarationFragment) {
            return 90;
        }
        if (node instanceof SingleVariableDeclaration) {
            return 90;
        }
        ASTNode parent = node.getParent();
        if (node instanceof Expression && parent instanceof ForStatement && (updaters = ((ForStatement)parent).updaters()).contains(node)) {
            return 90;
        }
        return -1;
    }

    public static IProblem[] getProblems(ASTNode node, int scope, int severity) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] problems = ((CompilationUnit)root).getProblems();
        if (root == node) {
            return problems;
        }
        int iterations = ASTNodes.computeIterations(scope);
        ArrayList<IProblem> result = new ArrayList<IProblem>(5);
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            boolean consider = false;
            if ((severity & 3) == 3) {
                consider = true;
            } else if ((severity & 1) != 0) {
                consider = problem.isWarning();
            } else if ((severity & 2) != 0) {
                consider = problem.isError();
            }
            if (consider) {
                ASTNode temp = node;
                int count = iterations;
                do {
                    int problemOffset;
                    int nodeOffset;
                    if ((nodeOffset = temp.getStartPosition()) <= (problemOffset = problem.getSourceStart()) && problemOffset < nodeOffset + temp.getLength()) {
                        result.add(problem);
                        count = 0;
                        continue;
                    }
                    --count;
                } while ((temp = temp.getParent()) != null && count > 0);
            }
            ++i;
        }
        return result.toArray(new IProblem[result.size()]);
    }

    public static Message[] getMessages(ASTNode node, int flags) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messages = ((CompilationUnit)root).getMessages();
        if (root == node) {
            return messages;
        }
        int iterations = ASTNodes.computeIterations(flags);
        ArrayList<Message> result = new ArrayList<Message>(5);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            ASTNode temp = node;
            int count = iterations;
            do {
                int messageOffset;
                int nodeOffset;
                if ((nodeOffset = temp.getStartPosition()) <= (messageOffset = message.getStartPosition()) && messageOffset < nodeOffset + temp.getLength()) {
                    result.add(message);
                    count = 0;
                    continue;
                }
                --count;
            } while ((temp = temp.getParent()) != null && count > 0);
            ++i;
        }
        return result.toArray(new Message[result.size()]);
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public static String getNameIdentifier(Name name) {
        if (name.isSimpleName()) {
            return ((SimpleName)name).getIdentifier();
        }
        if (name.isQualifiedName()) {
            QualifiedName qn = (QualifiedName)name;
            return String.valueOf(ASTNodes.getNameIdentifier(qn.getQualifier())) + "." + qn.getName().getIdentifier();
        }
        Assert.isTrue(false);
        return "";
    }

    public static int clearAccessModifiers(int flags) {
        return ASTNodes.clearFlag(4, ASTNodes.clearFlag(1, ASTNodes.clearFlag(2, flags)));
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }

    public static String[] getIdentifiers(QualifiedName qualifiedName) {
        List result = ASTNodes.getIdentifierList((Name)qualifiedName);
        return result.toArray(new String[result.size()]);
    }

    private static List getIdentifierList(Name name) {
        if (name.isSimpleName()) {
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(((SimpleName)name).getIdentifier());
            return l;
        }
        List l = ASTNodes.getIdentifierList(((QualifiedName)name).getQualifier());
        l.add(((QualifiedName)name).getName().getIdentifier());
        return l;
    }

    private static class NextSiblingVisitor
    extends GenericVisitor {
        private ASTNode fNode;
        private ASTNode fParent;
        private ASTNode fResult;
        private boolean fNodeFound;

        public NextSiblingVisitor(ASTNode node) {
            this.fNode = node;
            this.fParent = node.getParent();
        }

        protected boolean visitNode(ASTNode node) {
            if (node == this.fParent) {
                return true;
            }
            if (node == this.fNode) {
                this.fNodeFound = true;
            }
            if (this.fNodeFound && node.getParent() == this.fParent) {
                this.fResult = node;
            }
            return false;
        }

        public static ASTNode perform(ASTNode node) {
            ASTNode parent = node.getParent();
            if (parent == null) {
                return null;
            }
            NextSiblingVisitor visitor = new NextSiblingVisitor(node);
            parent.accept((ASTVisitor)visitor);
            return visitor.fResult;
        }
    }
}

