/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;

public class ASTNodeFactory {
    private static final String STATEMENT_HEADER = "class __X__ { void __x__() { ";
    private static final String STATEMENT_FOOTER = "}}";

    private ASTNodeFactory() {
    }

    public static ASTNode newStatement(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(STATEMENT_HEADER);
        buffer.append(content);
        buffer.append(STATEMENT_FOOTER);
        CompilationUnit root = AST.parseCompilationUnit((char[])buffer.toString().toCharArray());
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)NodeFinder.perform((ASTNode)root, STATEMENT_HEADER.length(), content.length()));
        result.accept((ASTVisitor)new PositionClearer());
        return result;
    }

    public static Name newName(AST ast, String name) {
        StringTokenizer tok = new StringTokenizer(name, ".");
        Object res = null;
        while (tok.hasMoreTokens()) {
            SimpleName curr = ast.newSimpleName(tok.nextToken());
            res = res == null ? curr : ast.newQualifiedName((Name)res, curr);
        }
        return res;
    }

    private static class PositionClearer
    extends GenericVisitor {
        PositionClearer() {
        }

        protected boolean visitNode(ASTNode node) {
            node.setSourceRange(-1, 0);
            return true;
        }
    }
}

