/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Iterator;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;

class ASTFlattener
extends GenericVisitor {
    protected StringBuffer fResult = new StringBuffer();

    public String getResult() {
        return new String(this.fResult.toString());
    }

    public String getFormattedResult(int initialIndentationLevel, String lineDelimiter) {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(null);
        return formatter.format(this.getResult(), initialIndentationLevel, null, lineDelimiter);
    }

    public void reset() {
        this.fResult.setLength(0);
    }

    protected boolean visitNode(ASTNode node) {
        Assert.isTrue(false, "No implementation to flatten node: " + node.toString());
        return false;
    }

    public static void printModifiers(int modifiers, StringBuffer buf) {
        if (Modifier.isPublic((int)modifiers)) {
            buf.append("public ");
        }
        if (Modifier.isProtected((int)modifiers)) {
            buf.append("protected ");
        }
        if (Modifier.isPrivate((int)modifiers)) {
            buf.append("private ");
        }
        if (Modifier.isStatic((int)modifiers)) {
            buf.append("static ");
        }
        if (Modifier.isAbstract((int)modifiers)) {
            buf.append("abstract ");
        }
        if (Modifier.isFinal((int)modifiers)) {
            buf.append("final ");
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            buf.append("synchronized ");
        }
        if (Modifier.isVolatile((int)modifiers)) {
            buf.append("volatile ");
        }
        if (Modifier.isNative((int)modifiers)) {
            buf.append("native ");
        }
        if (Modifier.isStrictfp((int)modifiers)) {
            buf.append("strictfp ");
        }
        if (Modifier.isTransient((int)modifiers)) {
            buf.append("transient ");
        }
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.fResult.append("{");
        Iterator it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration b = (BodyDeclaration)it.next();
            b.accept((ASTVisitor)this);
        }
        this.fResult.append("}");
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept((ASTVisitor)this);
        this.fResult.append("[");
        node.getIndex().accept((ASTVisitor)this);
        this.fResult.append("]");
        return false;
    }

    public boolean visit(ArrayCreation node) {
        this.fResult.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept((ASTVisitor)this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.fResult.append("[");
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            this.fResult.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.fResult.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.fResult.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.fResult.append("{");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append("}");
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept((ASTVisitor)this);
        this.fResult.append("[]");
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.fResult.append("assert ");
        node.getExpression().accept((ASTVisitor)this);
        if (node.getMessage() != null) {
            this.fResult.append(" : ");
            node.getMessage().accept((ASTVisitor)this);
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        this.fResult.append(node.getOperator().toString());
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Block node) {
        this.fResult.append("{");
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.fResult.append("}");
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.fResult.append("true");
        } else {
            this.fResult.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.fResult.append("break");
        if (node.getLabel() != null) {
            this.fResult.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(CastExpression node) {
        this.fResult.append("(");
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(")");
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CatchClause node) {
        this.fResult.append("catch (");
        node.getException().accept((ASTVisitor)this);
        this.fResult.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.fResult.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        this.fResult.append("new ");
        node.getName().accept((ASTVisitor)this);
        this.fResult.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        ImportDeclaration d;
        if (node.getPackage() != null) {
            node.getPackage().accept((ASTVisitor)this);
        }
        Iterator it = node.imports().iterator();
        while (it.hasNext()) {
            d = (ImportDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        it = node.types().iterator();
        while (it.hasNext()) {
            d = (TypeDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append("?");
        node.getThenExpression().accept((ASTVisitor)this);
        this.fResult.append(":");
        node.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        this.fResult.append("this(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(");");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.fResult.append("continue");
        if (node.getLabel() != null) {
            this.fResult.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(DoStatement node) {
        this.fResult.append("do ");
        node.getBody().accept((ASTVisitor)this);
        this.fResult.append(" while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(");");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.fResult.append(";");
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(";");
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(", ");
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(ForStatement node) {
        Expression e;
        this.fResult.append("for (");
        Iterator it = node.initializers().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.fResult.append("; ");
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.fResult.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fResult.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.fResult.append("if (");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        if (node.getElseStatement() != null) {
            this.fResult.append(" else ");
            node.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.fResult.append("import ");
        node.getName().accept((ASTVisitor)this);
        if (node.isOnDemand()) {
            this.fResult.append(".*");
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fResult.append(" ");
        this.fResult.append(node.getOperator().toString());
        this.fResult.append(" ");
        node.getRightOperand().accept((ASTVisitor)this);
        Iterator it = node.extendedOperands().iterator();
        while (it.hasNext()) {
            this.fResult.append(node.getOperator().toString());
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fResult.append(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Javadoc node) {
        this.fResult.append(node.getComment());
        return false;
    }

    public boolean visit(LabeledStatement node) {
        node.getLabel().accept((ASTVisitor)this);
        this.fResult.append(": ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        if (!node.isConstructor()) {
            node.getReturnType().accept((ASTVisitor)this);
            this.fResult.append(" ");
        }
        node.getName().accept((ASTVisitor)this);
        this.fResult.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(")");
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fResult.append("[]");
            ++i;
        }
        if (!node.thrownExceptions().isEmpty()) {
            this.fResult.append(" throws ");
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fResult.append(", ");
            }
            this.fResult.append(" ");
        }
        if (node.getBody() == null) {
            this.fResult.append(";");
        } else {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        node.getName().accept((ASTVisitor)this);
        this.fResult.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(")");
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.fResult.append("null");
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.fResult.append(node.getToken());
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        this.fResult.append("package ");
        node.getName().accept((ASTVisitor)this);
        this.fResult.append(";");
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.fResult.append("(");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(")");
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept((ASTVisitor)this);
        this.fResult.append(node.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        this.fResult.append(node.getOperator().toString());
        node.getOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.fResult.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fResult.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.fResult.append("return");
        if (node.getExpression() != null) {
            this.fResult.append(" ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(SimpleName node) {
        this.fResult.append(node.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType node) {
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(" ");
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fResult.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.fResult.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.fResult.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        this.fResult.append("super(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(");");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        this.fResult.append("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        this.fResult.append("super.");
        node.getName().accept((ASTVisitor)this);
        this.fResult.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(",");
        }
        this.fResult.append(")");
        return false;
    }

    public boolean visit(SwitchCase node) {
        Expression expression = node.getExpression();
        if (expression == null) {
            this.fResult.append("default");
        } else {
            this.fResult.append("case ");
            expression.accept((ASTVisitor)this);
        }
        this.fResult.append(": ");
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.fResult.append("switch (");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(") ");
        this.fResult.append("{");
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.fResult.append("}");
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.fResult.append("synchronized (");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fResult.append(".");
        }
        this.fResult.append("this");
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.fResult.append("throw ");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(";");
        return false;
    }

    public boolean visit(TryStatement node) {
        this.fResult.append("try ");
        node.getBody().accept((ASTVisitor)this);
        this.fResult.append(" ");
        Iterator it = node.catchClauses().iterator();
        while (it.hasNext()) {
            CatchClause cc = (CatchClause)it.next();
            cc.accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        this.fResult.append(node.isInterface() ? "interface " : "class ");
        node.getName().accept((ASTVisitor)this);
        this.fResult.append(" ");
        if (node.getSuperclass() != null) {
            this.fResult.append("extends ");
            node.getSuperclass().accept((ASTVisitor)this);
            this.fResult.append(" ");
        }
        if (!node.superInterfaces().isEmpty()) {
            this.fResult.append(node.isInterface() ? "extends " : "implements ");
            it = node.superInterfaces().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fResult.append(", ");
            }
            this.fResult.append(" ");
        }
        this.fResult.append("{");
        it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (BodyDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        this.fResult.append("}");
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        node.getTypeDeclaration().accept((ASTVisitor)this);
        this.fResult.append(";");
        return false;
    }

    public boolean visit(TypeLiteral node) {
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(".class");
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(", ");
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fResult.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.fResult.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        ASTFlattener.printModifiers(node.getModifiers(), this.fResult);
        node.getType().accept((ASTVisitor)this);
        this.fResult.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fResult.append(", ");
        }
        this.fResult.append(";");
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.fResult.append("while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fResult.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }
}

