/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.AbstractCodeBlock;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.template.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;

public class TryCatchBlock
extends AbstractCodeBlock {
    private static final String TRY_PLACE_HOLDER = "f();";
    private AbstractCodeBlock fTryBody;
    private ITypeBinding[] fExceptions;
    private IJavaProject fJavaProject;
    private CodeScopeBuilder.Scope fScope;

    public TryCatchBlock(ITypeBinding[] exceptions, IJavaProject project, CodeScopeBuilder.Scope scope, AbstractCodeBlock tryBody) {
        this.fTryBody = tryBody;
        this.fExceptions = exceptions;
        this.fJavaProject = project;
        this.fScope = scope;
    }

    public boolean isEmpty() {
        return false;
    }

    public void fill(StringBuffer buffer, String firstLineIndent, String indent, String lineSeparator) throws CoreException {
        int[] positions;
        String dummy = this.createStatement(lineSeparator);
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        String formattedCode = formatter.format(dummy, 0, positions = this.computePositions(dummy), lineSeparator);
        if (!this.adjustPositions(formattedCode, positions)) {
            Assert.isTrue(false, "This should never happend");
        }
        TextBuffer textBuffer = TextBuffer.create(formattedCode);
        String placeHolderLine = textBuffer.getLineContentOfOffset(positions[0]);
        String bodyIndent = String.valueOf(indent) + (placeHolderLine != null ? CodeFormatterUtil.createIndentString(placeHolderLine) : "");
        this.fill(buffer, formattedCode.substring(0, positions[0]), firstLineIndent, indent, lineSeparator);
        this.fTryBody.fill(buffer, "", bodyIndent, lineSeparator);
        this.fill(buffer, formattedCode.substring(positions[1] + 1), "", indent, lineSeparator);
    }

    private int[] computePositions(String dummy) {
        int tryPlaceHolderStart = dummy.indexOf(TRY_PLACE_HOLDER);
        int[] result = new int[]{tryPlaceHolderStart, tryPlaceHolderStart + TRY_PLACE_HOLDER.length() - 1};
        return result;
    }

    private String createStatement(String lineSeparator) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("try {f();} ");
        int i = 0;
        while (i < this.fExceptions.length) {
            buffer.append("catch(");
            buffer.append(this.fExceptions[i].getName());
            buffer.append(" ");
            String name = this.fScope.createName("e", false);
            buffer.append(name);
            buffer.append("){" + lineSeparator + this.getCatchBody(this.fExceptions[i], name, lineSeparator) + "}");
            ++i;
        }
        return buffer.toString();
    }

    private String getCatchBody(ITypeBinding exception, String name, String lineSeparator) throws CoreException {
        Template template = CodeTemplates.getCodeTemplate("catchblock");
        if (template == null) {
            return "";
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), this.fJavaProject, lineSeparator, 0);
        context.setVariable("exception_type", exception.getName());
        context.setVariable("exception_var", name);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return "";
        }
        return buffer.getString();
    }

    private boolean adjustPositions(String code, int[] positions) {
        int candidate = code.indexOf(TRY_PLACE_HOLDER);
        if (candidate == -1) {
            return false;
        }
        positions[0] = candidate;
        positions[1] = candidate + TRY_PLACE_HOLDER.length() - 1;
        return true;
    }
}

