/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.template.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class StubUtility {
    public static String genStub(ICompilationUnit cu, String destTypeName, IMethod method, IType definingType, GenStubSettings settings, IImportsStructure imports) throws CoreException {
        String methName = method.getElementName();
        String[] paramNames = method.getParameterNames();
        String returnType = method.isConstructor() ? null : method.getReturnType();
        String lineDelimiter = String.valueOf('\n');
        StringBuffer buf = new StringBuffer();
        if (settings.createComments && cu != null) {
            String comment;
            IMethod overridden = null;
            if (settings.methodOverwrites && returnType != null) {
                overridden = JavaModelUtil.findMethod(methName, method.getParameterTypes(), false, definingType.getMethods());
            }
            if ((comment = StubUtility.getMethodComment(cu, destTypeName, methName, paramNames, method.getExceptionTypes(), returnType, overridden, lineDelimiter)) != null) {
                buf.append(comment);
            } else {
                buf.append("/**").append(lineDelimiter);
                buf.append(" *").append(lineDelimiter);
                buf.append(" */").append(lineDelimiter);
            }
            buf.append(lineDelimiter);
        }
        String bodyContent = null;
        if (!settings.noBody) {
            String bodyStatement = StubUtility.getDefaultMethodBodyStatement(methName, paramNames, returnType, settings.callSuper);
            bodyContent = StubUtility.getMethodBodyContent(returnType == null, method.getJavaProject(), destTypeName, methName, bodyStatement, lineDelimiter);
            if (bodyContent == null) {
                bodyContent = "";
            }
        }
        StubUtility.genMethodDeclaration(destTypeName, method, bodyContent, imports, buf);
        return buf.toString();
    }

    public static void genMethodDeclaration(String destTypeName, IMethod method, String bodyContent, IImportsStructure imports, StringBuffer buf) throws CoreException {
        IType parentType = method.getDeclaringType();
        String methodName = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = method.getParameterNames();
        String[] excTypes = method.getExceptionTypes();
        int flags = method.getFlags();
        boolean isConstructor = method.isConstructor();
        String retTypeSig = isConstructor ? null : method.getReturnType();
        int lastParam = paramTypes.length - 1;
        if (Flags.isPublic((int)flags) || isConstructor || parentType.isInterface() && bodyContent != null) {
            buf.append("public ");
        } else if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isStrictfp((int)flags)) {
            buf.append("strictfp ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (isConstructor) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = !StubUtility.isPrimitiveType(retTypeSig) ? StubUtility.resolveAndAdd(retTypeSig, parentType, imports) : Signature.toString((String)retTypeSig);
            buf.append(retTypeFrm);
            buf.append(' ');
            buf.append(methodName);
        }
        buf.append('(');
        int i = 0;
        while (i <= lastParam) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = !StubUtility.isPrimitiveType(paramTypeSig) ? StubUtility.resolveAndAdd(paramTypeSig, parentType, imports) : Signature.toString((String)paramTypeSig);
            buf.append(paramTypeFrm);
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i < lastParam) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            int i2 = 0;
            while (i2 <= lastExc) {
                String excTypeSig = excTypes[i2];
                String excTypeFrm = StubUtility.resolveAndAdd(excTypeSig, parentType, imports);
                buf.append(excTypeFrm);
                if (i2 < lastExc) {
                    buf.append(", ");
                }
                ++i2;
            }
        }
        if (bodyContent == null) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (bodyContent != null) {
                buf.append(bodyContent);
                buf.append('\n');
            }
            buf.append("}\n");
        }
    }

    private static String getDefaultMethodBodyStatement(String methodName, String[] paramNames, String retTypeSig, boolean callSuper) {
        StringBuffer buf = new StringBuffer();
        if (callSuper) {
            if (retTypeSig != null) {
                if (!"V".equals(retTypeSig)) {
                    buf.append("return ");
                }
                buf.append("super.");
                buf.append(methodName);
            } else {
                buf.append("super");
            }
            buf.append('(');
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(paramNames[i]);
                ++i;
            }
            buf.append(");");
        } else if (retTypeSig != null && !retTypeSig.equals("V")) {
            if (!StubUtility.isPrimitiveType(retTypeSig) || Signature.getArrayCount((String)retTypeSig) > 0) {
                buf.append("return null;");
            } else if (retTypeSig.equals("Z")) {
                buf.append("return false;");
            } else {
                buf.append("return 0;");
            }
        }
        return buf.toString();
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "constructorbody" : "methodbody";
        Template template = CodeTemplates.getCodeTemplate(templateName);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), project, lineDelimiter, 0);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            if (Strings.containsOnlyWhitespaces(bodyStatement)) {
                return null;
            }
            return bodyStatement;
        }
        return str;
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String lineDelimiter) throws CoreException {
        Template template = CodeTemplates.getCodeTemplate("catchblock");
        if (template != null) {
            String res;
            CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), cu.getJavaProject(), lineDelimiter, 0);
            context.setVariable("exception_type", exceptionType);
            context.setVariable("exception_var", variableName);
            TemplateBuffer buffer = context.evaluate(template);
            if (buffer != null && !Strings.containsOnlyWhitespaces(res = buffer.getString())) {
                return buffer.getString();
            }
        }
        return null;
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        Template template = CodeTemplates.getCodeTemplate("newtype");
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), project, lineDelimiter, 0);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", Signature.getQualifier((String)cu.getElementName()));
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        String content = buffer.getString();
        if (content.length() == 0) {
            return null;
        }
        return content;
    }

    public static String getTypeComment(ICompilationUnit cu, String typeQualifiedName, String lineDelim) throws CoreException {
        Template template = CodeTemplates.getCodeTemplate("typecomment");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), cu.getJavaProject(), lineDelim, 0);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String[] getParameterTypesQualifiedNames(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = typeBindings[i].getQualifiedName();
            ++i;
        }
        return result;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String getSeeTag(IMethod overridden) throws JavaModelException {
        IType declaringType = overridden.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringType.getFullyQualifiedName('.'));
        buf.append('#');
        buf.append(overridden.getElementName());
        buf.append('(');
        String[] paramTypes = overridden.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            String curr = paramTypes[i];
            buf.append(JavaModelUtil.getResolvedTypeName(curr, declaringType));
            int arrayCount = Signature.getArrayCount((String)curr);
            while (arrayCount > 0) {
                buf.append("[]");
                --arrayCount;
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = method.isConstructor() ? null : method.getReturnType();
        return StubUtility.getMethodComment(method.getCompilationUnit(), method.getDeclaringType().getElementName(), method.getElementName(), method.getParameterNames(), method.getExceptionTypes(), retType, overridden, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "methodcomment";
        if (retTypeSig == null) {
            templateName = "constructorcomment";
        } else if (overridden != null) {
            templateName = "overridecomment";
        }
        Template template = CodeTemplates.getCodeTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), cu.getJavaProject(), lineDelimiter, 0);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString((String)retTypeSig));
        }
        if (overridden != null) {
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(overridden));
        }
        if ((buffer = context.evaluate(template)) == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplatePosition position = StubUtility.findTagPosition(buffer);
        if (position == null) {
            return str;
        }
        TextBuffer textBuffer = TextBuffer.create(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString((String)excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString((String)retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            StubUtility.insertTag(textBuffer, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, false, lineDelimiter);
            --i2;
        }
        return textBuffer.getContent();
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, IMethodBinding overridden, String lineDelimiter) throws CoreException {
        if (overridden != null) {
            String declaringClassQualifiedName = overridden.getDeclaringClass().getQualifiedName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypesQualifiedNames(overridden);
            return StubUtility.getMethodComment(cu, typeName, decl, true, overridden.isDeprecated(), declaringClassQualifiedName, parameterTypesQualifiedNames, lineDelimiter);
        }
        return StubUtility.getMethodComment(cu, typeName, decl, false, false, null, null, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, boolean isOverridden, boolean isDeprecated, String declaringClassQualifiedName, String[] parameterTypesQualifiedNames, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "methodcomment";
        if (decl.isConstructor()) {
            templateName = "constructorcomment";
        } else if (isOverridden) {
            templateName = "overridecomment";
        }
        Template template = CodeTemplates.getCodeTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeName(), cu.getJavaProject(), String.valueOf('\n'), 0);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", decl.getName().getIdentifier());
        if (!decl.isConstructor()) {
            context.setVariable("return_type", ASTNodes.asString((ASTNode)decl.getReturnType()));
        }
        if (isOverridden) {
            String methodName = decl.getName().getIdentifier();
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(declaringClassQualifiedName, methodName, parameterTypesQualifiedNames));
        }
        if ((buffer = context.evaluate(template)) == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplatePosition position = StubUtility.findTagPosition(buffer);
        if (position == null) {
            return str;
        }
        TextBuffer textBuffer = TextBuffer.create(str);
        List params = decl.parameters();
        String[] paramNames = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration elem = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = elem.getName().getIdentifier();
            ++i;
        }
        List exceptions = decl.thrownExceptions();
        String[] exceptionNames = new String[exceptions.size()];
        int i2 = 0;
        while (i2 < exceptions.size()) {
            exceptionNames[i2] = ASTResolving.getSimpleName((Name)exceptions.get(i2));
            ++i2;
        }
        String returnType = !decl.isConstructor() ? ASTNodes.asString((ASTNode)decl.getReturnType()) : null;
        int[] tagOffsets = position.getOffsets();
        int i3 = tagOffsets.length - 1;
        while (i3 >= 0) {
            StubUtility.insertTag(textBuffer, tagOffsets[i3], position.getLength(), paramNames, exceptionNames, returnType, isDeprecated, lineDelimiter);
            --i3;
        }
        return textBuffer.getContent();
    }

    private static TemplatePosition findTagPosition(TemplateBuffer buffer) {
        TemplatePosition[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplatePosition curr = positions[i];
            if ("tags".equals(curr.getName())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(TextBuffer textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, boolean isDeprecated, String lineDelimiter) throws CoreException {
        TextRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.getContent(region.getOffset(), offset - region.getOffset());
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@param ");
            buf.append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter);
                    buf.append(lineStart);
                }
                buf.append("@throws ");
                buf.append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@deprecated");
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isPrimitiveType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static String resolveAndAdd(String refTypeSig, IType declaringType, IImportsStructure imports) throws JavaModelException {
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName(refTypeSig, declaringType);
        if (resolvedTypeName != null) {
            StringBuffer buf = new StringBuffer();
            if (imports != null) {
                buf.append(imports.addImport(resolvedTypeName));
            } else {
                buf.append(resolvedTypeName);
            }
            int arrayCount = Signature.getArrayCount((String)refTypeSig);
            int i = 0;
            while (i < arrayCount) {
                buf.append("[]");
                ++i;
            }
            return buf.toString();
        }
        return Signature.toString((String)refTypeSig);
    }

    private static IMethod findMethod(IMethod method, List allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        int i = allMethods.size() - 1;
        while (i >= 0) {
            IMethod curr = (IMethod)allMethods.get(i);
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, curr)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static String[] evalConstructors(IType type, IType supertype, CodeGenerationSettings settings, IImportsStructure imports) throws CoreException {
        IMethod[] superMethods = supertype.getMethods();
        String typeName = type.getElementName();
        ICompilationUnit cu = type.getCompilationUnit();
        IMethod[] methods = type.getMethods();
        GenStubSettings genStubSettings = new GenStubSettings(settings);
        genStubSettings.callSuper = true;
        ArrayList<String> newMethods = new ArrayList<String>(superMethods.length);
        int i = 0;
        while (i < superMethods.length) {
            IMethod curr = superMethods[i];
            if (curr.isConstructor() && (JavaModelUtil.isVisible((IMember)curr, type.getPackageFragment()) || Flags.isProtected((int)curr.getFlags())) && JavaModelUtil.findMethod(typeName, curr.getParameterTypes(), true, methods) == null) {
                String newStub = StubUtility.genStub(cu, typeName, curr, curr.getDeclaringType(), genStubSettings, imports);
                newMethods.add(newStub);
            }
            ++i;
        }
        return newMethods.toArray(new String[newMethods.size()]);
    }

    public static String[] evalUnimplementedMethods(IType type, ITypeHierarchy hierarchy, boolean isSubType, CodeGenerationSettings settings, IOverrideMethodQuery selectionQuery, IImportsStructure imports) throws CoreException {
        IMethod curr;
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        ArrayList<IMethod> toImplement = new ArrayList<IMethod>();
        IMethod[] typeMethods = type.getMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethod curr2 = typeMethods[i];
            if (!(curr2.isConstructor() || Flags.isStatic((int)curr2.getFlags()) || Flags.isPrivate((int)curr2.getFlags()))) {
                allMethods.add(curr2);
            }
            ++i;
        }
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i2 = 0;
        while (i2 < superTypes.length) {
            IMethod[] methods = superTypes[i2].getMethods();
            int k = 0;
            while (k < methods.length) {
                curr = methods[k];
                if (!(curr.isConstructor() || Flags.isStatic((int)curr.getFlags()) || Flags.isPrivate((int)curr.getFlags()) || StubUtility.findMethod(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++k;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < allMethods.size()) {
            IMethod curr3 = (IMethod)allMethods.get(i2);
            if ((Flags.isAbstract((int)curr3.getFlags()) || curr3.getDeclaringType().isInterface()) && (isSubType || !type.equals(curr3.getDeclaringType()))) {
                toImplement.add(curr3);
            }
            ++i2;
        }
        IType[] superInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i3 = 0;
        while (i3 < superInterfaces.length) {
            IMethod[] methods = superInterfaces[i3].getMethods();
            int k = 0;
            while (k < methods.length) {
                IMethod impl;
                IMethod curr4 = methods[k];
                if (!Flags.isStatic((int)curr4.getFlags()) && ((impl = StubUtility.findMethod(curr4, allMethods)) == null || curr4.getExceptionTypes().length < impl.getExceptionTypes().length && !Flags.isFinal((int)impl.getFlags()))) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    toImplement.add(curr4);
                    allMethods.add(curr4);
                }
                ++k;
            }
            ++i3;
        }
        IMethod[] toImplementArray = toImplement.toArray(new IMethod[toImplement.size()]);
        if (selectionQuery != null) {
            if (!isSubType) {
                allMethods.removeAll(Arrays.asList(typeMethods));
            }
            int i4 = allMethods.size() - 1;
            while (i4 >= 0) {
                curr = (IMethod)allMethods.get(i4);
                if (Flags.isFinal((int)curr.getFlags())) {
                    allMethods.remove(i4);
                }
                --i4;
            }
            IMethod[] choice = allMethods.toArray(new IMethod[allMethods.size()]);
            toImplementArray = selectionQuery.select(choice, toImplementArray, hierarchy);
            if (toImplementArray == null) {
                return null;
            }
        }
        GenStubSettings genStubSettings = new GenStubSettings(settings);
        genStubSettings.methodOverwrites = true;
        ICompilationUnit cu = type.getCompilationUnit();
        String[] result = new String[toImplementArray.length];
        int i5 = 0;
        while (i5 < toImplementArray.length) {
            IMethod desc;
            IMethod curr5 = toImplementArray[i5];
            IMethod overrides = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, type, curr5.getElementName(), curr5.getParameterTypes(), curr5.isConstructor());
            if (overrides != null) {
                genStubSettings.callSuper = true;
                curr5 = overrides;
            }
            if ((desc = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, type, curr5.getElementName(), curr5.getParameterTypes(), curr5.isConstructor())) == null) {
                desc = curr5;
            }
            result[i5] = StubUtility.genStub(cu, type.getElementName(), curr5, desc.getDeclaringType(), genStubSettings, imports);
            ++i5;
        }
        return result;
    }

    public static String getLineDelimiterUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterFor(IDocument doc) {
        String lineDelim = null;
        try {
            lineDelim = doc.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelim == null) {
            String systemDelimiter = System.getProperty("line.separator", "\n");
            String[] lineDelims = doc.getLegalLineDelimiters();
            int i = 0;
            while (i < lineDelims.length) {
                if (lineDelims[i].equals(systemDelimiter)) {
                    lineDelim = systemDelimiter;
                    break;
                }
                ++i;
            }
            if (lineDelim == null) {
                lineDelim = lineDelims.length > 0 ? lineDelims[0] : systemDelimiter;
            }
        }
        return lineDelim;
    }

    public static int getIndentUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu;
        if (elem instanceof ISourceReference && (cu = (ICompilationUnit)elem.getAncestor(5)) != null) {
            int offset;
            IBuffer buf = cu.getBuffer();
            int i = offset = ((ISourceReference)elem).getSourceRange().getOffset();
            while (i > 0 && !Strings.isLineDelimiterChar(buf.getChar(i - 1))) {
                --i;
            }
            return Strings.computeIndent(buf.getText(i, offset - i), CodeFormatterUtil.getTabWidth());
        }
        return 0;
    }

    public static String codeFormat(String sourceString, int initialIndentationLevel, String lineDelim) {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(null);
        return formatter.format(sourceString, initialIndentationLevel, null, lineDelim);
    }

    public static IJavaElement findNextSibling(IJavaElement member) throws JavaModelException {
        IJavaElement parent = member.getParent();
        if (parent instanceof IParent) {
            IJavaElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static class GenStubSettings
    extends CodeGenerationSettings {
        public boolean callSuper;
        public boolean methodOverwrites;
        public boolean noBody;

        public GenStubSettings(CodeGenerationSettings settings) {
            settings.setSettings(this);
        }

        public GenStubSettings() {
        }
    }
}

