/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.AbstractCodeBlock;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public class MethodBlock
extends AbstractCodeBlock {
    private String fSignature;
    private AbstractCodeBlock fBody;

    public MethodBlock(String signature, AbstractCodeBlock body) {
        this.fSignature = signature;
        this.fBody = body;
    }

    public boolean isEmpty() {
        return false;
    }

    public void fill(StringBuffer buffer, String firstLineIndent, String indent, String lineSeparator) throws CoreException {
        int placeHolderStart;
        int[] positions;
        String dummy = String.valueOf(this.fSignature) + " { x(); }";
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        String formattedCode = formatter.format(dummy, 0, positions = new int[]{placeHolderStart = dummy.indexOf("x();"), placeHolderStart + "x();".length() - 1}, lineSeparator);
        if (!MethodBlock.adjustPositions(formattedCode, "x();", positions)) {
            Assert.isTrue(false, "This should never happend");
        }
        TextBuffer textBuffer = TextBuffer.create(formattedCode);
        String placeHolderLine = textBuffer.getLineContentOfOffset(positions[0]);
        String bodyIndent = String.valueOf(indent) + (placeHolderLine != null ? CodeFormatterUtil.createIndentString(placeHolderLine) : "");
        this.fill(buffer, formattedCode.substring(0, positions[0]), firstLineIndent, indent, lineSeparator);
        this.fBody.fill(buffer, "", bodyIndent, lineSeparator);
        this.fill(buffer, formattedCode.substring(positions[1] + 1), "", indent, lineSeparator);
    }

    public static int probeSpacing(TextBuffer buffer, MethodDeclaration method) {
        MethodDeclaration[] methods = MethodBlock.getSiblings(method);
        if (methods != null && methods.length >= 1) {
            int start = methods.length == 1 ? methods[0].getStartPosition() : methods[1].getStartPosition();
            int lineNumber = buffer.getLineOfOffset(start);
            int result = 0;
            while (lineNumber > 0) {
                String line;
                if (Strings.containsOnlyWhitespaces(line = buffer.getLineContent(--lineNumber))) {
                    ++result;
                    continue;
                }
                return result;
            }
        }
        return 1;
    }

    private static MethodDeclaration[] getSiblings(MethodDeclaration method) {
        ASTNode parent = method.getParent();
        if (parent instanceof TypeDeclaration) {
            return ((TypeDeclaration)parent).getMethods();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            List body = ((AnonymousClassDeclaration)parent).bodyDeclarations();
            ArrayList result = new ArrayList();
            Iterator iter = body.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof MethodDeclaration)) continue;
                result.add(element);
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return null;
    }

    private static boolean adjustPositions(String code, String placeHolder, int[] positions) {
        int length = code.length();
        if (positions[0] < 0 || positions[1] < 0 || positions[0] >= length || positions[1] >= length) {
            int candidate = code.indexOf(placeHolder);
            if (candidate == -1) {
                return false;
            }
            positions[0] = candidate;
            positions[1] = candidate + placeHolder.length() - 1;
        }
        return true;
    }
}

