/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public final class MemberEdit
extends SimpleTextEdit {
    public static final int INSERT_BEFORE = 0;
    public static final int INSERT_AFTER = 1;
    public static final int ADD_AT_BEGINNING = 2;
    public static final int ADD_AT_END = 3;
    public static final int REPLACE = 4;
    private IJavaElement fMember;
    private int fInsertionKind;
    private String[] fSource;
    private int fTabWidth;
    private boolean fUseFormatter = false;
    private int fEmptyLinesBetweenMembers = 1;
    private boolean fAddLineSeparators = true;

    public MemberEdit(IJavaElement member, int insertionKind, String[] source, int tabWidth) {
        Assert.isNotNull(member);
        this.fMember = member;
        Assert.isTrue(insertionKind >= 0 && this.fInsertionKind <= 4);
        this.fInsertionKind = insertionKind;
        Assert.isNotNull(source);
        this.fSource = source;
        Assert.isTrue(tabWidth >= 0);
        this.fTabWidth = tabWidth;
    }

    public void setUseFormatter(boolean useFormatter) {
        this.fUseFormatter = useFormatter;
    }

    public void setAddLineSeparators(boolean addLineSeparators) {
        this.fAddLineSeparators = addLineSeparators;
    }

    public void setEmptyLinesBetweenMembers(int value) {
        this.fEmptyLinesBetweenMembers = value;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        MemberEdit result = new MemberEdit(this.fMember, this.fInsertionKind, this.fSource, this.fTabWidth);
        result.setUseFormatter(this.fUseFormatter);
        result.setEmptyLinesBetweenMembers(this.fEmptyLinesBetweenMembers);
        return result;
    }

    public Object getModifiedElement() {
        if (this.fInsertionKind == 2 || this.fInsertionKind == 3 || this.fInsertionKind == 4) {
            return this.fMember;
        }
        return this.fMember.getParent();
    }

    /*
     * Unable to fully structure code
     */
    public void connect(TextBuffer buffer) throws CoreException {
        sb = new StringBuffer();
        lineDelimiter = buffer.getLineDelimiter();
        scanner = null;
        range = this.getSourceRange();
        start = range.getOffset();
        end = start + range.getLength();
        offset = -1;
        length = 0;
        block2 : switch (this.fInsertionKind) {
            case 4: {
                offset = start;
                length = range.getLength();
                sb.append(this.getSource(this.getLineIndent(buffer), lineDelimiter, false));
                break;
            }
            case 2: {
                switch (this.fMember.getElementType()) {
                    case 7: {
                        scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
                        scanner.setSource(buffer.getContent(start, range.getLength()).toCharArray());
                        emptyLines = 0;
                        sawClosingBracket = false;
                        try {
                            while ((token = scanner.getNextToken()) != 158) {
                                if (token == 110) break;
                            }
                            offset = start + scanner.getCurrentTokenEndPosition() + 1;
                            while ((token = scanner.getNextToken()) != 158) {
                                switch (token) {
                                    case 1000: {
                                        s = MemberEdit.extract(buffer, start, scanner);
                                        emptyLines += MemberEdit.countEmptyLines(s);
                                        break;
                                    }
                                    case 95: {
                                        sawClosingBracket = true;
                                        ** GOTO lbl43
                                    }
                                    default: {
                                        ** GOTO lbl43
                                    }
                                }
                            }
                        }
                        catch (InvalidInputException e) {
                            throw new JavaModelException((Throwable)e, 984);
                        }
lbl43:
                        // 3 sources

                        sb.append(lineDelimiter);
                        sb.append(this.getSource(this.getLineIndent(buffer) + 1, lineDelimiter, true));
                        if (sawClosingBracket || emptyLines >= this.fEmptyLinesBetweenMembers) break block2;
                        this.fill(sb, this.fEmptyLinesBetweenMembers + 1, lineDelimiter);
                        break block2;
                    }
                    default: {
                        Assert.isTrue(false);
                        return;
                    }
                }
            }
            case 3: {
                switch (this.fMember.getElementType()) {
                    case 7: {
                        scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
                        scanner.setSource(buffer.getContent(start, range.getLength()).toCharArray());
                        try {
                            pos = -1;
                            while ((token = scanner.getNextToken()) != 158) {
                                if (token != 95) continue;
                                pos = scanner.getCurrentTokenStartPosition();
                            }
                            if (pos >= 0) {
                                offset = start + pos;
                            }
                        }
                        catch (InvalidInputException e) {
                            throw new JavaModelException((Throwable)e, 984);
                        }
                        sb.append(this.getSource(this.getLineIndent(buffer) + 1, lineDelimiter, true));
                        sb.append(lineDelimiter);
                        break block2;
                    }
                    case 5: {
                        this.fill(sb, this.fEmptyLinesBetweenMembers + 1, lineDelimiter);
                        sb.append(this.getSource(0, lineDelimiter, true));
                        offset = buffer.getLength();
                        break block2;
                    }
                }
                Assert.isTrue(false);
                return;
            }
            case 1: {
                this.fill(sb, this.fEmptyLinesBetweenMembers + 1, lineDelimiter);
                sb.append(this.getSource(this.getLineIndent(buffer), lineDelimiter, true));
                offset = end;
                break;
            }
            case 0: {
                sb.append(this.getSource(this.getLineIndent(buffer), lineDelimiter, true));
                this.fill(sb, this.fEmptyLinesBetweenMembers + 1, lineDelimiter);
                line = buffer.getLineOfOffset(range.getOffset());
                region = buffer.getLineInformation(line);
                offset = region.getOffset();
                break;
            }
            default: {
                Assert.isTrue(false);
            }
        }
        Assert.isTrue(offset >= 0);
        this.setTextRange(new TextRange(offset, length));
        this.setText(sb.toString());
        super.connect(buffer);
    }

    private static String extract(TextBuffer buffer, int offset, IScanner scanner) {
        int start = scanner.getCurrentTokenStartPosition();
        int length = scanner.getCurrentTokenEndPosition() - start + 1;
        return buffer.getContent(offset + start, length);
    }

    private static int countEmptyLines(String line) {
        int emptyLines = 0;
        int l = line.length();
        int i = 0;
        while (i < l) {
            char c = line.charAt(i);
            if (c == '\r') {
                if (i < l - 1 && line.charAt(i + 1) == '\n') {
                    ++emptyLines;
                    ++i;
                }
            } else if (c == '\n') {
                ++emptyLines;
            }
            ++i;
        }
        return emptyLines;
    }

    private ISourceRange getSourceRange() throws CoreException {
        return ((ISourceReference)this.fMember).getSourceRange();
    }

    private int getLineIndent(TextBuffer buffer) throws CoreException {
        int offset = this.getSourceRange().getOffset();
        int line = buffer.getLineOfOffset(offset);
        return buffer.getLineIndent(line, this.fTabWidth);
    }

    private String getSource(int initialIndentationLevel, String lineDelimiter, boolean indentFirstLine) {
        StringBuffer buffer = new StringBuffer();
        int last = this.fSource.length - 1;
        Strings.trimIndentation(this.fSource, this.fTabWidth);
        String indent = "";
        if (!this.fUseFormatter) {
            indent = CodeFormatterUtil.createIndentString(initialIndentationLevel);
        }
        int i = 0;
        while (i < this.fSource.length) {
            if (!this.fUseFormatter && (i > 0 || i == 0 && indentFirstLine)) {
                buffer.append(indent);
            }
            buffer.append(this.fSource[i]);
            if (i < last && this.fAddLineSeparators) {
                buffer.append(lineDelimiter);
            }
            ++i;
        }
        if (this.fUseFormatter) {
            ICodeFormatter formatter = ToolFactory.createCodeFormatter();
            return formatter.format(buffer.toString(), initialIndentationLevel, null, lineDelimiter);
        }
        return buffer.toString();
    }

    private void fill(StringBuffer buffer, int count, String s) {
        int i = 0;
        while (i < count) {
            buffer.append(s);
            ++i;
        }
    }
}

