/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public final class ImportEdit
extends SimpleTextEdit {
    private ImportsStructure fImportsStructure;

    public ImportEdit(ICompilationUnit cunit, CodeGenerationSettings settings) throws JavaModelException {
        Assert.isNotNull(cunit);
        Assert.isNotNull(settings);
        try {
            this.fImportsStructure = new ImportsStructure(cunit, settings.importOrder, settings.importThreshold, true);
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private ImportEdit(ImportsStructure importsStructure) {
        this.fImportsStructure = importsStructure;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fImportsStructure.setFilterImplicitImports(filterImplicitImports);
    }

    public void setFindAmbiguosImports(boolean findAmbiguosImports) {
        this.fImportsStructure.setFindAmbiguousImports(findAmbiguosImports);
    }

    public String addImport(String qualifiedTypeName) {
        return this.fImportsStructure.addImport(qualifiedTypeName);
    }

    public String addImport(ITypeBinding binding) {
        return this.fImportsStructure.addImport(binding);
    }

    public void removeImport(String qualifiedTypeName) {
        this.fImportsStructure.removeImport(qualifiedTypeName);
    }

    public boolean isEmpty() {
        return !this.fImportsStructure.hasChanges();
    }

    public void connect(TextBuffer buffer) throws CoreException {
        TextRange range = this.fImportsStructure.getReplaceRange(buffer);
        String text = this.fImportsStructure.getReplaceString(buffer, range);
        if (text != null) {
            this.setText(text);
            this.setTextRange(range);
        } else {
            this.setText("");
            this.setTextRange(new TextRange(0, 0));
        }
        super.connect(buffer);
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new ImportEdit(this.fImportsStructure);
    }

    public Object getModifiedElement() {
        ICompilationUnit cu = this.fImportsStructure.getCompilationUnit();
        IImportContainer container = cu.getImportContainer();
        if (container.exists()) {
            return container;
        }
        return cu;
    }
}

