/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;

public final class DeleteNodeEdit
extends SimpleTextEdit {
    private boolean fDeleteLine;
    private int fDelimiterToken;

    public DeleteNodeEdit(ASTNode node, boolean deleteLine) {
        this(node.getStartPosition(), node.getLength(), deleteLine, ASTNodes.getDelimiterToken(node));
    }

    public DeleteNodeEdit(int start, int length, boolean deleteLine, int delimiterToken) {
        super(start, length, "");
        this.fDeleteLine = deleteLine;
        this.fDelimiterToken = delimiterToken;
    }

    private DeleteNodeEdit(TextRange range, boolean deleteLine) {
        super(range, "");
        this.fDeleteLine = deleteLine;
    }

    public void connect(TextBuffer buffer) throws CoreException {
        TextRange range = this.getTextRange();
        int startOffset = buffer.getLineInformationOfOffset(range.getOffset()).getOffset();
        TextRegion region = buffer.getLineInformationOfOffset(range.getInclusiveEnd());
        int endOffset = region.getOffset() + region.getLength() - 1;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(buffer.getContent(startOffset, endOffset - startOffset + 1).toCharArray());
        try {
            int start = this.fDeleteLine ? this.getStart(buffer, scanner, startOffset) : range.getOffset();
            int end = this.fDeleteLine ? this.getLineEnd(buffer, scanner, startOffset) : this.getEndIncludingDelimiter(buffer, scanner, startOffset);
            this.setTextRange(new TextRange(start, end - start));
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new DeleteNodeEdit(this.getTextRange().copy(), this.fDeleteLine);
    }

    private int getStart(TextBuffer buffer, IScanner scanner, int startOffset) throws InvalidInputException {
        int token;
        int relativeNodeStart = this.getTextRange().getOffset() - startOffset;
        scanner.resetTo(startOffset, relativeNodeStart - 1);
        while ((token = scanner.getNextToken()) != 158) {
            switch (token) {
                case 1001: 
                case 1002: 
                case 1003: {
                    break;
                }
                default: {
                    return this.getTextRange().getOffset();
                }
            }
        }
        return startOffset;
    }

    private int getLineEnd(TextBuffer buffer, IScanner scanner, int startOffset) throws InvalidInputException {
        int token;
        int result = this.getTextRange().getExclusiveEnd();
        int sourceLength = scanner.getSource().length;
        scanner.resetTo(result - startOffset, sourceLength - 1);
        while ((token = scanner.getNextToken()) != 158) {
            if (token == 1001 || token == 1002 || token == 1003 || token == this.fDelimiterToken) continue;
            return result;
        }
        return startOffset + sourceLength + buffer.getLineDelimiter(buffer.getLineOfOffset(result - 1)).length();
    }

    private int getEndIncludingDelimiter(TextBuffer buffer, IScanner scanner, int startOffset) throws InvalidInputException {
        int token;
        int result = this.getTextRange().getExclusiveEnd();
        if (this.fDelimiterToken == -1) {
            return result;
        }
        scanner.resetTo(result - startOffset, scanner.getSource().length);
        boolean delimiterFound = false;
        while ((token = scanner.getNextToken()) != 158) {
            if (token == 1001 || token == 1002 || token == 1003) {
                if (!delimiterFound) continue;
                return startOffset + scanner.getCurrentTokenStartPosition();
            }
            if (token == this.fDelimiterToken) {
                delimiterFound = true;
                result = startOffset + scanner.getCurrentTokenEndPosition() + 1;
                continue;
            }
            if (delimiterFound) {
                result = startOffset + scanner.getCurrentTokenStartPosition();
            }
            return result;
        }
        return result;
    }
}

