/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.AbstractCodeBlock;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public final class CodeBlockEdit
extends TextEdit {
    private TextRange fRange;
    private AbstractCodeBlock fBlock;
    private int fIndent;
    private int fSpacing;

    public static CodeBlockEdit createReplace(int offset, int length, AbstractCodeBlock block, int indent) {
        return new CodeBlockEdit(new TextRange(offset, length), block, indent, 0);
    }

    public static CodeBlockEdit createReplace(int offset, int length, AbstractCodeBlock block) {
        return new CodeBlockEdit(new TextRange(offset, length), block, -1, 0);
    }

    public static CodeBlockEdit createInsert(int offset, AbstractCodeBlock block, int spacing) {
        return new CodeBlockEdit(new TextRange(offset, 0), block, -1, spacing);
    }

    private CodeBlockEdit(TextRange range, AbstractCodeBlock block, int indent, int spacing) {
        Assert.isNotNull(range);
        Assert.isNotNull(block);
        this.fRange = range;
        this.fBlock = block;
        this.fIndent = indent;
        this.fSpacing = spacing;
    }

    public TextEdit copy0(TextEditCopier copier) {
        return new CodeBlockEdit(this.fRange.copy(), this.fBlock, this.fIndent, this.fSpacing);
    }

    public void connect(TextBuffer buffer) throws CoreException {
        int lineNumber;
        int offset = this.fRange.getOffset();
        int end = offset + this.fRange.getLength();
        int lineOffset = buffer.getLineInformationOfOffset(end).getOffset();
        if (lineOffset == end && (lineNumber = buffer.getLineOfOffset(lineOffset)) > 0) {
            this.fRange = new TextRange(offset, this.fRange.getLength() - buffer.getLineDelimiter(lineNumber - 1).length());
        }
    }

    public TextRange getTextRange() {
        return this.fRange;
    }

    public final void perform(TextBuffer buffer) throws CoreException {
        buffer.replace(this.fRange, this.createText(buffer));
    }

    private String createText(TextBuffer buffer) throws CoreException {
        String indent;
        int tabWidth = CodeFormatterUtil.getTabWidth();
        int offset = this.fRange.getOffset();
        int firstLine = buffer.getLineOfOffset(offset);
        TextRegion region = buffer.getLineInformation(firstLine);
        if (this.fIndent < 0) {
            this.fIndent = Strings.computeIndent(buffer.getLineContent(firstLine), tabWidth);
        }
        String firstLineIndent = indent = CodeFormatterUtil.createIndentString(this.fIndent);
        if (this.fRange.getLength() == 0) {
            if (this.fSpacing == 0) {
                firstLineIndent = "";
            }
        } else {
            String lineContent = buffer.getContent(offset, region.getLength() - (offset - region.getOffset()));
            firstLineIndent = CodeFormatterUtil.createIndentString(Strings.computeIndent(lineContent, tabWidth));
        }
        String delimiter = buffer.getLineDelimiter(firstLine);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.fSpacing) {
            result.append(delimiter);
            ++i;
        }
        this.fBlock.fill(result, firstLineIndent, indent, delimiter);
        return result.toString();
    }
}

