/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.corext.codemanipulation.AbstractCodeBlock;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public class CodeBlock
extends AbstractCodeBlock {
    private List fLines;

    public CodeBlock(TextBuffer buffer) {
        this(buffer, 0, buffer.getLength());
    }

    public CodeBlock(TextBuffer buffer, int offset, int length) {
        int lineOffset;
        String[] lines = buffer.convertIntoLines(offset, length, false);
        if (lines.length > 0 && (lineOffset = buffer.getLineInformationOfOffset(offset).getOffset()) != offset) {
            lines[0] = String.valueOf(CodeFormatterUtil.createIndentString(buffer.getContent(lineOffset, offset - lineOffset))) + lines[0];
        }
        this.initialize(lines);
    }

    public CodeBlock(String code) {
        this.initialize(Strings.convertIntoLines(code));
    }

    private void initialize(String[] lines) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth());
        this.fLines = new ArrayList<String>(Arrays.asList(lines));
    }

    public String get(int index) {
        return (String)this.fLines.get(index);
    }

    public void set(int index, String line) {
        this.fLines.set(index, line);
    }

    public void add(int index, String line) {
        this.fLines.add(index, line);
    }

    public void prepend(String line) {
        this.fLines.add(0, line);
    }

    public void append(String line) {
        this.fLines.add(line);
    }

    public void prependToLine(int index, String prefix) {
        this.fLines.set(index, String.valueOf(prefix) + this.get(index));
    }

    public void appendToLine(int index, String appendix) {
        this.fLines.set(index, String.valueOf(this.get(index)) + appendix);
    }

    public int size() {
        return this.fLines.size();
    }

    public List lines() {
        return this.fLines;
    }

    public boolean isEmpty() {
        return this.fLines.isEmpty();
    }

    public void fill(StringBuffer buffer, String firstLineIndent, String indent, String lineSeparator) {
        int size = this.fLines.size();
        int lastLine = size - 1;
        int i = 0;
        while (i < size) {
            if (i == 0) {
                buffer.append(firstLineIndent);
            } else {
                buffer.append(indent);
            }
            buffer.append((String)this.fLines.get(i));
            if (i < lastLine) {
                buffer.append(lineSeparator);
            }
            ++i;
        }
    }
}

