/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public final class ChangeVisibilityEdit
extends SimpleTextEdit {
    private final IMember fMember;
    private final int fVisibility;

    public ChangeVisibilityEdit(IMember member, int visibility) {
        JdtFlags.assertVisibility(visibility);
        this.fMember = member;
        Assert.isNotNull(this.fMember);
        this.fVisibility = visibility;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new ChangeVisibilityEdit(this.fMember, this.fVisibility);
    }

    public Object getModifiedElement() {
        return this.fMember;
    }

    public void connect(TextBuffer buffer) throws CoreException {
        int offset = this.fMember.getSourceRange().getOffset();
        int length = 0;
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(buffer.getContent(offset, this.fMember.getSourceRange().getLength()).toCharArray());
        int token = 0;
        try {
            while ((token = scanner.getNextToken()) != 158) {
                if (token != 103 && token != 102 && token != 101) continue;
                offset += scanner.getCurrentTokenStartPosition();
                length = scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 1;
                break;
            }
        }
        catch (InvalidInputException e) {
            throw new JavaModelException((Throwable)e, 984);
        }
        this.setTextRange(new TextRange(offset, length));
        this.setText(this.getVisibilityString(length));
        super.connect(buffer);
    }

    private String getVisibilityString(int tokenLength) {
        String text = JdtFlags.getVisibilityString(this.fVisibility);
        if (tokenLength == 0) {
            text = String.valueOf(text) + " ";
        }
        return text;
    }
}

