/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;

public class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private IType fType;
    private IMethod[] fCreatedMethods;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;
    private IOverrideMethodQuery fSelectionQuery;

    public AddUnimplementedMethodsOperation(IType type, CodeGenerationSettings settings, IOverrideMethodQuery selectionQuery, boolean save) {
        this.fType = type;
        this.fDoSave = save;
        this.fCreatedMethods = null;
        this.fSettings = settings;
        this.fSelectionQuery = selectionQuery;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.setTaskName(CodeGenerationMessages.getString("AddUnimplementedMethodsOperation.description"));
            monitor.beginTask("", 3);
            ITypeHierarchy hierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
            String[] toImplement = StubUtility.evalUnimplementedMethods(this.fType, hierarchy, false, this.fSettings, this.fSelectionQuery, imports);
            if (toImplement == null) {
                throw new OperationCanceledException();
            }
            int nToImplement = toImplement.length;
            ArrayList<IMethod> createdMethods = new ArrayList<IMethod>(nToImplement);
            if (nToImplement > 0) {
                String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
                int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
                IMethod lastMethod = null;
                int i = 0;
                while (i < nToImplement) {
                    String formattedContent = String.valueOf(StubUtility.codeFormat(toImplement[i], indent, lineDelim)) + lineDelim;
                    lastMethod = this.fType.createMethod(formattedContent, null, true, null);
                    createdMethods.add(lastMethod);
                    ++i;
                }
                monitor.worked(1);
                imports.create(this.fDoSave, null);
                monitor.worked(1);
            } else {
                monitor.worked(2);
            }
            this.fCreatedMethods = new IMethod[createdMethods.size()];
            createdMethods.toArray(this.fCreatedMethods);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            monitor.done();
            throw throwable;
        }
        Object var12_14 = null;
        monitor.done();
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods;
    }
}

