/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;

public class AddUnimplementedConstructorsOperation
implements IWorkspaceRunnable {
    private IType fType;
    private IMethod[] fCreatedMethods;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;

    public AddUnimplementedConstructorsOperation(IType type, CodeGenerationSettings settings, boolean save) {
        this.fType = type;
        this.fDoSave = save;
        this.fCreatedMethods = null;
        this.fSettings = settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block12: {
            block11: {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.setTaskName(CodeGenerationMessages.getString("AddUnimplementedMethodsOperation.description"));
                    monitor.beginTask("", 3);
                    ITypeHierarchy hierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.worked(1);
                    IType superType = hierarchy.getSuperclass(this.fType);
                    if (superType == null) {
                        this.fCreatedMethods = new IMethod[0];
                        Object var15_4 = null;
                        break block11;
                    }
                    ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
                    String[] toImplement = StubUtility.evalConstructors(this.fType, superType, this.fSettings, imports);
                    if (toImplement == null) {
                        throw new OperationCanceledException();
                    }
                    int nToImplement = toImplement.length;
                    ArrayList<IMethod> createdMethods = new ArrayList<IMethod>(nToImplement);
                    String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
                    int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
                    IMethod sibling = null;
                    IMethod[] existing = this.fType.getMethods();
                    int i = 0;
                    while (true) {
                        if (i >= existing.length) {
                            if (sibling == null && existing.length > 0) {
                                sibling = existing[0];
                            }
                            break;
                        }
                        if (existing[i].isConstructor()) {
                            sibling = existing[i];
                        }
                        ++i;
                    }
                    i = 0;
                    while (true) {
                        if (i >= nToImplement) {
                            monitor.worked(1);
                            imports.create(this.fDoSave, null);
                            monitor.worked(1);
                            this.fCreatedMethods = new IMethod[createdMethods.size()];
                            createdMethods.toArray(this.fCreatedMethods);
                            break block12;
                        }
                        String formattedContent = String.valueOf(StubUtility.codeFormat(toImplement[i], indent, lineDelim)) + lineDelim;
                        IMethod lastMethod = this.fType.createMethod(formattedContent, (IJavaElement)sibling, true, null);
                        createdMethods.add(lastMethod);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_5 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var15_6 = null;
        monitor.done();
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods;
    }
}

