/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;

public class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private final String[] EMPTY = new String[0];
    private IField[] fGetterFields;
    private IField[] fSetterFields;
    private List fCreatedAccessors;
    private IRequestQuery fSkipExistingQuery;
    private IRequestQuery fSkipFinalSettersQuery;
    private boolean fSkipAllFinalSetters;
    private boolean fSkipAllExisting;
    private CodeGenerationSettings fSettings;

    public AddGetterSetterOperation(IField[] fields, CodeGenerationSettings settings, IRequestQuery skipFinalSettersQuery, IRequestQuery skipExistingQuery) {
        this(fields, fields, settings, skipFinalSettersQuery, skipExistingQuery);
    }

    public AddGetterSetterOperation(IField[] getterFields, IField[] setterFields, CodeGenerationSettings settings, IRequestQuery skipFinalSettersQuery, IRequestQuery skipExistingQuery) {
        this.fGetterFields = getterFields;
        this.fSetterFields = setterFields;
        this.fSkipExistingQuery = skipExistingQuery;
        this.fSkipFinalSettersQuery = skipFinalSettersQuery;
        this.fSettings = settings;
        this.fCreatedAccessors = new ArrayList();
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.setTaskName(CodeGenerationMessages.getString("AddGetterSetterOperation.description"));
            monitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
            this.fSkipAllFinalSetters = this.fSkipFinalSettersQuery == null;
            this.fSkipAllExisting = this.fSkipExistingQuery == null;
            int i = 0;
            while (i < this.fGetterFields.length) {
                this.generateGetter(this.fGetterFields[i]);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            i = 0;
            while (i < this.fSetterFields.length) {
                this.generateSetter(this.fSetterFields[i]);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        Object var3_5 = null;
        monitor.done();
    }

    private boolean querySkipFinalSetters(IField field) throws OperationCanceledException {
        if (!this.fSkipAllFinalSetters) {
            switch (this.fSkipFinalSettersQuery.doQuery((IMember)field)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllFinalSetters = true;
                }
            }
        }
        return true;
    }

    private boolean querySkipExistingMethods(IMethod method) throws OperationCanceledException {
        if (!this.fSkipAllExisting) {
            switch (this.fSkipExistingQuery.doQuery((IMember)method)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllExisting = true;
                }
            }
        }
        return true;
    }

    private void generateGetter(IField field) throws CoreException, OperationCanceledException {
        boolean doCreateGetter;
        String fieldName = field.getElementName();
        boolean isStatic = Flags.isStatic((int)field.getFlags());
        String typeName = Signature.toString((String)field.getTypeSignature());
        IType parentType = field.getDeclaringType();
        boolean addComments = this.fSettings.createComments;
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)parentType);
        int indent = StubUtility.getIndentUsed((IJavaElement)field);
        String getterName = GetterSetterUtil.getGetterName(field, null);
        IMethod existingGetter = JavaModelUtil.findMethod(getterName, this.EMPTY, false, parentType);
        boolean bl = doCreateGetter = existingGetter == null || !this.querySkipExistingMethods(existingGetter);
        if (doCreateGetter) {
            String comment;
            StringBuffer buf = new StringBuffer();
            if (addComments && (comment = CodeGeneration.getMethodComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, this.EMPTY, this.EMPTY, field.getTypeSignature(), null, String.valueOf('\n'))) != null) {
                buf.append(comment);
                buf.append('\n');
            }
            buf.append("public ");
            if (isStatic) {
                buf.append("static ");
            }
            buf.append(typeName);
            buf.append(' ');
            buf.append(getterName);
            buf.append("() {\nreturn ");
            buf.append(fieldName);
            buf.append(";\n}\n");
            IJavaElement sibling = null;
            if (existingGetter != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existingGetter);
                existingGetter.delete(false, null);
            }
            String formattedContent = String.valueOf(StubUtility.codeFormat(buf.toString(), indent, lineDelim)) + lineDelim;
            this.fCreatedAccessors.add(parentType.createMethod(formattedContent, sibling, true, null));
        }
    }

    private void generateSetter(IField field) throws CoreException, OperationCanceledException {
        boolean doCreateSetter;
        String fieldName = field.getElementName();
        IJavaProject project = field.getJavaProject();
        String returnSig = field.getTypeSignature();
        String returnElementType = Signature.toString((String)Signature.getElementType((String)returnSig));
        String argname = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)Signature.getQualifier((String)returnElementType), (String)Signature.getSimpleName((String)returnElementType), (int)Signature.getArrayCount((String)returnSig), (String[])this.EMPTY)[0];
        boolean isStatic = Flags.isStatic((int)field.getFlags());
        boolean isFinal = Flags.isFinal((int)field.getFlags());
        String typeName = Signature.toString((String)returnSig);
        IType parentType = field.getDeclaringType();
        boolean addComments = this.fSettings.createComments;
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)parentType);
        int indent = StubUtility.getIndentUsed((IJavaElement)field);
        String setterName = GetterSetterUtil.getSetterName(field, null);
        String[] args = new String[]{returnSig};
        IMethod existingSetter = JavaModelUtil.findMethod(setterName, args, false, parentType);
        boolean bl = doCreateSetter = !(isFinal && this.querySkipFinalSetters(field) || existingSetter != null && !this.querySkipExistingMethods(existingSetter));
        if (doCreateSetter) {
            String comment;
            StringBuffer buf = new StringBuffer();
            if (addComments && (comment = CodeGeneration.getMethodComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, new String[]{argname}, this.EMPTY, "V", null, String.valueOf('\n'))) != null) {
                buf.append(comment);
                buf.append('\n');
            }
            buf.append("public ");
            if (isStatic) {
                buf.append("static ");
            }
            buf.append("void ");
            buf.append(setterName);
            buf.append('(');
            buf.append(typeName);
            buf.append(' ');
            buf.append(argname);
            buf.append(") {\n");
            if (argname.equals(fieldName)) {
                if (isStatic) {
                    buf.append(parentType.getElementName());
                    buf.append('.');
                } else {
                    buf.append("this.");
                }
            }
            buf.append(fieldName);
            buf.append("= ");
            buf.append(argname);
            buf.append(";\n}\n");
            IJavaElement sibling = null;
            if (existingSetter != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existingSetter);
                existingSetter.delete(false, null);
            }
            String formattedContent = String.valueOf(StubUtility.codeFormat(buf.toString(), indent, lineDelim)) + lineDelim;
            this.fCreatedAccessors.add(parentType.createMethod(formattedContent, sibling, true, null));
        }
    }

    public IMethod[] getCreatedAccessors() {
        return this.fCreatedAccessors.toArray(new IMethod[this.fCreatedAccessors.size()]);
    }
}

