/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.codemanipulation.AbstractCodeBlock;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public class ASTNodeCodeBlock
extends AbstractCodeBlock {
    private List fNodes = new ArrayList(3);

    public void add(ASTNode node) {
        this.fNodes.add(node);
    }

    public boolean isEmpty() {
        return this.fNodes.isEmpty();
    }

    public void fill(StringBuffer buffer, String firstLineIndent, String indent, String lineSeparator) {
        StringBuffer code = new StringBuffer();
        Iterator iter = this.fNodes.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            code.append(ASTNodes.asString(node));
        }
        int tabWidth = CodeFormatterUtil.getTabWidth();
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        int flin = Strings.computeIndent(firstLineIndent, tabWidth);
        int in = Strings.computeIndent(indent, tabWidth);
        String formatted = formatter.format(code.toString(), in, null, lineSeparator);
        if (flin > in) {
            buffer.append(CodeFormatterUtil.createIndentString(flin - in));
        } else if (flin < in) {
            formatted = Strings.trimIndent(formatted, in - flin, tabWidth);
        }
        buffer.append(formatted);
    }
}

