/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.Resource;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.library.ReferencesTransaction;
import java.util.ArrayList;

public class RemoveReferencesTransaction
extends ReferencesTransaction {
    public RemoveReferencesTransaction(String fromApplication, String[] toLibraries, TransactionCommunicator _communicator) throws DeploymentException {
        super(fromApplication, _communicator, "removeRefs");
        if (toLibraries == null || toLibraries.length == 0) {
            throw new ServerDeploymentException("deploy_5024", new String[]{this.getTransactionType(), "destinations"});
        }
        this.libNames = new String[toLibraries.length];
        int i = 0;
        while (i < this.libNames.length) {
            this.libNames[i] = toLibraries[i];
            ++i;
        }
    }

    protected ReferenceObject[] addRefs() {
        return null;
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local" + this.getTransactionType());
        if (this.libNames != null) {
            ArrayList warnings = new ArrayList();
            DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
            ReferenceObject ref = new ReferenceObject();
            String type = null;
            int type1 = -1;
            if (info != null) {
                int i = 0;
                while (i < this.libNames.length) {
                    try {
                        ref.setCompositeName(this.libNames[i]);
                        type = ref.getReferenceTargetType();
                        type1 = -1;
                        if (type.equals("service")) {
                            type1 = 3;
                        } else if (type.equals("application")) {
                            type1 = 1;
                        } else if (type.equals("interface")) {
                            type1 = 4;
                        } else if (type.equals("library")) {
                            type1 = 2;
                        }
                        this.communicator.getReferenceResolver().processRemoveReference(this.getModuleID(), Resource.createResource((byte)type1, ref.getName()), warnings);
                    }
                    catch (DeploymentException dex) {
                        dex.log();
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < warnings.size()) {
                    this.communicator.logWarning("Warning: " + (String)warnings.get(i2));
                    ++i2;
                }
            }
        }
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local " + this.getTransactionType());
        this.commitUniversal();
    }

    public void commit() {
        this.communicator.trace(200, "Commit " + this.getTransactionType());
        this.commitUniversal();
    }

    private void commitUniversal() {
        ReferenceObject[] refs = this.info.getReferences();
        if (this.libNames != null) {
            int i = 0;
            while (i < this.libNames.length) {
                if (!this.findRef(this.libNames[i], refs)) {
                    this.addWarning("Reference from " + this.getModuleID() + " to " + this.libNames[i] + " doesn't exist.");
                }
                ++i;
            }
        }
        this.communicator.removeReferencesInternally(this.getModuleID(), this.libNames);
        String fromLoader = this.info.getLoaderName() == null ? this.getModuleID() : this.info.getLoaderName();
        int i = 0;
        while (i < this.libNames.length) {
            this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext().unregisterReference(fromLoader, this.libNames[i]);
            ++i;
        }
        this.setSuccessfullyFinished(true);
    }

    private boolean findRef(String loaderName, ReferenceObject[] refs) {
        if (refs == null || refs.length == 0) {
            return false;
        }
        if (loaderName != null) {
            String current = null;
            int i = 0;
            while (i < refs.length) {
                if (refs[i] != null) {
                    current = "";
                    if (!"application".equals(refs[i].getReferenceTargetType())) {
                        current = current + refs[i].getReferenceTargetType() + ":";
                    }
                    if (loaderName.equals(current = current + refs[i].getName())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

