/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.frame.container.deploy.ComponentDeploymentException;
import com.sap.engine.frame.container.deploy.DeployContext;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.library.LibraryTransaction;

public class RemoveLibTransaction
extends LibraryTransaction {
    public RemoveLibTransaction(String _libName, byte type, TransactionCommunicator _communicator) throws DeploymentException {
        super(_communicator, "removeLib");
        this.libName = _libName;
        this.type = type;
        this.setModuleID(this.libName);
    }

    public void begin() throws DeploymentException, ComponentNotDeployedException {
        block7: {
            DeployContext dc = this.communicator.getApplicationServiceContext().getContainerContext().getDeployContext();
            try {
                if (this.type == 0) {
                    this.communicator.trace(200, "Start removing library " + this.libName);
                    if (this.communicator.getApplicationServiceContext().getContainerContext().getSystemMonitor().getLibrary(this.libName) == null) {
                        this.addWarning("Library " + this.libName + " does not exist.");
                    }
                    dc.removeLibrary(this.libName);
                    this.communicator.trace(200, "End removing library " + this.libName);
                    break block7;
                }
                if (this.type == 1) {
                    this.communicator.trace(200, "Start removing interface " + this.libName);
                    dc.removeInterface(this.libName);
                    this.communicator.trace(200, "End removing interface " + this.libName);
                    break block7;
                }
                if (this.type == 2) {
                    this.communicator.trace(200, "Start removing service " + this.libName);
                    dc.removeService(this.libName);
                    this.communicator.trace(200, "End removing service " + this.libName);
                    break block7;
                }
                throw new ServerDeploymentException("deploy_5022", new String[]{String.valueOf(this.type), this.libName});
            }
            catch (ComponentDeploymentException ex) {
                if (ex instanceof com.sap.engine.frame.container.deploy.ComponentNotDeployedException) {
                    throw new ComponentNotDeployedException("deploy_5100", (Object[])new String[]{this.type == 0 ? "Library" : (this.type == 1 ? "Interface" : "Service"), this.libName, "remove it"}, (Exception)((Object)ex));
                }
                throw new ServerDeploymentException("deploy_5023", new String[]{this.getTransactionType(), this.libName}, ex);
            }
        }
        this.setSuccessfullyFinished(true);
    }
}

