/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.RemoteCaller;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import java.util.ArrayList;

public abstract class ReferencesTransaction
implements DTransaction {
    protected TransactionCommunicator communicator = null;
    protected RemoteCaller remote = null;
    protected LoadContext loadContext;
    protected DTransaction childTransaction = null;
    private boolean unregisterAfterFinish = false;
    protected String[] references = null;
    protected String transactionType = null;
    protected ReferenceObject[] libraries = null;
    protected String[] libNames = null;
    protected int[] serverIds = null;
    protected int clusterElements = 0;
    private long beginTime = 0L;
    protected String moduleID = null;
    private TransactionStatistics currentStatistics = null;
    private TransactionStatistics[] remoteStatistics = null;
    protected DeploymentInfo info = null;
    protected ConfigurationHandler handler = null;
    private boolean okFinished = false;
    private char lockType = (char)88;

    public ReferencesTransaction(String fromApp, TransactionCommunicator _communicator, String transType) throws DeploymentException {
        this.serverIds = _communicator.getRemoteCaller().getServerIDs();
        this.communicator = _communicator;
        this.remote = this.communicator.getRemoteCaller();
        this.loadContext = _communicator.getApplicationServiceContext().getCoreContext().getLoadContext();
        this.transactionType = transType;
        if (fromApp == null) {
            throw new ServerDeploymentException("deploy_5024", new String[]{this.getTransactionType(), "from which application"});
        }
        this.setModuleID(fromApp);
        this.currentStatistics = new TransactionStatistics(this.communicator.getClusterID());
        this.currentStatistics.setModuleName(this.getModuleID());
        this.info = this.communicator.getApplicationInfo(this.getModuleID());
        if (this.info == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), this.communicator.getClusterIDName(), this.getTransactionType()});
        }
    }

    public void setModuleID(String id) throws DeploymentException {
        if (id.indexOf("/") != -1) {
            if (id.indexOf("/") == id.length() - 1) {
                throw new ServerDeploymentException("deploy_5012", new String[]{id, this.transactionType});
            }
            this.moduleID = id;
        } else {
            this.moduleID = "sap.com/" + id;
        }
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public byte getModuleType() {
        return 3;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public DTransaction getChildTransaction() {
        return this.childTransaction;
    }

    public void makeAllPhasesLocal() throws DeploymentException, ComponentNotDeployedException {
        try {
            try {
                this.beginLocal();
            }
            catch (DeploymentException dex) {
                this.rollbackLocal();
                throw dex;
            }
            catch (ComponentNotDeployedException cnde) {
                this.rollbackLocal();
                throw cnde;
            }
            try {
                this.prepareLocal();
            }
            catch (DeploymentException dex) {
                this.rollbackPrepareLocal();
                throw dex;
            }
            this.commitLocal();
            Object var4_4 = null;
            this.communicator.unregisterTransactionWithoutLock(this.moduleID);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.communicator.unregisterTransactionWithoutLock(this.moduleID);
            throw throwable;
        }
    }

    public void makeAllPhases() throws DeploymentException, ComponentNotDeployedException {
        try {
            this.begin();
        }
        catch (DeploymentException rex) {
            this.rollback();
            throw rex;
        }
        catch (ComponentNotDeployedException cnde) {
            this.rollback();
            throw cnde;
        }
        try {
            this.prepare();
        }
        catch (DeploymentException rex) {
            this.rollback();
            throw rex;
        }
        this.commit();
        this.remoteStatistics = this.remote.notifyRemotely(this, true);
    }

    public String[] getLibNames() {
        return this.libNames;
    }

    public int[] getOtherServerIDs() {
        return this.serverIds;
    }

    public void setUnregister(boolean unregister) {
        this.unregisterAfterFinish = unregister;
    }

    public boolean unregister() {
        return this.unregisterAfterFinish;
    }

    public void setBeginTime(long begin) {
        this.beginTime = begin;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    /*
     * Loose catch block
     */
    public void begin() throws DeploymentException, ComponentNotDeployedException {
        block20: {
            this.communicator.trace(200, "Begin " + this.getTransactionType());
            ConfigurationHandlerFactory factory = this.communicator.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
            Configuration config = null;
            if (factory != null) {
                try {
                    this.handler = factory.getConfigurationHandler();
                }
                catch (ConfigurationException ce) {
                    throw new ServerDeploymentException("deploy_5009", new String[]{this.getTransactionType(), this.getModuleID()}, ce);
                }
            } else {
                this.communicator.logInfo("Configuration manager is not available - can not open configuration.");
            }
            if (this.handler != null) {
                try {
                    config = this.handler.openConfiguration("apps/" + this.getModuleID(), 1);
                }
                catch (ConfigurationException cex) {
                    throw new ServerDeploymentException("deploy_5011", new String[]{"apps/" + this.getModuleID(), this.getModuleID(), this.getTransactionType()}, cex);
                }
                try {
                    ReferenceObject[] newRefsInDB = null;
                    if (this.getTransactionType().equals("makeRefs")) {
                        newRefsInDB = this.addRefs();
                    } else if (this.getTransactionType().equals("removeRefs")) {
                        newRefsInDB = this.removeRefs();
                    }
                    DUtils.setSerializedObject(config, "HASH_STR_STR:Reference_type", DUtils.decodeReferenceObjectArray(newRefsInDB), "of references.");
                }
                catch (ConfigurationException cex) {
                    this.communicator.logThrowable(cex);
                }
                this.handler.commit();
                this.beginLocal();
                Object var5_8 = null;
                try {
                    this.handler.closeAllConfigurations();
                }
                catch (ConfigurationException cex) {
                    this.communicator.logThrowable(cex);
                }
                this.handler = null;
                {
                    break block20;
                    catch (ConfigurationException e) {
                        throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    try {
                        this.handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException cex) {
                        this.communicator.logThrowable(cex);
                    }
                    this.handler = null;
                    throw throwable;
                }
            }
        }
    }

    protected abstract ReferenceObject[] addRefs();

    protected ReferenceObject[] removeRefs() {
        int i;
        ArrayList<ReferenceObject> res = new ArrayList<ReferenceObject>();
        ReferenceObject[] oldRefs = this.info.getReferences();
        if (oldRefs != null) {
            i = 0;
            while (i < oldRefs.length) {
                res.add(oldRefs[i]);
                ++i;
            }
        }
        if (this.libNames != null) {
            i = 0;
            while (i < this.libNames.length) {
                int j = 0;
                while (j < res.size()) {
                    if (this.libNames[i].equals(res.get(j).toString())) {
                        res.remove(j);
                        this.communicator.trace(100, "Found and removed reference " + this.libNames[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        ReferenceObject[] newRefs = new ReferenceObject[res.size()];
        res.toArray(newRefs);
        return newRefs;
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare " + this.getTransactionType());
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local " + this.getTransactionType());
    }

    /*
     * Loose catch block
     */
    public void rollback() {
        block9: {
            this.communicator.trace(200, "Rollback " + this.getTransactionType());
            if (this.handler != null) {
                this.handler.rollback();
                Object var3_1 = null;
                try {
                    this.handler.closeAllConfigurations();
                }
                catch (ConfigurationException cex2) {
                    this.communicator.logThrowable(cex2);
                }
                break block9;
                {
                    catch (ConfigurationException cex) {
                        this.communicator.logThrowable(cex);
                        Object var3_2 = null;
                        try {
                            this.handler.closeAllConfigurations();
                        }
                        catch (ConfigurationException cex2) {
                            this.communicator.logThrowable(cex2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        this.handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException cex2) {
                        this.communicator.logThrowable(cex2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback local " + this.getTransactionType());
    }

    public void rollbackPrepare() {
        this.communicator.trace(200, "Rollback prepare " + this.getTransactionType());
    }

    public void rollbackPrepareLocal() {
        this.communicator.trace(200, "Rollback prepare local" + this.getTransactionType());
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    public TransactionStatistics[] getStatistics() {
        if (this.remoteStatistics != null) {
            TransactionStatistics[] temp = new TransactionStatistics[this.remoteStatistics.length + 1];
            System.arraycopy(this.remoteStatistics, 0, temp, 0, this.remoteStatistics.length);
            temp[this.remoteStatistics.length] = this.currentStatistics;
            return temp;
        }
        return new TransactionStatistics[]{this.currentStatistics};
    }

    public void setStatistics(TransactionStatistics[] stats) {
        this.remoteStatistics = stats;
    }

    public TransactionStatistics getCurrentStatistics() {
        return this.currentStatistics;
    }

    public ReferenceObject[] getReferenceObjects() {
        return this.libraries;
    }

    public boolean needForTransaction() {
        return true;
    }

    public boolean isSuccessfullyFinished() {
        return this.needForTransaction() ? this.okFinished : true;
    }

    protected void setSuccessfullyFinished(boolean ok) {
        this.okFinished = ok;
    }

    public char getLockType() {
        return this.lockType;
    }

    public void setLockType(char lockType) {
        this.lockType = lockType;
    }

    public void addWarnings(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarnings(w);
        }
    }

    public void addWarning(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarning(w);
        }
    }

    public void addErrors(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addErrors(w);
        }
    }

    public void addError(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addError(w);
        }
    }

    public abstract void commitLocal();

    public abstract void commit();

    public abstract void beginLocal() throws DeploymentException, ComponentNotDeployedException;
}

