/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.library.ReferencesTransaction;
import java.util.ArrayList;

public class MakeReferencesTransaction
extends ReferencesTransaction {
    public MakeReferencesTransaction(String fromApplication, ReferenceObject[] toLibraries, TransactionCommunicator _communicator) throws DeploymentException {
        super(fromApplication, _communicator, "makeRefs");
        if (toLibraries == null || toLibraries.length == 0) {
            throw new ServerDeploymentException("deploy_5024", new String[]{this.getTransactionType(), "destinations"});
        }
        this.libraries = toLibraries;
        this.communicator.getReferenceResolver().checkCycleReferences(this.getModuleID(), toLibraries);
    }

    protected ReferenceObject[] addRefs() {
        return DUtils.concatReferences(this.info.getReferences(), this.libraries);
    }

    public void beginLocal() throws DeploymentException {
        if (this.libraries != null) {
            ArrayList warnings = new ArrayList();
            int i = 0;
            while (i < this.libraries.length) {
                try {
                    this.communicator.getReferenceResolver().processMakeReference(this.getModuleID(), this.libraries[i], warnings);
                }
                catch (DeploymentException dex) {
                    dex.log();
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < warnings.size()) {
                this.communicator.logWarning((String)warnings.get(i2));
                ++i2;
            }
        }
    }

    public void commit() {
        this.communicator.trace(200, "Commit " + this.getTransactionType());
        int i = 0;
        while (i < this.libraries.length) {
            this.communicator.addReferenceInternally(this.getModuleID(), this.libraries[i]);
            ++i;
        }
        String fromLoader = this.info.getLoaderName() == null ? this.getModuleID() : this.info.getLoaderName();
        int i2 = 0;
        while (i2 < this.libraries.length) {
            this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext().registerReference(fromLoader, this.libraries[i2].toString());
            ++i2;
        }
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local " + this.getTransactionType());
        int i = 0;
        while (i < this.libraries.length) {
            this.communicator.addReferenceInternally(this.getModuleID(), this.libraries[i]);
            ++i;
        }
        String fromLoader = this.info.getLoaderName() == null ? this.getModuleID() : this.info.getLoaderName();
        int i2 = 0;
        while (i2 < this.libraries.length) {
            this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext().registerReference(fromLoader, this.libraries[i2].toString());
            ++i2;
        }
        this.setSuccessfullyFinished(true);
    }
}

