/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.RemoteCaller;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.TransactionStatistics;

public abstract class LibraryTransaction
implements DTransaction {
    public static final byte LIBRARY = 0;
    public static final byte INTERFACE = 1;
    public static final byte SERVICE = 2;
    private long beginTime = 0L;
    protected TransactionCommunicator communicator = null;
    protected RemoteCaller remote = null;
    protected int clusterID;
    protected LoadContext loadContext;
    protected String moduleID = null;
    private boolean unregisterAfterFinish = false;
    protected String transactionType;
    protected int clusterElements = 0;
    protected int[] serverIds = null;
    protected DTransaction childTransaction = null;
    private TransactionStatistics currentStatistics = null;
    private boolean okFinished = false;
    protected byte type = 0;
    protected String libName = null;
    private char lockType = (char)88;

    public LibraryTransaction(TransactionCommunicator _communicator, String transType) {
        this.communicator = _communicator;
        this.remote = this.communicator.getRemoteCaller();
        this.serverIds = this.remote.getServerIDs();
        this.currentStatistics = new TransactionStatistics(this.communicator.getClusterID());
        this.transactionType = transType;
    }

    public DTransaction getChildTransaction() {
        return this.childTransaction;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public final void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public byte getModuleType() {
        return 2;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void makeAllPhasesLocal() throws DeploymentException {
    }

    public void makeAllPhases() throws DeploymentException, ComponentNotDeployedException {
        try {
            this.begin();
        }
        catch (DeploymentException rex) {
            this.rollback();
            throw rex;
        }
        catch (ComponentNotDeployedException cnde) {
            this.rollback();
            throw cnde;
        }
        try {
            this.prepare();
        }
        catch (DeploymentException rex) {
            this.rollback();
            throw rex;
        }
        this.commit();
    }

    public int[] getOtherServerIDs() {
        return this.serverIds;
    }

    public void setUnregister(boolean unregister) {
        this.unregisterAfterFinish = unregister;
    }

    public boolean unregister() {
        return this.unregisterAfterFinish;
    }

    public void setBeginTime(long begin) {
        this.beginTime = begin;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public TransactionStatistics[] getStatistics() {
        return new TransactionStatistics[]{this.currentStatistics};
    }

    public TransactionStatistics getCurrentStatistics() {
        return this.currentStatistics;
    }

    public void setStatistics(TransactionStatistics[] stats) {
    }

    public void beginLocal() throws DeploymentException, ComponentNotDeployedException {
        this.begin();
    }

    public void rollbackPrepare() {
    }

    public void prepare() throws DeploymentException {
    }

    public void prepareLocal() throws DeploymentException {
    }

    public void commit() {
    }

    public void commitLocal() {
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    public void rollbackPrepareLocal() {
    }

    public void rollback() {
    }

    public void rollbackLocal() {
    }

    public boolean needForTransaction() {
        return true;
    }

    public boolean isSuccessfullyFinished() {
        return this.needForTransaction() ? this.okFinished : true;
    }

    protected void setSuccessfullyFinished(boolean ok) {
        this.okFinished = ok;
    }

    public String getLibName() {
        return this.libName;
    }

    public char getLockType() {
        return this.lockType;
    }

    public void setLockType(char lockType) {
        this.lockType = lockType;
    }

    public void addWarnings(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarnings(w);
        }
    }

    public void addWarning(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarning(w);
        }
    }

    public void addErrors(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addErrors(w);
        }
    }

    public void addError(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addError(w);
        }
    }

    public abstract void begin() throws DeploymentException, ComponentNotDeployedException;
}

