/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.library;

import com.sap.engine.frame.container.deploy.ComponentDeploymentException;
import com.sap.engine.frame.container.deploy.DeployContext;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.library.LibraryTransaction;
import java.io.File;

public class DeployLibTransaction
extends LibraryTransaction {
    private String jar = null;

    public DeployLibTransaction(String jar, String name, byte type, TransactionCommunicator _communicator) throws DeploymentException {
        super(_communicator, "deployLib");
        if (jar == null) {
            throw new ServerDeploymentException("deploy_5020", new String[]{" the jar name is not specified."});
        }
        if (!new File(jar).exists()) {
            throw new ServerDeploymentException("deploy_5020", new String[]{"jar name " + jar + " doesn't exist."});
        }
        if (name != null) {
            this.libName = name;
        } else {
            this.libName = jar;
            if (jar.lastIndexOf(File.separatorChar) > -1) {
                this.libName = jar.substring(jar.lastIndexOf(File.separatorChar) + 1);
            }
            if (this.libName.endsWith(".jar")) {
                this.libName = this.libName.substring(0, this.libName.length() - 4);
            }
        }
        this.jar = jar;
        this.type = type;
        this.setModuleID(this.libName);
    }

    public void begin() throws DeploymentException {
        block5: {
            DeployContext dc = this.communicator.getApplicationServiceContext().getContainerContext().getDeployContext();
            try {
                if (this.type == 0) {
                    this.communicator.trace(200, "Start deploying library " + this.jar);
                    dc.deployLibrary(new File(this.jar));
                    this.communicator.trace(200, "End deploying library " + this.jar);
                    break block5;
                }
                if (this.type == 1) {
                    this.communicator.trace(200, "Start deploying interface " + this.jar);
                    dc.deployInterface(new File(this.jar));
                    this.communicator.trace(200, "End deploying interface " + this.jar);
                    break block5;
                }
                if (this.type == 2) {
                    this.communicator.trace(200, "Start deploying service " + this.jar);
                    dc.deployService(new File(this.jar));
                    this.communicator.trace(200, "End deploying service " + this.jar);
                    break block5;
                }
                throw new ServerDeploymentException("deploy_5022", new String[]{String.valueOf(this.type), this.jar});
            }
            catch (ComponentDeploymentException ex) {
                throw new ServerDeploymentException("deploy_5023", new String[]{this.getTransactionType(), this.jar}, ex);
            }
        }
        this.setSuccessfullyFinished(true);
    }
}

