/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.jar.EARReader;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.DeployUtilTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StartTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class UpdateTransaction
extends DeployUtilTransaction {
    protected DeploymentInfo oldDeployment = null;
    private boolean needStartAfterFinish = false;
    private byte oldStatus = (byte)5;

    public UpdateTransaction(String appName, TransactionCommunicator communicator, Hashtable containerProps, String[] containerNames) throws DeploymentException {
        this.setModuleID(appName);
        this.init(communicator);
        if (containerNames == null || containerNames.length == 0) {
            return;
        }
        ContainerInterface cont = null;
        int i = 0;
        while (i < containerNames.length) {
            cont = communicator.getContainer(containerNames[i]);
            if (cont == null) {
                throw new ServerDeploymentException("deploy_5006", new String[]{containerNames[i], this.getTransactionType(), this.getModuleID()});
            }
            this.addContainer(cont, (Properties)containerProps.get(containerNames[i]));
            ++i;
        }
    }

    private void init(TransactionCommunicator communicator) throws DeploymentException {
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)0);
        this.setTransactionType("update");
    }

    public UpdateTransaction(String earFilePath, Properties props, TransactionCommunicator communicator) throws DeploymentException {
        this.moduleFile = new File(earFilePath);
        this.props = props;
        try {
            this.reader = new EARReader(this.moduleFile.getAbsolutePath());
            this.reader.webServicesCheck();
            this.descr = this.reader.getEARDescriptor();
        }
        catch (IOException ioex) {
            if (this.reader != null) {
                this.reader.clear();
            }
            throw new DeploymentException("deploy_5041", (Object[])new String[]{earFilePath});
        }
        if (this.reader.getErrorMsg(true) != null && !this.reader.getErrorMsg(true).equals("")) {
            communicator.logDebug(this.reader.getErrorMsg(true));
        }
        if (this.reader.getErrorMsg(false) != null && !this.reader.getErrorMsg(false).equals("")) {
            System.out.println(this.reader.getErrorMsg(false));
        }
        if (this.descr.getDisplayName() == null) {
            this.reader.clear();
            throw new ServerDeploymentException("deploy_5012", new String[]{"", "update"});
        }
        this.setComponentName(this.descr.getDisplayName());
        if (this.descr.getProviderName() != null) {
            this.setProviderName(this.descr.getProviderName());
        }
        this.init(communicator);
        this.oldDeployment = communicator.getApplicationInfo(this.getModuleID());
        if (this.oldDeployment == null) {
            this.reader.clear();
            return;
        }
        this.remoteSupport = this.oldDeployment.getRemoteSupport();
    }

    public UpdateTransaction(String moduleFilePath, String containerName, String[] remoteSupport, Properties props, TransactionCommunicator communicator) throws DeploymentException {
        this.remoteSupport = remoteSupport;
        this.props = props;
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)1);
        this.setTransactionType("deploy");
        this.moduleFile = new File(moduleFilePath);
        ArrayList<String> suitableContainers = new ArrayList<String>();
        if (containerName != null && communicator.getContainer(containerName) != null) {
            suitableContainers.add(containerName);
        } else {
            this.findSuitableContainersForStandAlone(suitableContainers);
        }
        if (suitableContainers.size() == 0) {
            throw new ServerDeploymentException("deploy_5014", new String[]{this.moduleFile.getName()});
        }
        String contNames = "";
        this.singleContainers = new String[suitableContainers.size()];
        suitableContainers.toArray(this.singleContainers);
        int i = 0;
        while (i < this.singleContainers.length) {
            contNames = contNames + this.singleContainers[i] + "; ";
            ++i;
        }
        communicator.logInfo("Because of container name for the component " + this.moduleFile.getName() + " was not specified, deploy service used the mechanism for identifiying components and found the following suitable containers: " + contNames);
        this.defineModuleIDforStandAlone();
        this.oldDeployment = communicator.getApplicationInfo(this.getModuleID());
        if (this.oldDeployment == null) {
            return;
        }
        remoteSupport = this.oldDeployment.getRemoteSupport();
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Start updating application [" + this.getModuleID() + "]");
        this.oldStatus = this.oldDeployment.getStatus();
        this.openHandler();
        this.config = this.openApplicationConfiguration("apps", 0);
        this.commonBegin();
        this.deployment.setStatus((byte)2);
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.logDebug("Deploy dump : begin local " + this.getTransactionType() + " of application " + this.getModuleID());
        try {
            this.openHandler();
            if (this.getHandler() == null) {
                System.out.println("Configuration manager is not available - can not open configuration.");
            } else {
                this.config = this.openApplicationConfiguration("apps", 0);
                DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID(), true, false, this.config, this.openApplicationConfiguration("deploy", 0));
                if (this.containers != null) {
                    int i = 0;
                    while (i < this.containers.length) {
                        try {
                            this.containers[i].notifyUpdatedComponents(this.getModuleID(), this.config, this.contProperties[i]);
                        }
                        catch (WarningException wex) {
                            wex.printStackTrace();
                            this.addWarnings(wex.getWarnings());
                        }
                        ++i;
                    }
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.commitHandler();
            }
            catch (ConfigurationException e) {
                throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, e);
            }
            throw throwable;
        }
        try {
            this.commitHandler();
        }
        catch (ConfigurationException e) {
            throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare updating application [" + this.getModuleID() + "]");
        if (this.containers != null && this.containers.length > 0) {
            if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                this.communicator.bindLoader(this, this.getModuleID(), this.deployment);
            }
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].prepareUpdate(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                ++i;
            }
        }
        try {
            try {
                this.commitHandler();
            }
            catch (ConfigurationException ce) {
                this.setHandler(null);
                throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, ce);
            }
            Object var4_4 = null;
            if (this.getModuleType() == 0) {
                if (this.reader == null) return;
                this.reader.clear();
                return;
            }
            if (this.tempDirForStandAlone == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.getModuleType() == 0) {
                if (this.reader == null) throw throwable;
                this.reader.clear();
                throw throwable;
            }
            if (this.tempDirForStandAlone == null) throw throwable;
            FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
            throw throwable;
        }
        FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
    }

    public void prepareLocal() throws DeploymentException {
    }

    public void commit() {
        this.communicator.trace(200, "Commit updating application [" + this.getModuleID() + "]");
        try {
            ApplicationDeployInfo appInfo = null;
            this.communicator.addApplicationInfo(this.getModuleID(), this.deployment, false);
            if (this.containers != null) {
                int i = 0;
                while (i < this.containers.length) {
                    try {
                        appInfo = this.containers[i].commitUpdate(this.getModuleID());
                        if (appInfo != null && appInfo.getWarnings() != null && appInfo.getWarnings().size() > 0) {
                            String[] w = new String[appInfo.getWarnings().size()];
                            appInfo.getWarnings().toArray(w);
                            this.addWarnings(w);
                        }
                    }
                    catch (WarningException wex) {
                        this.addWarnings(wex.getWarnings());
                    }
                    catch (OutOfMemoryError oofme) {
                        throw oofme;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable th) {
                        new ServerDeploymentException("deploy_5082", new String[]{"committing update of application " + this.getModuleID() + " on container " + this.containers[i].getContainerInfo().getName()}, th).log();
                    }
                    ++i;
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                    this.communicator.removeApplicationLoader(this.getModuleID());
                }
            }
            catch (DeploymentException dex) {
                dex.log();
            }
            throw throwable;
        }
        try {
            if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                this.communicator.removeApplicationLoader(this.getModuleID());
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        if (this.needStartAfterFinish) {
            this.deployment.setStatus((byte)0);
        } else {
            this.deployment.setStatus(this.oldStatus);
        }
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.setSuccessfullyFinished(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() {
        block34: {
            this.communicator.trace(200, "Rollback updating application [" + this.getModuleID() + "]");
            this.communicator.addApplicationInfo(this.getModuleID(), this.oldDeployment, false);
            try {
                if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                    this.communicator.bindLoader(this, this.getModuleID(), this.oldDeployment);
                }
            }
            catch (DeploymentException dex) {
                dex.log();
            }
            try {
                this.getHandler().rollback();
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler in update of application " + this.getModuleID()}, th).log();
            }
            try {
                if (this.containers != null) {
                    int i = 0;
                    while (i < this.containers.length) {
                        try {
                            this.containers[i].rollbackUpdate(this.getModuleID(), this.config, this.contProperties[i]);
                        }
                        catch (WarningException wex) {
                            this.addWarnings(wex.getWarnings());
                        }
                        catch (OutOfMemoryError oofme) {
                            throw oofme;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable th) {
                            new ServerDeploymentException("deploy_5082", new String[]{"committing update of application " + this.getModuleID() + " on container " + this.containers[i].getContainerInfo().getName()}, th).log();
                        }
                        ++i;
                    }
                }
                try {
                    this.getHandler().closeAllConfigurations();
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler in update of application " + this.getModuleID()}, th).log();
                }
                Object var7_13 = null;
                if (this.getModuleType() == 0) {
                    if (this.reader != null) {
                        this.reader.clear();
                    }
                    break block34;
                }
                if (this.tempDirForStandAlone == null) break block34;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                if (this.getModuleType() == 0) {
                    if (this.reader != null) {
                        this.reader.clear();
                    }
                } else if (this.tempDirForStandAlone != null) {
                    FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
                }
                try {
                    if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                        this.communicator.removeApplicationLoader(this.getModuleID());
                    }
                }
                catch (DeploymentException dex) {
                    dex.log();
                }
                if (this.needStartAfterFinish) {
                    this.oldDeployment.setStatus((byte)0);
                    throw throwable;
                } else {
                    this.oldDeployment.setStatus(this.oldStatus);
                }
                throw throwable;
            }
            FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
        }
        try {
            if (this.oldStatus == 0 || this.oldStatus == 1 && this.needStartAfterFinish) {
                this.communicator.removeApplicationLoader(this.getModuleID());
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        if (this.needStartAfterFinish) {
            this.oldDeployment.setStatus((byte)0);
            return;
        }
        this.oldDeployment.setStatus(this.oldStatus);
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback updating locally application [" + this.getModuleID() + "]");
    }

    public void rollbackPrepare() {
        this.communicator.trace(200, "Rollback prepare updating application [" + this.getModuleID() + "]");
        try {
            this.communicator.removeApplicationLoader(this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.rollback();
    }

    public void rollbackPrepareLocal() {
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    public String[] getResult() {
        return this.allComponents;
    }

    protected String[] makeComponents(File[] componentFiles, ContainerDeploymentInfo containerInfo, Properties contProps, ContainerInterface cont) throws DeploymentException {
        ApplicationDeployInfo tempInfo = null;
        if (cont == null) {
            return null;
        }
        if (componentFiles == null) {
            componentFiles = new File[]{};
        }
        String contName = cont.getContainerInfo().getName();
        this.communicator.logDebug("Start updating on container " + contName);
        try {
            tempInfo = cont.makeUpdate(componentFiles, containerInfo, contProps);
        }
        catch (DeploymentException de) {
            this.addContainer(cont, contProps);
            throw de;
        }
        catch (Exception th) {
            this.addContainer(cont, contProps);
            throw new ServerDeploymentException("deploy_5089", new String[]{this.getModuleID(), contName}, th);
        }
        catch (OutOfMemoryError oofmer) {
            this.addContainer(cont, contProps);
            throw oofmer;
        }
        catch (ThreadDeath td) {
            this.addContainer(cont, contProps);
            throw td;
        }
        catch (Error err) {
            this.addContainer(cont, contProps);
            throw new ServerDeploymentException("deploy_5089", new String[]{this.getModuleID(), contName}, err);
        }
        return this.processApplicationDeployInfo(tempInfo, cont);
    }

    private void addChangesInWebProps(Properties webProps) {
        Properties oldProps;
        Properties props = this.deployment.getProperties();
        Vector<String> newAliases = new Vector<String>();
        Vector<String> removedAliases = new Vector<String>();
        if (props != null) {
            Enumeration keys = ((Hashtable)props).keys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                ((Hashtable)webProps).put(key, props.getProperty(key));
                newAliases.add(props.getProperty(key));
            }
        }
        if ((oldProps = this.oldDeployment.getProperties()) != null) {
            Enumeration oldAliases = ((Hashtable)oldProps).elements();
            String oldAlias = null;
            while (oldAliases.hasMoreElements()) {
                oldAlias = (String)oldAliases.nextElement();
                if (!newAliases.contains(oldAlias)) {
                    removedAliases.add(oldAlias);
                    continue;
                }
                newAliases.remove(oldAlias);
            }
        }
        String[] newTemp = new String[newAliases.size()];
        String[] removedTemp = new String[removedAliases.size()];
        newAliases.toArray(newTemp);
        removedAliases.toArray(removedTemp);
        ((Hashtable)webProps).put("added_aliases", newTemp);
        ((Hashtable)webProps).put("removed_aliases", removedTemp);
    }

    protected Hashtable getConcernedContainers(Hashtable allContFiles, ContainerDeploymentInfo containerInfo) throws DeploymentException {
        ArrayList<ContainerInterface> cies = new ArrayList<ContainerInterface>();
        Enumeration conts = allContFiles.keys();
        ContainerInterface ci = null;
        String name = null;
        while (conts.hasMoreElements()) {
            name = (String)conts.nextElement();
            ci = this.communicator.getContainer(name);
            if (ci != null) {
                cies.add(ci);
                continue;
            }
            throw new ServerDeploymentException("deploy_5006", new String[]{name, this.getTransactionType(), this.getModuleID()});
        }
        ArrayList<String> stoppedOptionalContainers = new ArrayList<String>();
        String[] oldConts = this.oldDeployment.getContainerNames();
        if (oldConts != null) {
            int i = 0;
            while (i < oldConts.length) {
                if (allContFiles.get(oldConts[i]) == null) {
                    ci = this.communicator.getContainer(oldConts[i]);
                    if (ci != null) {
                        cies.add(ci);
                    } else if (this.oldDeployment.isOptionalContainer(oldConts[i])) {
                        stoppedOptionalContainers.add(oldConts[i]);
                    } else {
                        throw new ServerDeploymentException("deploy_5006", new String[]{oldConts[i], this.getTransactionType(), this.getModuleID()});
                    }
                }
                ++i;
            }
        }
        ContainerInterface[] res = new ContainerInterface[cies.size()];
        cies.toArray(res);
        String[] stoppedOptionalContainerNames = new String[stoppedOptionalContainers.size()];
        stoppedOptionalContainers.toArray(stoppedOptionalContainerNames);
        Hashtable result = this.getContainersWhichNeedUpdate(res, stoppedOptionalContainerNames, allContFiles, containerInfo);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable getContainersWhichNeedUpdate(ContainerInterface[] concernedContainers, String[] stoppedOptionalContainerNames, Hashtable allContFiles, ContainerDeploymentInfo containerInfo) throws DeploymentException {
        Hashtable<ContainerInterface, Properties> res;
        block23: {
            String[] oldContainerFilesForClassLoader = null;
            if (this.oldDeployment.isStandAloneArchive() == this.deployment.isStandAloneArchive()) {
                oldContainerFilesForClassLoader = this.getCLFilesForDB(this.oldDeployment.getContainerFilesForClassLoader(), null);
            }
            if (oldContainerFilesForClassLoader != null) {
                this.deployment.addContainerFilesForClassLoader(this.getCLFilesForDB(this.oldDeployment.getContainerFilesForClassLoader(), null));
            }
            this.deployment.setLoaderName(this.oldDeployment.getLoaderName());
            this.deployment.setResources(this.oldDeployment.getResources());
            Properties[] cProps = new Properties[concernedContainers.length];
            int i = 0;
            while (i < concernedContainers.length) {
                cProps[i] = new Properties();
                ++i;
            }
            res = new Hashtable<ContainerInterface, Properties>();
            String contName = null;
            File[] files = null;
            boolean defineAppLoader = false;
            if (this.oldDeployment.getStatus() == 0) {
                defineAppLoader = true;
                this.communicator.bindLoader(this, this.getModuleID(), this.oldDeployment);
            }
            try {
                int i2;
                if (stoppedOptionalContainerNames != null) {
                    i2 = 0;
                    while (i2 < stoppedOptionalContainerNames.length) {
                        this.addWarning("Container " + stoppedOptionalContainerNames[i2] + " is stopped, but it is registered as optional container so update of application " + this.getModuleID() + " continues with the old deployment configuration for this container. All changes in the modules, that have to be deployed on this container, will take no effect after update of the application.");
                        this.copyInfoForUnchangedContainers(stoppedOptionalContainerNames[i2]);
                        ++i2;
                    }
                }
                i2 = 0;
                while (true) {
                    block24: {
                        if (i2 >= concernedContainers.length) {
                            Object var15_16 = null;
                            if (defineAppLoader) {
                                break;
                            }
                            break block23;
                        }
                        if (concernedContainers[i2].getContainerInfo().isJ2EEContainer() && concernedContainers[i2].getContainerInfo().getJ2EEModuleName().equals("web")) {
                            this.addChangesInWebProps(cProps[i2]);
                        }
                        contName = concernedContainers[i2].getContainerInfo().getName();
                        try {
                            files = (File[])allContFiles.get(contName);
                            if (files == null) {
                                files = new File[]{};
                            }
                            if (concernedContainers[i2].needUpdate(files, containerInfo, cProps[i2])) {
                                res.put(concernedContainers[i2], cProps[i2]);
                                break block24;
                            }
                            if (this.oldDeployment.getDeployedComponents() != null) {
                                this.copyInfoForUnchangedContainers(concernedContainers[i2].getContainerInfo().getName());
                            }
                        }
                        catch (WarningException wex) {
                            this.addWarnings(wex.getWarnings());
                        }
                    }
                    ++i2;
                }
                this.communicator.removeApplicationLoader(this.getModuleID());
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (defineAppLoader) {
                    this.communicator.removeApplicationLoader(this.getModuleID());
                }
                throw throwable;
            }
        }
        ContainerInterface[] result = new ContainerInterface[res.size()];
        Enumeration conts = res.keys();
        int i = 0;
        while (conts.hasMoreElements()) {
            result[i++] = (ContainerInterface)conts.nextElement();
        }
        try {
            try {
                this.config.close();
            }
            catch (ConfigurationException cex) {
                throw new ServerDeploymentException("deploy_5029", new String[]{"update", this.getModuleID()}, cex);
            }
            Object var17_21 = null;
            this.config = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.config = null;
            throw throwable;
        }
        this.needStopApplicationPhase(result, allContFiles, containerInfo);
        return res;
    }

    private void copyInfoForUnchangedContainers(String contName) {
        String[] deployedComponents = (String[])this.oldDeployment.getDeployedComponents().get(contName);
        if (deployedComponents != null) {
            if (deployedComponents != null) {
                ContainerInterface cont = this.communicator.getContainer(contName);
                deployedComponents = cont != null ? DUtils.addToElements(deployedComponents, " - " + (cont.getContainerInfo().isJ2EEContainer() ? cont.getContainerInfo().getJ2EEModuleName().toUpperCase() : cont.getContainerInfo().getModuleName().toUpperCase())) : DUtils.addToElements(deployedComponents, " - deployed on " + contName);
                this.allComponents = DUtils.concatArrays(this.allComponents, deployedComponents);
            }
            this.deployment.addDeployedComponents(contName, deployedComponents);
            this.deployment.addContainerName(contName);
            if (this.oldDeployment.isOptionalContainer(contName)) {
                this.deployment.addOptionalContainer(contName);
            }
            String[] temp = null;
            int j = 0;
            while (j < deployedComponents.length) {
                temp = this.oldDeployment.getResTypesOfComponent(deployedComponents[j]);
                if (temp != null) {
                    this.deployment.addDeployedComponent_ResTypes(deployedComponents[j], temp);
                }
                ++j;
            }
        }
    }

    private void needStopApplicationPhase(ContainerInterface[] concernedContainers, Hashtable allContFiles, ContainerDeploymentInfo containerInfo) throws DeploymentException {
        if (this.oldDeployment.getStatus() == 1) {
            File[] files = null;
            int i = 0;
            while (i < concernedContainers.length) {
                try {
                    files = (File[])allContFiles.get(concernedContainers[i].getContainerInfo().getName());
                    if (files == null) {
                        files = new File[]{};
                    }
                    if (concernedContainers[i].needStopOnUpdate(files, containerInfo, this.props)) {
                        this.communicator.addApplicationInfo(this.getModuleID(), this.oldDeployment, true);
                        this.childTransaction = new StopTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null), false);
                        this.makeNestedParallelTransaction((ParallelAdapter)this.childTransaction);
                        this.needStartAfterFinish = true;
                        return;
                    }
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                ++i;
            }
        }
    }

    protected void finalActions() throws WarningException, DeploymentException {
        if (this.needStartAfterFinish && this.oldStatus == 1 || this.oldStatus == 6) {
            try {
                this.childTransaction = new StartTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null));
                if (this.childTransaction.needForTransaction()) {
                    this.makeNestedParallelTransaction((ParallelAdapter)this.childTransaction);
                }
            }
            catch (DeploymentException dex) {
                dex.log();
            }
        }
    }
}

