/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.InitialContext;

public class StopTransaction
extends ParallelAdapter {
    private byte initialState = 0;
    private Configuration config = null;
    private boolean implicit = false;
    private boolean okInit = true;

    public StopTransaction(String appName, TransactionCommunicator communicator, int initialStopClusterID, String[] containerNames, boolean implicit) throws DeploymentException {
        this.init(appName, communicator, "stopApp");
        this.implicit = implicit;
        this.sendResponse = true;
        this.sendToClusterID = initialStopClusterID;
        Object cont = null;
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
        this.initialState = info.getStatus();
        if (this.initialState != 1) {
            this.setNeedForTransation(false);
            this.okInit = false;
            return;
        }
        if (containerNames == null) {
            containerNames = info.getContainerNames();
        }
        if (containerNames == null) {
            throw new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    public StopTransaction(String applicationName, TransactionCommunicator communicator, int[] ids, boolean implicit) throws DeploymentException {
        this.init(applicationName, communicator, "stopApp");
        this.setServerIDs(ids);
        if (ids.length == this.remote.getServerIDs().length + 1) {
            this.wholeCluster = true;
        }
        this.implicit = implicit;
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), communicator.getClusterIDName(), this.getTransactionType()});
        }
        String sName = null;
        ClusterElement cEment = null;
        int i = 0;
        while (i < ids.length) {
            cEment = communicator.getApplicationServiceContext().getClusterContext().getClusterMonitor().getParticipant(ids[i]);
            if (communicator.getApplicationServiceContext() != null && cEment != null && (cEment.getState() == 3 || cEment.getState() == 7)) {
                sName = cEment.getName();
                try {
                    if (!communicator.getApplicationStatus(this.getModuleID(), sName).equals("STARTED")) {
                        this.removeServerIDInitially(ids[i]);
                    }
                }
                catch (RemoteException rex) {
                    ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, rex);
                    dex.log();
                }
            } else {
                this.removeServerIDInitially(ids[i]);
            }
            ++i;
        }
        if (this.getOtherServerIDs().length == 0) {
            this.setNeedForTransation(false);
            this.okInit = false;
            return;
        }
        int[] iinfoes = this.getOtherServerIDs();
        this.setInitiallyInfoes(iinfoes);
        if (iinfoes != null) {
            this.setReceiveMonitorCounter(iinfoes.length);
        }
        if (this.foundCurrent(ids)) {
            this.initialState = info.getStatus();
            if (this.initialState != 1) {
                this.okInit = false;
                return;
            }
            String[] contNames = info.getContainerNames();
            if (contNames == null || contNames.length == 0) {
                throw new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
            }
        } else {
            this.okInit = false;
        }
    }

    public StopTransaction(String appName, TransactionCommunicator communicator, boolean implicit) throws DeploymentException {
        this.init(appName, communicator, "stopApp");
        Object currentInt = null;
        this.implicit = implicit;
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
        this.initialState = info.getStatus();
        if (this.initialState != 1) {
            this.setNeedForTransation(false);
            this.okInit = false;
            return;
        }
        String[] contNames = info.getContainerNames();
        if (contNames == null) {
            throw new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Begin " + this.getTransactionType() + " of application " + this.getModuleID());
        this.beginCommon();
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.beginCommon();
    }

    private void beginCommon() throws DeploymentException {
        if (!this.okInit) {
            return;
        }
        this.initialState = this.communicator.getApplicationInfo(this.getModuleID()).getStatus();
        if (this.initialState != 1) {
            this.okInit = false;
            this.communicator.trace(200, "Transaction " + this.getTransactionType() + " for application " + this.getModuleID() + " is rejected internally.");
            return;
        }
        DeploymentInfo info = null;
        this.initConfig();
        info = this.communicator.getApplicationInfo(this.getModuleID());
        this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)4);
        String[] w = this.resolver.beforeStoppingApplication(info);
        this.addWarnings(w);
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare " + this.getTransactionType() + " of application " + this.getModuleID());
        this.prepareCommon();
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.prepareCommon();
    }

    private void prepareCommon() throws DeploymentException {
        if (!this.okInit) {
            return;
        }
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        String[] contNames = info.getContainerNames();
        ArrayList<ContainerInterface> tempContsList = new ArrayList<ContainerInterface>();
        ContainerInterface cont = null;
        int i = 0;
        while (i < contNames.length) {
            cont = this.communicator.getContainer(contNames[i]);
            if (cont == null) {
                if (!info.isOptionalContainer(contNames[i])) {
                    this.addWarning("Obligatory container " + contNames[i] + " is not active at the moment.");
                } else {
                    this.addWarning("Optional container " + contNames[i] + " is not active at the moment.");
                }
            } else {
                tempContsList.add(cont);
            }
            ++i;
        }
        ContainerInterface[] tempConts = new ContainerInterface[tempContsList.size()];
        tempContsList.toArray(tempConts);
        this.sortContainersInc(tempConts);
        int i2 = 0;
        while (i2 < tempConts.length) {
            block16: {
                Object var14_9;
                try {
                    try {
                        tempConts[i2].prepareStop(this.getModuleID(), this.config);
                    }
                    catch (WarningException wex) {
                        this.addWarnings(wex.getWarnings());
                        var14_9 = null;
                        this.addContainer(tempConts[i2], null);
                        break block16;
                    }
                    catch (DeploymentException de) {
                        throw de;
                    }
                    catch (OutOfMemoryError oofmer) {
                        throw oofmer;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable th) {
                        throw new ServerDeploymentException("deploy_5082", new String[]{"preparing stop of application " + this.getModuleID()}, th);
                    }
                    var14_9 = null;
                    this.addContainer(tempConts[i2], null);
                }
                catch (Throwable throwable) {
                    var14_9 = null;
                    this.addContainer(tempConts[i2], null);
                    throw throwable;
                }
            }
            ++i2;
        }
        if (this.containers == null) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    public void commonCommitFinished() {
        this.communicator.trace(200, "Commit " + this.getTransactionType() + " finished of application " + this.getModuleID());
        try {
            DeploymentInfo deployment = null;
            deployment = this.communicator.getApplicationInfo(this.getModuleID());
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].commitStop(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing stop of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
            this.communicator.removeApplicationLoader(this.getModuleID());
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("clear_cache", "true");
            new InitialContext(env).lookup("");
            this.communicator.trace(100, "CACHE CLEARED");
        }
        catch (Exception e) {
            this.communicator.trace(100, "CACHE MAY BE NOT CLEARED!");
            this.communicator.trace(200, "Can not lookup application - already removed.");
        }
        if (!this.implicit) {
            this.communicator.getReferenceResolver().removeUsedResources(this.getModuleID());
            this.communicator.getReferenceResolver().removeMissingResources(this.getModuleID());
        }
        this.setSuccessfullyFinished(true);
    }

    public void commit() {
        this.commitCommon(false);
    }

    public void commitLocal() {
        this.commitCommon(true);
    }

    private void commitCommon(boolean isLocal) {
        block11: {
            if (!this.okInit) {
                this.setSuccessfullyFinished(true);
                return;
            }
            try {
                this.commonCommitFinished();
                Object var3_2 = null;
                if (!this.implicit) {
                    this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)0);
                    break block11;
                }
                this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)6);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (!this.implicit) {
                    this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)0);
                } else {
                    this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)6);
                }
                try {
                    if (this.getHandler() != null) {
                        this.commitHandler();
                    }
                }
                catch (ConfigurationException cex) {
                    new ServerDeploymentException("deploy_5082", new String[]{(isLocal ? "local " : "") + "commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
                }
                throw throwable;
            }
        }
        try {
            if (this.getHandler() != null) {
                this.commitHandler();
            }
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{(isLocal ? "local " : "") + "commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
    }

    public void rollback() {
        if (!this.okInit) {
            return;
        }
        if (this.implicit) {
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)6);
        } else {
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)0);
        }
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
    }

    public void rollbackLocal() {
        this.rollback();
    }

    public void rollbackPrepare() {
        if (!this.okInit) {
            return;
        }
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].rollbackStop(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking stop of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
        }
        try {
            this.communicator.removeApplicationLoader(this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.rollback();
    }

    public void rollbackPrepareLocal() {
        this.rollbackPrepare();
    }

    private void initConfig() throws DeploymentException {
        this.openHandler();
        if (this.getHandler() == null) {
            this.communicator.logInfo("Configuration manager is not available - can not open configuration.");
        } else {
            this.config = this.openApplicationConfiguration("apps", 0);
        }
    }

    protected void setStatusInDB() {
        int[] ids = this.remote.getServerIDs();
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        if (info != null && info.getStatus() == 1) {
            return;
        }
        String sName = null;
        ClusterElement cEment = null;
        int i = 0;
        while (i < ids.length) {
            cEment = this.communicator.getApplicationServiceContext().getClusterContext().getClusterMonitor().getParticipant(ids[i]);
            if (this.communicator.getApplicationServiceContext() != null && cEment != null) {
                sName = cEment.getName();
            }
            try {
                if (this.communicator.getApplicationStatus(this.getModuleID(), sName).equals("STARTED")) {
                    this.saveStatus((byte)1);
                    return;
                }
            }
            catch (RemoteException rex) {
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, rex);
                dex.log();
            }
            ++i;
        }
        this.saveStatus((byte)0);
    }
}

