/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.Resource;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class StartTransaction
extends ParallelAdapter {
    private byte initialState = 0;
    private Configuration config = null;
    private boolean okInit = true;

    public StartTransaction(String appName, TransactionCommunicator communicator, int initialStartClusterID, String[] containerNames) throws DeploymentException {
        this.init(appName, communicator, "startApp");
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), this.getTransactionType()});
        }
        this.initialState = info.getStatus();
        this.sendResponse = true;
        this.sendToClusterID = initialStartClusterID;
        if (this.initialState != 0 && this.initialState != 6) {
            this.setNeedForTransation(false);
            this.okInit = false;
            return;
        }
    }

    public StartTransaction(String applicationName, TransactionCommunicator communicator, int[] ids) throws DeploymentException {
        DeploymentInfo info;
        this.init(applicationName, communicator, "startApp");
        this.setServerIDs(ids);
        if (ids.length == this.remote.getServerIDs().length + 1) {
            this.wholeCluster = true;
        }
        if ((info = communicator.getApplicationInfo(this.getModuleID())) == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), communicator.getClusterIDName(), this.getTransactionType()});
        }
        String sName = null;
        ClusterElement cEment = null;
        String status1 = null;
        int i = 0;
        while (i < ids.length) {
            cEment = communicator.getApplicationServiceContext().getClusterContext().getClusterMonitor().getParticipant(ids[i]);
            if (communicator.getApplicationServiceContext() != null && cEment != null && (cEment.getState() == 3 || cEment.getState() == 7)) {
                sName = cEment.getName();
                try {
                    status1 = communicator.getApplicationStatus(this.getModuleID(), sName);
                    if (!status1.equals("STOPPED") && !status1.equals("IMPLICIT_STOPPED")) {
                        this.removeServerIDInitially(ids[i]);
                    }
                }
                catch (RemoteException rex) {
                    ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, rex);
                    dex.log();
                }
            } else {
                this.removeServerIDInitially(ids[i]);
            }
            ++i;
        }
        if (this.getOtherServerIDs().length == 0) {
            this.setNeedForTransation(false);
        }
        int[] iinfoes = this.getOtherServerIDs();
        this.setInitiallyInfoes(iinfoes);
        if (iinfoes != null) {
            this.setReceiveMonitorCounter(iinfoes.length);
        }
        if (this.foundCurrent(ids)) {
            this.initialState = info.getStatus();
            if (this.initialState != 0 && this.initialState != 6) {
                this.okInit = false;
                return;
            }
        } else {
            this.okInit = false;
        }
    }

    public StartTransaction(String appName, TransactionCommunicator communicator) throws DeploymentException {
        this.init(appName, communicator, "startApp");
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
        this.initialState = info.getStatus();
        if (this.initialState != 0 && this.initialState != 6) {
            this.setNeedForTransation(false);
            this.okInit = false;
            return;
        }
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Begin " + this.getTransactionType() + " of application " + this.getModuleID());
        this.beginCommon();
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.beginCommon();
    }

    private void beginCommon() throws DeploymentException {
        if (!this.okInit) {
            return;
        }
        this.initialState = this.communicator.getApplicationInfo(this.getModuleID()).getStatus();
        if (this.initialState != 0 && this.initialState != 6) {
            this.okInit = false;
            this.communicator.trace(200, "Transaction " + this.getTransactionType() + " for application " + this.getModuleID() + " is rejected internally.");
            return;
        }
        DeploymentInfo info = null;
        this.openHandler();
        if (this.getHandler() == null) {
            this.communicator.logInfo("Configuration manager is not available - can not open configuration.");
        } else {
            this.config = this.openApplicationConfiguration("apps", 0);
        }
        this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)3);
        info = this.communicator.getApplicationInfo(this.getModuleID());
        this.initialState = (byte)6;
        String[] w = this.resolver.beforeStartingApplication(info);
        this.initialState = 0;
        this.addWarnings(w);
        try {
            this.downloadInternalLibraries(this.config);
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5037", new String[]{this.getModuleID(), this.getTransactionType()}, cex);
        }
        String[] contNames = info.getContainerNames();
        if (contNames == null || contNames.length == 0) {
            throw new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
        }
        ContainerInterface currentInt = null;
        int i = 0;
        while (i < contNames.length) {
            currentInt = this.communicator.getContainer(contNames[i]);
            if (currentInt == null) {
                if (!info.isOptionalContainer(contNames[i])) {
                    throw new ServerDeploymentException("deploy_5006", new String[]{contNames[i], this.getTransactionType(), this.getModuleID()});
                }
            } else {
                try {
                    currentInt.downloadApplicationFiles(this.getModuleID(), this.config);
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (DeploymentException de) {
                    throw de;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    throw new ServerDeploymentException("deploy_5082", new String[]{"downloading files of application " + this.getModuleID()}, th);
                }
            }
            ++i;
        }
    }

    private void downloadInternalLibraries(Configuration config) throws DeploymentException, ConfigurationException {
        if (config != null) {
            Hashtable libsCRC = null;
            if (config.existsFile("HASH_STR_BYTE[]:LibFileName_CRC") || config.existsConfigEntry("HASH_STR_BYTE[]:LibFileName_CRC")) {
                try {
                    libsCRC = (Hashtable)DUtils.getDeserializedObject(config, "HASH_STR_BYTE[]:LibFileName_CRC");
                }
                catch (ServerDeploymentException sde) {
                    sde.log();
                    return;
                }
            }
            if (libsCRC == null) {
                return;
            }
            File appsWorkDir = new File(this.communicator.getAppsWorkDir() + this.getModuleID().replace('/', File.separatorChar));
            if (!appsWorkDir.exists()) {
                appsWorkDir.mkdirs();
            }
            Vector<File> appFiles = new Vector<File>();
            File[] appSubfolders = appsWorkDir.listFiles();
            if (appSubfolders != null) {
                int i = 0;
                while (i < appSubfolders.length) {
                    if (!appSubfolders[i].isDirectory()) {
                        appFiles.add(appSubfolders[i]);
                    } else if (this.communicator.getContainer(appSubfolders[i].getName()) == null) {
                        this.listRecursivelyDir(appSubfolders[i], appFiles);
                    }
                    ++i;
                }
            }
            String entry = null;
            File appFile = null;
            Hashtable temp = (Hashtable)libsCRC.clone();
            if (appFiles != null) {
                int i = 0;
                while (i < appFiles.size()) {
                    appFile = (File)appFiles.elementAt(i);
                    entry = appFile.getPath();
                    entry = entry.substring(appsWorkDir.getPath().length() + 1);
                    if (temp.get(entry = entry.replace(File.separatorChar, '/')) != null) {
                        try {
                            byte[] crc = HashUtils.generateFileHash((File)appFile);
                            byte[] dbCrc = (byte[])libsCRC.get(entry);
                            if (dbCrc != null && !HashUtils.compareHash((byte[])crc, (byte[])dbCrc)) {
                                this.communicator.logInfo("Changed internal library " + appFile.getPath() + " will be updated.");
                                this.downloadFile(config.getFile(entry), appFile);
                            }
                            temp.remove(entry);
                        }
                        catch (IOException ioex) {
                            throw new ServerDeploymentException("deploy_5039", new String[]{this.getModuleID(), this.getTransactionType()}, ioex);
                        }
                    } else {
                        this.communicator.logInfo("Old internal library " + appFile.getPath() + " will be removed.");
                        appFile.delete();
                    }
                    ++i;
                }
            }
            Enumeration newLibs = temp.keys();
            String newLibName = null;
            while (newLibs.hasMoreElements()) {
                newLibName = (String)newLibs.nextElement();
                this.communicator.logInfo("New internal library " + this.communicator.getAppsWorkDir() + this.getModuleID() + File.separator + newLibName.replace('/', File.separatorChar) + " will be downloaded.");
                this.downloadFile(config.getFile(newLibName), new File(this.communicator.getAppsWorkDir() + this.getModuleID() + File.separator + newLibName.replace('/', File.separatorChar)));
            }
        }
    }

    private void listRecursivelyDir(File dir, Vector res) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.listRecursivelyDir(files[i], res);
                } else {
                    res.add(files[i]);
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFile(InputStream is, File file) throws DeploymentException {
        block12: {
            file.getParentFile().mkdirs();
            byte[] buffer = new byte[1024];
            int count = 0;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    while ((count = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, count);
                    }
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("deploy_5103", new String[]{"downloading " + file.getAbsolutePath()}, ioex);
                }
                Object var8_6 = null;
                if (fos == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioex) {
                        throw new ServerDeploymentException("deploy_5103", new String[]{"closing " + fos}, ioex);
                    }
                }
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("deploy_5103", new String[]{"closing " + is}, ioex);
                }
            }
            try {}
            catch (IOException ioex) {
                throw new ServerDeploymentException("deploy_5103", new String[]{"closing " + fos}, ioex);
            }
            fos.close();
        }
        if (is == null) return;
        try {}
        catch (IOException ioex) {
            throw new ServerDeploymentException("deploy_5103", new String[]{"closing " + is}, ioex);
        }
        is.close();
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare " + this.getTransactionType() + " of application " + this.getModuleID());
        this.prepareCommon();
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.prepareCommon();
    }

    private void prepareCommon() throws DeploymentException {
        if (!this.okInit) {
            return;
        }
        DeploymentInfo info = null;
        info = this.communicator.getApplicationInfo(this.getModuleID());
        String[] contNames = info.getContainerNames();
        ArrayList<ContainerInterface> tempContsList = new ArrayList<ContainerInterface>();
        ContainerInterface cont = null;
        int i = 0;
        while (i < contNames.length) {
            cont = this.communicator.getContainer(contNames[i]);
            if (cont == null) {
                if (!info.isOptionalContainer(contNames[i])) {
                    throw new ServerDeploymentException("deploy_5006", new String[]{contNames[i], this.getTransactionType(), this.getModuleID()});
                }
                this.addWarning("Optional container " + contNames[i] + " is not active at the moment.");
            } else {
                tempContsList.add(cont);
            }
            ++i;
        }
        ContainerInterface[] tempConts = new ContainerInterface[tempContsList.size()];
        tempContsList.toArray(tempConts);
        this.sortContainersDec(tempConts);
        Properties props = info.getProperties();
        if (this.properties != null) {
            if (props != null) {
                Enumeration keys = ((Hashtable)this.properties).keys();
                String key = null;
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    ((Hashtable)props).put(key, this.properties.getProperty(key));
                }
            } else {
                info.setProperties(this.properties);
            }
        } else if (props.getProperty("debug", "false").equals("true")) {
            props.setProperty("debug", "false");
        }
        this.communicator.bindLoader(this, this.getModuleID(), info);
        int i2 = 0;
        while (i2 < tempConts.length) {
            block21: {
                Object var15_12;
                try {
                    try {
                        tempConts[i2].prepareStart(this.getModuleID(), this.config);
                    }
                    catch (WarningException wex) {
                        this.addWarnings(wex.getWarnings());
                        var15_12 = null;
                        this.addContainer(tempConts[i2], null);
                        break block21;
                    }
                    catch (DeploymentException de) {
                        throw de;
                    }
                    catch (OutOfMemoryError oofmer) {
                        throw oofmer;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable th) {
                        throw new ServerDeploymentException("deploy_5082", new String[]{"preparing start of application " + this.getModuleID()}, th);
                    }
                    var15_12 = null;
                    this.addContainer(tempConts[i2], null);
                }
                catch (Throwable throwable) {
                    var15_12 = null;
                    this.addContainer(tempConts[i2], null);
                    throw throwable;
                }
            }
            ++i2;
        }
        if (this.containers == null) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    public void commit() {
        this.communicator.trace(200, "Commit " + this.getTransactionType() + " of application " + this.getModuleID());
        this.commonCommit(false);
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local" + this.getTransactionType() + " of application " + this.getModuleID());
        this.commonCommit(true);
    }

    private void commonCommit(boolean isLocal) {
        if (!this.okInit) {
            return;
        }
        try {
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].commitStart(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing start of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
            try {
                if (this.getHandler() != null) {
                    this.commitHandler();
                }
            }
            catch (ConfigurationException cex) {
                new ServerDeploymentException("deploy_5082", new String[]{(isLocal ? "local " : "") + "commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
            }
            Object var9_9 = null;
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)1);
            this.communicator.getReferenceResolver().resourceAvailable(Resource.createResource((byte)1, this.getModuleID()));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)1);
            this.communicator.getReferenceResolver().resourceAvailable(Resource.createResource((byte)1, this.getModuleID()));
            throw throwable;
        }
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        if (!this.okInit) {
            return;
        }
        this.communicator.trace(200, "Rollback " + this.getTransactionType() + " of application " + this.getModuleID());
        if (this.initialState == 6) {
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)6);
        } else {
            this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)0);
        }
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback local" + this.getTransactionType() + " of application " + this.getModuleID());
        this.rollback();
    }

    public void rollbackPrepare() {
        if (!this.okInit) {
            return;
        }
        this.communicator.trace(200, "Rollback prepare " + this.getTransactionType() + " of application " + this.getModuleID());
        this.communicator.setLocalApplicationStatus(this.getModuleID(), (byte)0);
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].rollbackStart(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking start of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
        }
        try {
            this.communicator.removeApplicationLoader(this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.rollback();
    }

    public void rollbackPrepareLocal() {
        this.communicator.trace(200, "Rollback prepare local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.rollbackPrepare();
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    protected void setStatusInDB() {
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        if (info.getStatus() == 1 || info.getStatus() == 6) {
            this.saveStatus((byte)1);
            return;
        }
        if (this.remoteStatistics != null) {
            int i = 0;
            while (i < this.remoteStatistics.length) {
                if (this.remoteStatistics[i] != null && this.remoteStatistics[i].isOkResult()) {
                    this.saveStatus((byte)1);
                    return;
                }
                ++i;
            }
        }
        this.saveStatus((byte)0);
    }
}

