/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.DirResource;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.load.res.MultipleResource;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SingleFileUpdateTransaction
extends ApplicationTransaction {
    private Configuration config = null;
    private FileUpdateInfo[] updateInfoes = null;
    private boolean implicitStopped = false;
    private Properties props = null;
    private String dir = null;

    public SingleFileUpdateTransaction(TransactionCommunicator communicator, String appName, FileUpdateInfo[] updateInfoes, Properties props) throws DeploymentException {
        this.setModuleID(appName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)0);
        this.setTransactionType("singleFileUpdate");
        this.updateInfoes = updateInfoes;
        this.props = props;
        this.checkFileUpdateInfoes(updateInfoes);
    }

    private void checkFileUpdateInfoes(FileUpdateInfo[] updateInfoes) throws DeploymentException {
        if (updateInfoes == null || updateInfoes.length == 0) {
            throw new ServerDeploymentException("deploy_5024", new String[]{this.getTransactionType(), ""});
        }
        int i = 0;
        while (i < updateInfoes.length) {
            if (updateInfoes[i] == null) {
                throw new ServerDeploymentException("deploy_5053", new String[]{this.getTransactionType(), this.getModuleID(), ""});
            }
            if (updateInfoes[i].getArchiveEntryName() == null) {
                throw new ServerDeploymentException("deploy_5053", new String[]{this.getTransactionType(), this.getModuleID(), "Not specified archive entry name in FileUpdateInfo"});
            }
            if (updateInfoes[i].getContainerName() == null) {
                throw new ServerDeploymentException("deploy_5053", new String[]{this.getTransactionType(), this.getModuleID(), "Not specified container name in FileUpdateInfo"});
            }
            if (updateInfoes[i].getFileName() == null || !new File(updateInfoes[i].getFileName()).exists()) {
                throw new ServerDeploymentException("deploy_5053", new String[]{this.getTransactionType(), this.getModuleID(), "File " + updateInfoes[i].getFileName() + " which is specified in FileUpdateInfo doesn't exist."});
            }
            ++i;
        }
    }

    public SingleFileUpdateTransaction(TransactionCommunicator communicator, String appName, String[] containerNames) throws DeploymentException {
        this.setModuleID(appName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)0);
        this.setTransactionType("singleFileUpdate");
        ContainerInterface ci = null;
        if (containerNames == null || containerNames.length == 0) {
            throw new ServerDeploymentException("deploy_5040", new String[]{String.valueOf(this.clusterID), this.getTransactionType(), this.getModuleID()});
        }
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), communicator.getClusterIDName(), "make single file update"});
        }
        int i = 0;
        while (i < containerNames.length) {
            ci = communicator.getContainer(containerNames[i]);
            if (ci == null) {
                if (!info.isOptionalContainer(containerNames[i])) {
                    throw new ServerDeploymentException("deploy_5006", new String[]{containerNames[i], this.getTransactionType(), this.getModuleID()});
                }
                this.addWarning("Optional container " + containerNames[i] + " is not active at the moment.");
            } else {
                if (!ci.getContainerInfo().isSupportingSingleFileUpdate()) {
                    throw new ServerDeploymentException("deploy_5054", new String[]{containerNames[i], this.getTransactionType()});
                }
                this.addContainer(ci, null);
            }
            ++i;
        }
        if (this.containers == null || this.containers.length == 0) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    /*
     * Unable to fully structure code
     */
    public void begin() throws DeploymentException {
        this.openHandler();
        this.config = this.openApplicationConfiguration("apps", 1);
        containerInfo = new ContainerDeploymentInfo();
        containerInfo.setApplicationName(this.getModuleID());
        containerInfo.setConfiguration(this.config);
        containerInfo.setConfigurationHandler(this.getHandler());
        contFUInfoes = this.getDistribution();
        conts = contFUInfoes.keys();
        containerName = null;
        ci = null;
        cis = new ContainerInterface[contFUInfoes.size()];
        k = 0;
        info = this.communicator.getApplicationInfo(this.getModuleID());
        if (info != null || (info = this.readDeploymentInfoFromDB()) != null) ** GOTO lbl21
        throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), this.communicator.getClusterIDName(), "make single file update"});
lbl-1000:
        // 1 sources

        {
            containerName = (String)conts.nextElement();
            ci = this.communicator.getContainer(containerName);
            if (ci == null) {
                throw new ServerDeploymentException("deploy_5006", new String[]{containerName, this.getTransactionType(), this.getModuleID()});
            }
            cis[k++] = ci;
lbl21:
            // 2 sources

            ** while (conts.hasMoreElements())
        }
lbl22:
        // 1 sources

        if (info != null && info.getStatus() == 1) {
            i = 0;
            while (i < cis.length) {
                block35: {
                    ci = cis[i];
                    try {
                        if (!ci.needStopOnSingleFileUpdate((FileUpdateInfo[])contFUInfoes.get(ci.getContainerInfo().getName()), containerInfo, this.props)) break block35;
                        this.childTransaction = new StopTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null), false);
                        this.childTransaction.setUnregister(false);
                        try {
                            this.communicator.trace(200, "Waiting for application " + this.getModuleID() + " to stop.");
                            this.communicator.registerTransactionWithoutLock(this.childTransaction);
                            ((ParallelAdapter)this.childTransaction).makeAllPhasesAndWait();
                            var11_16 = null;
                            if (this.childTransaction.getCurrentStatistics() != null) {
                                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                            }
                            this.childTransaction = null;
                            this.communicator.registerTransactionWithoutLock(this);
                        }
                        catch (Throwable var10_12) {
                            var11_17 = null;
                            if (this.childTransaction.getCurrentStatistics() != null) {
                                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                            }
                            this.childTransaction = null;
                            this.communicator.registerTransactionWithoutLock(this);
                            throw var10_12;
                        }
                        this.implicitStopped = true;
                        break;
                    }
                    catch (WarningException wex) {
                        this.addWarnings(wex.getWarnings());
                    }
                    catch (DeploymentException de) {
                        throw de;
                    }
                    catch (OutOfMemoryError oofmer) {
                        throw oofmer;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable th) {
                        throw new ServerDeploymentException("deploy_5082", new String[]{"checking if application " + this.getModuleID() + " needs stop on single file update"}, th);
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < cis.length) {
                try {
                    cis[i].downloadApplicationFiles(this.getModuleID(), this.config);
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (DeploymentException de) {
                    throw de;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    throw new ServerDeploymentException("deploy_5082", new String[]{"downloading files of application " + this.getModuleID()}, th);
                }
                ++i;
            }
        }
        classpath = null;
        i = 0;
        while (i < cis.length) {
            ci = cis[i];
            try {
                classpath = DUtils.concatArrays(classpath, ci.getResourcesForTempLoader(this.getModuleID()));
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"getting resources for temp loader of application " + this.getModuleID()}, th);
            }
            ++i;
        }
        loader = this.defineLoader(info, classpath);
        containerInfo.setLoader((ClassLoader)loader);
        i = 0;
        while (i < cis.length) {
            ci = cis[i];
            this.addContainer(ci, null);
            try {
                ci.makeSingleFileUpdate((FileUpdateInfo[])contFUInfoes.get(ci.getContainerInfo().getName()), containerInfo, this.props);
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"making single file update of application " + this.getModuleID()}, th);
            }
            ++i;
        }
        this.removeLoader(loader, info);
        FileUtils.deleteDirectory((File)new File(this.dir));
        if (this.containers == null || this.containers.length == 0) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
    }

    private ResourceLoader defineLoader(DeploymentInfo info, String[] classpath) throws DeploymentException {
        try {
            LoadContext loadContext = this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext();
            String loaderName = "Update:" + this.getModuleID();
            ClassLoader loader1 = loadContext.getClassLoader(loaderName);
            if (loader1 != null && loader1 instanceof ReferencedLoader) {
                loadContext.unregister((ReferencedLoader)loader1);
                ((ReferencedLoader)loader1).prepareForRemove();
            }
            if (classpath == null) {
                classpath = new String[]{};
            }
            Resource[] resources = new Resource[classpath.length + 1];
            resources[0] = new DirResource(this.copyUpdatedFiles());
            File file = null;
            int i = 0;
            while (i < classpath.length) {
                file = new File(classpath[i]);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        resources[i + 1] = new DirResource(classpath[i], true);
                    } else {
                        resources[i + 1] = new JarResource(classpath[i], true);
                        ((JarResource)resources[i + 1]).useTimeoutClose();
                    }
                } else {
                    throw new ServerDeploymentException("Resource " + classpath[i] + " doesn't exist!");
                }
                ++i;
            }
            MultipleResource resource = new MultipleResource(resources);
            ResourceLoader loader = new ResourceLoader(loaderName, (Resource)resource, DeployServiceImpl.frameLoader, null);
            loadContext.register((ReferencedLoader)loader);
            this.communicator.makeApplicationStandartReferences(loaderName);
            ReferenceObject[] appRefs = info.getReferences();
            DeploymentInfo temp = null;
            if (appRefs != null) {
                int i2 = 0;
                while (i2 < appRefs.length) {
                    if ("application".equals(appRefs[i2].getReferenceTargetType())) {
                        temp = this.communicator.getApplicationInfo(appRefs[i2].toString());
                        if (temp != null) {
                            loadContext.registerReference(loaderName, temp.getLoaderName() != null ? temp.getLoaderName() : temp.getApplicationName());
                        }
                    } else {
                        loadContext.registerReference(loaderName, appRefs[i2].toString());
                    }
                    ++i2;
                }
            }
            return loader;
        }
        catch (Exception e) {
            throw new ServerDeploymentException("Could not create application loader and bind application in naming." + e.getMessage());
        }
    }

    private String copyUpdatedFiles() throws DeploymentException {
        this.dir = this.communicator.getApplicationServiceContext().getServiceState().getWorkingDirectoryName() + File.separator + this.getModuleID().replace('/', File.separatorChar);
        File root = new File(this.dir);
        root.mkdirs();
        File file = null;
        int i = 0;
        while (i < this.updateInfoes.length) {
            if (this.updateInfoes[i].getFileEntryName() != null && this.updateInfoes[i].getFileName() != null && new File(this.updateInfoes[i].getFileName()).exists() && !(file = new File(this.dir + File.separator + this.updateInfoes[i].getFileEntryName().replace('/', File.separatorChar))).isDirectory()) {
                try {
                    FileUtils.copyFile((File)new File(this.updateInfoes[i].getFileName()), (File)file);
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("Cannot copy file " + new File(this.updateInfoes[i].getFileName()).getPath() + " in " + file.getPath());
                }
            }
            ++i;
        }
        return this.dir;
    }

    private void removeLoader(ResourceLoader loader, DeploymentInfo info) throws DeploymentException {
        try {
            LoadContext loadContext = this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext();
            loadContext.unregister((ReferencedLoader)loader);
            loader.prepareForRemove();
            String loaderName = loader.getName();
            this.communicator.removeApplicationStandartReferences(loaderName);
            ReferenceObject[] appRefs = info.getReferences();
            DeploymentInfo temp = null;
            if (appRefs != null) {
                int i = 0;
                while (i < appRefs.length) {
                    if ("application".equals(appRefs[i].getReferenceTargetType())) {
                        temp = this.communicator.getApplicationInfo(appRefs[i].toString());
                        if (temp != null) {
                            loadContext.unregisterReference(loaderName, temp.getLoaderName() != null ? temp.getLoaderName() : temp.getApplicationName());
                        }
                    } else {
                        loadContext.unregisterReference(loaderName, appRefs[i].toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ServerDeploymentException("Could not remove application loader and bind application in naming." + e.getMessage());
        }
    }

    private Hashtable getDistribution() {
        Hashtable<String, FileUpdateInfo[]> res = new Hashtable<String, FileUpdateInfo[]>();
        String contName = null;
        int i = 0;
        while (i < this.updateInfoes.length) {
            contName = this.updateInfoes[i].getContainerName();
            if (contName != null) {
                res.put(contName, this.addUpdateInfo((FileUpdateInfo[])res.get(contName), this.updateInfoes[i]));
            }
            ++i;
        }
        return res;
    }

    private FileUpdateInfo[] addUpdateInfo(FileUpdateInfo[] all, FileUpdateInfo info) {
        if (all == null) {
            return new FileUpdateInfo[]{info};
        }
        FileUpdateInfo[] res = new FileUpdateInfo[all.length + 1];
        System.arraycopy(all, 0, res, 0, all.length);
        res[all.length] = info;
        return res;
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local phase of operation " + this.getTransactionType());
        this.openHandler();
        try {
            this.config = this.openApplicationConfiguration("apps", 0);
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].notifySingleFileUpdate(this.getModuleID(), this.config, null);
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"notifying single file update of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
            this.communicator.getApplicationInfo(this.getModuleID(), true, false, this.config, this.openApplicationConfiguration("deploy", 0));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                this.commitHandler();
            }
            catch (ConfigurationException ce) {
                throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, ce);
            }
            throw throwable;
        }
        try {
            this.commitHandler();
        }
        catch (ConfigurationException ce) {
            throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, ce);
        }
    }

    public void prepare() throws DeploymentException {
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].prepareSingleFileUpdate(this.getModuleID());
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"preparing single file update of application " + this.getModuleID()}, th);
            }
            ++i;
        }
    }

    public void prepareLocal() throws DeploymentException {
    }

    public void commit() {
        ApplicationDeployInfo info = null;
        String[] addedToClasspath = null;
        int i = 0;
        while (i < this.containers.length) {
            try {
                info = this.containers[i].commitSingleFileUpdate(this.getModuleID());
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing single file update of application " + this.getModuleID()}, th);
                sdex.log();
            }
            if (info != null) {
                addedToClasspath = DUtils.concatArrays(addedToClasspath, info.getFilesForClassloader());
            }
            ++i;
        }
        DeploymentInfo deployment = this.communicator.getApplicationInfo(this.getModuleID());
        if (deployment != null && addedToClasspath != null) {
            deployment.setContainerFilesForClassLoader(DUtils.concatArrays(addedToClasspath, deployment.getContainerFilesForClassLoader()));
            try {
                addedToClasspath = this.getCLFilesForDB(addedToClasspath);
                String[] stored = null;
                try {
                    stored = (String[])DUtils.getDeserializedObject(this.config, "STR[]:AppLoaderFilePaths");
                }
                catch (ConfigurationException cex1) {
                    new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex1.toString()}, cex1).log();
                }
                DUtils.setSerializedObject(this.config, "STR[]:AppLoaderFilePaths", DUtils.concatArrays(addedToClasspath, stored), "of class loader files of container.");
            }
            catch (ServerDeploymentException sde) {
                sde.log();
            }
            catch (ConfigurationException cex) {
                new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
            }
        }
        try {
            this.commitHandler();
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].rollbackSingleFileUpdate(this.getModuleID(), this.config);
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking single file update of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
        }
        try {
            this.rollbackHandler();
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
    }

    public void rollbackLocal() {
    }

    public void rollbackPrepare() {
        this.rollback();
    }

    public void rollbackPrepareLocal() {
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    public boolean needStartApplicationAfterFinished() {
        return this.implicitStopped;
    }

    private String[] getCLFilesForDB(String[] clFiles) {
        String[] res = new String[clFiles.length];
        int i = 0;
        while (i < clFiles.length) {
            if (clFiles[i].startsWith(this.communicator.getAppsWorkDir())) {
                res[i] = clFiles[i].substring(this.communicator.getAppsWorkDir().length());
            } else {
                this.communicator.logError("Not correct file path " + clFiles[i] + " for classpath of ApplicationClassloader returned by container!");
            }
            ++i;
        }
        return res;
    }
}

