/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StartTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.File;

public class RuntimeTransaction
extends ApplicationTransaction {
    private boolean needRestart = false;
    private Configuration appConfig = null;

    public RuntimeTransaction(String applicationName, TransactionCommunicator communicator, String containerName) throws DeploymentException {
        this(applicationName, communicator, containerName, null, null, false);
    }

    public RuntimeTransaction(String applicationName, TransactionCommunicator communicator, String containerName, ConfigurationHandler handler, Configuration appConfig, boolean needRestartApplication) throws DeploymentException {
        this.needRestart = needRestartApplication;
        if (applicationName == null) {
            throw new ServerDeploymentException("deploy_5012", new String[]{"", "runtimeChanges"});
        }
        this.setHandler(handler);
        this.appConfig = appConfig;
        this.setModuleID(applicationName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)1);
        this.setTransactionType("runtimeChanges");
        if (containerName == null) {
            throw new ServerDeploymentException("deploy_5052", new String[]{this.getTransactionType(), this.getModuleID()});
        }
        ContainerInterface ci = communicator.getContainer(containerName);
        if (ci == null) {
            throw new ServerDeploymentException("deploy_5006", new String[]{containerName, this.getTransactionType(), this.getModuleID()});
        }
        this.addContainer(ci, null);
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Begin phase of operation " + this.getTransactionType());
        DeploymentInfo deployment = this.communicator.getApplicationInfo(this.getModuleID());
        if (this.needRestart) {
            if (this.getModuleID() != null && deployment.getStatus() != 0 && deployment.getStatus() != 6) {
                this.childTransaction = new StopTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null), false);
                this.childTransaction.setUnregister(false);
                this.communicator.trace(200, "Waiting for application " + this.getModuleID() + " to stop.");
                this.communicator.registerTransactionWithoutLock(this.childTransaction);
                ((ParallelAdapter)this.childTransaction).makeAllPhasesAndWait();
                if (this.childTransaction.getCurrentStatistics() != null) {
                    this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                    this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                }
                this.childTransaction = null;
                this.communicator.registerTransactionWithoutLock(this);
                this.childTransaction = null;
            } else {
                this.needRestart = false;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void beginLocal() throws DeploymentException {
        block14: {
            this.communicator.trace(200, "Begin local phase of operation " + this.getTransactionType());
            this.openHandler();
            if (this.appConfig == null) {
                this.appConfig = this.openApplicationConfiguration("apps", 0);
            }
            if (this.getHandler() != null) {
                DeploymentInfo deployInfoDB = this.communicator.getApplicationInfo(this.getModuleID(), true, false, this.appConfig, this.openApplicationConfiguration("deploy", 0));
                DeploymentInfo deployInfo = this.communicator.getApplicationInfo(this.getModuleID());
                deployInfo.setDeployedComponents(deployInfoDB.getDeployedComponents());
                deployInfo.setContainerFilesForClassLoader(deployInfoDB.getContainerFilesForClassLoader());
            }
            this.containers[0].notifyRuntimeChanges(this.getModuleID(), this.appConfig);
            Object var7_5 = null;
            try {
                this.commitHandler();
            }
            catch (ConfigurationException e) {
                new ServerDeploymentException("deploy_5082", new String[]{"local begin phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
            }
            break block14;
            {
                catch (WarningException ce) {
                    this.addWarnings(ce.getWarnings());
                    Object var7_6 = null;
                    try {
                        this.commitHandler();
                    }
                    catch (ConfigurationException e) {
                        new ServerDeploymentException("deploy_5082", new String[]{"local begin phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
                    }
                    break block14;
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"notifying runtime changes of application " + this.getModuleID()}, th);
                    sdex.log();
                    Object var7_7 = null;
                    try {
                        this.commitHandler();
                    }
                    catch (ConfigurationException e) {
                        new ServerDeploymentException("deploy_5082", new String[]{"local begin phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    this.commitHandler();
                }
                catch (ConfigurationException e) {
                    new ServerDeploymentException("deploy_5082", new String[]{"local begin phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
                }
                throw throwable;
            }
        }
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare phase of operation " + this.getTransactionType());
        if (this.containers == null) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
        try {
            this.containers[0].prepareRuntimeChanges(this.getModuleID());
        }
        catch (WarningException dex) {
            this.addWarnings(dex.getWarnings());
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (OutOfMemoryError oofmer) {
            throw oofmer;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            throw new ServerDeploymentException("deploy_5082", new String[]{"preparing runtime changes of application " + this.getModuleID()}, th);
        }
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local phase of operation " + this.getTransactionType());
    }

    public void commit() {
        this.communicator.trace(200, "Commit phase of operation " + this.getTransactionType());
        ApplicationDeployInfo appInfo = null;
        try {
            appInfo = this.containers[0].commitRuntimeChanges(this.getModuleID());
        }
        catch (WarningException wex) {
            this.addWarnings(wex.getWarnings());
        }
        catch (OutOfMemoryError oofme) {
            throw oofme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing runtime changes of application " + this.getModuleID()}, th);
            sdex.log();
        }
        if (appInfo != null) {
            Object[] oldDeployedComponents;
            DeploymentInfo deployInfo = this.communicator.getApplicationInfo(this.getModuleID());
            Object[] newDeployedComponents = appInfo.getDeployedComponentNames();
            if (!EqualUtils.equalUnOrderedArrays((Object[])newDeployedComponents, (Object[])(oldDeployedComponents = deployInfo.getDeployedComponents(this.containers[0].getContainerInfo().getName())))) {
                deployInfo.addDeployedComponents(this.containers[0].getContainerInfo().getName(), (String[])newDeployedComponents);
                try {
                    DUtils.setSerializedObject(this.appConfig, "HASH_STR_STR[]:Cont_CompNames", deployInfo.getDeployedComponents(), "of deployed components.");
                }
                catch (ServerDeploymentException sde) {
                    sde.log();
                }
                catch (ConfigurationException ce) {
                    new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + ce.toString()}, ce).log();
                }
            }
            Object[] newFilesForClassloader = this.makeRelative(appInfo.getFilesForClassloader());
            Object[] oldFilesForClassloader = this.makeRelative(deployInfo.getContainerFilesForClassLoader());
            if (!EqualUtils.equalUnOrderedArrays((Object[])(newFilesForClassloader = DUtils.concatArrays((String[])newFilesForClassloader, (String[])oldFilesForClassloader)), (Object[])oldFilesForClassloader)) {
                try {
                    DUtils.setSerializedObject(this.appConfig, "STR[]:AppLoaderFilePaths", newFilesForClassloader, "of class loader files of container.");
                    deployInfo.setContainerFilesForClassLoader(DUtils.getRealPaths(this.communicator.getAppsWorkDir(), (String[])newFilesForClassloader));
                }
                catch (ServerDeploymentException sde) {
                    sde.log();
                }
                catch (ConfigurationException ce) {
                    new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + ce.toString()}, ce).log();
                }
            }
        }
        try {
            if (this.getHandler() != null) {
                this.setWriteAccess(true);
                this.commitHandler();
            }
        }
        catch (ConfigurationException rex) {
            new ServerDeploymentException("deploy_5082", new String[]{"commit phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + rex.toString()}, rex).log();
        }
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local phase of operation " + this.getTransactionType());
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        this.communicator.trace(200, "Rollback phase of operation " + this.getTransactionType());
        try {
            this.containers[0].rollbackRuntimeChanges(this.getModuleID());
        }
        catch (WarningException wex) {
            this.addWarnings(wex.getWarnings());
        }
        catch (OutOfMemoryError oofme) {
            throw oofme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking runtime changes of application " + this.getModuleID()}, th);
            sdex.log();
        }
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException rex) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + rex.toString()}, rex).log();
        }
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback local phase of operation " + this.getTransactionType());
    }

    public void rollbackPrepare() {
        this.communicator.trace(200, "Rollback prepare phase of operation " + this.getTransactionType());
        try {
            this.containers[0].rollbackRuntimeChanges(this.getModuleID());
        }
        catch (WarningException wex) {
            this.addWarnings(wex.getWarnings());
        }
        catch (OutOfMemoryError oofme) {
            throw oofme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking runtime changes of application " + this.getModuleID()}, th);
            sdex.log();
        }
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException rex) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback prepare phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + rex.toString()}, rex).log();
        }
    }

    public void rollbackPrepareLocal() {
        this.communicator.trace(200, "Rollback prepare local phase of operation " + this.getTransactionType());
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    protected void finalActions() throws WarningException, DeploymentException {
        block7: {
            if (this.needRestart) {
                DeploymentInfo deployment = this.communicator.getApplicationInfo(this.getModuleID());
                if (this.getModuleID() == null || deployment.getStatus() != 0 && deployment.getStatus() != 6) break block7;
                this.childTransaction = new StartTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null));
                if (!this.childTransaction.needForTransaction()) break block7;
                this.childTransaction.setUnregister(false);
                this.communicator.trace(200, "Waiting for application " + this.getModuleID() + " to start.");
                this.communicator.registerTransactionWithoutLock(this.childTransaction);
                try {
                    ((ParallelAdapter)this.childTransaction).makeAllPhasesAndWait();
                    Object var3_2 = null;
                    if (this.childTransaction.getCurrentStatistics() != null) {
                        this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                        this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                    }
                    this.childTransaction = null;
                    this.communicator.registerTransactionWithoutLock(this);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.childTransaction.getCurrentStatistics() != null) {
                        this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                        this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                    }
                    this.childTransaction = null;
                    this.communicator.registerTransactionWithoutLock(this);
                    throw throwable;
                }
            }
        }
    }

    private String[] makeRelative(String[] fNames) {
        String[] res = null;
        if (fNames != null) {
            res = new String[fNames.length];
            String apps = new File(this.communicator.getAppsWorkDir()).getName();
            apps = File.separator + apps + File.separator;
            int index = -1;
            int i = 0;
            while (i < fNames.length) {
                res[i] = fNames[i];
                if (res[i] != null) {
                    res[i] = res[i].replace('\\', File.separatorChar);
                    res[i] = res[i].replace('/', File.separatorChar);
                    res[i] = this.clearFilePath(res[i]);
                    File file = new File(res[i]);
                    if (!file.isAbsolute() && !res[i].startsWith(File.separator)) {
                        res[i] = File.separator + res[i];
                    }
                    if ((index = res[i].indexOf(apps)) != -1) {
                        res[i] = res[i].substring(index + apps.length());
                    } else if (res[i].startsWith(File.separator)) {
                        res[i] = res[i].substring(1);
                    }
                }
                ++i;
            }
        }
        return res;
    }

    private String clearFilePath(String fNames) {
        int i;
        if (fNames != null && (i = fNames.indexOf(File.separator + File.separator)) != -1) {
            fNames = fNames.substring(0, i) + this.clearFilePath(fNames.substring(i + 1));
        }
        return fNames;
    }
}

