/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.File;
import java.io.IOException;

public class RemoveTransaction
extends ApplicationTransaction {
    private Configuration config = null;

    public RemoveTransaction(String appName, TransactionCommunicator communicator, boolean onlyFlag) throws DeploymentException, ComponentNotDeployedException {
        this.init(appName, communicator);
        DeploymentInfo info = null;
        info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null) {
            throw new ComponentNotDeployedException("deploy_5005", (Object[])new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
        try {
            if (info.getStatus() == 1) {
                this.childTransaction = new StopTransaction(this.getModuleID(), communicator, false);
                if (this.childTransaction.needForTransaction()) {
                    this.childTransaction.setUnregister(false);
                    communicator.registerTransactionWithoutLock(this.childTransaction);
                    ((ParallelAdapter)this.childTransaction).makeAllPhasesLocalAndWait();
                }
                if (this.childTransaction.getCurrentStatistics() != null) {
                    this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                    this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                }
                this.childTransaction = null;
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        catch (Exception ex) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
            sdex.log();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (OutOfMemoryError oofer) {
            throw oofer;
        }
        catch (Error error) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, error);
            sdex.log();
        }
        String[] containerNames = info.getContainerNames();
        if (containerNames == null) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
            sdex.log();
        }
        ContainerInterface cont = null;
        if (containerNames != null) {
            int i = 0;
            while (i < containerNames.length) {
                cont = communicator.getContainer(containerNames[i]);
                if (cont == null) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5006", new String[]{containerNames[i], this.getTransactionType(), this.getModuleID()});
                    sdex.log();
                } else {
                    this.addContainer(cont, null);
                }
                ++i;
            }
        }
    }

    public RemoveTransaction(String moduleName, TransactionCommunicator communicator) throws DeploymentException, ComponentNotDeployedException {
        this.init(moduleName, communicator);
        DeploymentInfo deployment = communicator.getApplicationInfo(this.getModuleID());
        if (deployment == null) {
            throw new ComponentNotDeployedException("deploy_5005", (Object[])new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
    }

    private void init(String moduleName, TransactionCommunicator communicator) throws DeploymentException {
        this.setTransactionCommunicator(communicator);
        this.setModuleID(moduleName);
        this.setModuleType((byte)0);
        this.setTransactionType("removeApp");
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Begin " + this.getTransactionType() + " of application " + this.getModuleID());
        DeploymentInfo deployment = null;
        deployment = this.communicator.getApplicationInfo(this.getModuleID());
        String[] contNames = deployment.getContainerNames();
        ContainerInterface cont = null;
        if (contNames != null) {
            int i = 0;
            while (i < contNames.length) {
                cont = this.communicator.getContainer(contNames[i]);
                if (cont == null) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5006", new String[]{contNames[i], this.getTransactionType(), this.getModuleID()});
                    sdex.log();
                } else {
                    this.addContainer(cont, null);
                }
                ++i;
            }
        }
        if (this.containers == null) {
            this.containers = new ContainerInterface[0];
        }
        if (deployment.getStatus() == 1) {
            block20: {
                try {
                    block19: {
                        try {
                            this.childTransaction = new StopTransaction(this.getModuleID(), this.communicator, this.communicator.getClusterIDs(null), false);
                            if (!this.childTransaction.needForTransaction()) break block19;
                            this.childTransaction.setUnregister(false);
                            this.communicator.trace(200, "Waiting for application " + this.getModuleID() + " to stop.");
                            this.communicator.registerTransactionWithoutLock(this.childTransaction);
                            ((ParallelAdapter)this.childTransaction).makeAllPhasesAndWait();
                        }
                        catch (DeploymentException dex) {
                            dex.log();
                            Object var11_9 = null;
                            if (this.childTransaction.getCurrentStatistics() != null) {
                                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                            }
                            this.childTransaction = null;
                            this.communicator.registerTransactionWithoutLock(this);
                            break block20;
                        }
                        catch (Exception ex) {
                            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
                            sdex.log();
                            Object var11_10 = null;
                            if (this.childTransaction.getCurrentStatistics() != null) {
                                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                            }
                            this.childTransaction = null;
                            this.communicator.registerTransactionWithoutLock(this);
                            break block20;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError oofer) {
                            throw oofer;
                        }
                        catch (Error error) {
                            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, error);
                            sdex.log();
                            Object var11_11 = null;
                            if (this.childTransaction.getCurrentStatistics() != null) {
                                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                            }
                            this.childTransaction = null;
                            this.communicator.registerTransactionWithoutLock(this);
                        }
                    }
                    Object var11_8 = null;
                    if (this.childTransaction.getCurrentStatistics() != null) {
                        this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                        this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                    }
                    this.childTransaction = null;
                    this.communicator.registerTransactionWithoutLock(this);
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (this.childTransaction.getCurrentStatistics() != null) {
                        this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                        this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
                    }
                    this.childTransaction = null;
                    this.communicator.registerTransactionWithoutLock(this);
                    throw throwable;
                }
            }
            this.childTransaction = null;
        }
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local " + this.getTransactionType() + " of application " + this.getModuleID());
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                this.removeApplication(this.getModuleID(), this.containers[i]);
                ++i;
            }
        }
        String[] errors = DUtils.deleteDirectory(new File(this.communicator.getAppsWorkDir() + this.getModuleID()));
        int i = 0;
        while (i < errors.length) {
            this.communicator.logError(errors[i]);
            ++i;
        }
        this.communicator.removeApplicationInfo(this.getModuleID());
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare " + this.getTransactionType() + " of application " + this.getModuleID());
        int i = 0;
        while (i < this.containers.length) {
            this.removeApplication(this.getModuleID(), this.containers[i]);
            ++i;
        }
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        String[] jars = info.getApplicationLoaderFiles();
        ProtectionDomainFactory factory = ProtectionDomainFactory.getFactory();
        String path = null;
        if (jars != null) {
            int i2 = 0;
            while (i2 < jars.length) {
                try {
                    path = new File(jars[i2]).getCanonicalPath();
                }
                catch (IOException e) {
                    path = null;
                }
                if (path != null) {
                    factory.removeStoredProtectionDomain(jars[i2]);
                }
                ++i2;
            }
        }
        factory.removeStoredProtectionDomain(this.getModuleID());
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local " + this.getTransactionType() + " of application " + this.getModuleID());
    }

    /*
     * Loose catch block
     */
    public void commit() {
        block20: {
            block19: {
                this.communicator.trace(200, "Commit " + this.getTransactionType() + " of application " + this.getModuleID());
                File appDir = new File(this.communicator.getAppsWorkDir() + File.separator + this.getModuleID().replace('/', File.separatorChar));
                String[] errors = DUtils.deleteDirectory(appDir);
                int i = 0;
                while (i < errors.length) {
                    this.communicator.logError(errors[i]);
                    ++i;
                }
                this.communicator.removeApplicationInfo(this.getModuleID());
                this.openHandler();
                if (this.getHandler() == null) {
                    this.communicator.logInfo("Configuration manager is not available - can not open configuration.");
                } else {
                    try {
                        this.config = this.openApplicationConfiguration("apps", 1);
                    }
                    catch (DeploymentException e) {
                        e.log();
                    }
                }
                if (this.getHandler() == null || this.config == null) break block19;
                this.config.deleteConfiguration();
                Configuration deployConfig = this.openApplicationConfiguration("deploy", 1);
                deployConfig.deleteConfiguration();
            }
            Object var7_7 = null;
            try {
                if (this.getHandler() != null) {
                    this.commitHandler();
                }
                break block20;
            }
            catch (ConfigurationException ce1) {
                new ServerDeploymentException("deploy_5082", new String[]{"commiting " + this.getTransactionType() + "of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
            }
            break block20;
            {
                catch (ConfigurationException ce) {
                    new ServerDeploymentException("deploy_5082", new String[]{"commiting " + this.getTransactionType() + "of application " + this.getModuleID() + ".\nReason: " + ce.toString()}, ce).log();
                    Object var7_8 = null;
                    try {
                        if (this.getHandler() != null) {
                            this.commitHandler();
                        }
                        break block20;
                    }
                    catch (ConfigurationException ce1) {
                        new ServerDeploymentException("deploy_5082", new String[]{"commiting " + this.getTransactionType() + "of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
                    }
                    break block20;
                }
                catch (DeploymentException e) {
                    e.log();
                    Object var7_9 = null;
                    try {
                        if (this.getHandler() != null) {
                            this.commitHandler();
                        }
                        break block20;
                    }
                    catch (ConfigurationException ce1) {
                        new ServerDeploymentException("deploy_5082", new String[]{"commiting " + this.getTransactionType() + "of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (this.getHandler() != null) {
                        this.commitHandler();
                    }
                }
                catch (ConfigurationException ce1) {
                    new ServerDeploymentException("deploy_5082", new String[]{"commiting " + this.getTransactionType() + "of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
                }
                throw throwable;
            }
        }
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local " + this.getTransactionType() + " of application " + this.getModuleID());
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        this.communicator.trace(200, "Rollback " + this.getTransactionType() + " of application " + this.getModuleID());
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException ce1) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback " + this.getTransactionType() + " of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
        }
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback local " + this.getTransactionType() + " of application " + this.getModuleID());
    }

    public void rollbackPrepare() {
        this.communicator.trace(200, "Rollback prepare " + this.getTransactionType() + " of application " + this.getModuleID());
        try {
            if (this.getHandler() != null) {
                this.rollbackHandler();
            }
        }
        catch (ConfigurationException ce1) {
            new ServerDeploymentException("deploy_5082", new String[]{"rollback prepare " + this.getTransactionType() + " of application " + this.getModuleID() + ".\nReason: " + ce1.toString()}, ce1).log();
        }
    }

    public void rollbackPrepareLocal() {
        this.communicator.trace(200, "Rollback prepare local " + this.getTransactionType() + " of application " + this.getModuleID());
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    private void removeApplication(String applicationName, ContainerInterface container) {
        try {
            this.communicator.trace(200, "Start removing of application " + this.getModuleID() + " from container " + container.getContainerInfo().getName());
            container.remove(applicationName);
            this.communicator.trace(200, "Finished removing of application " + this.getModuleID() + " from container " + container.getContainerInfo().getName());
        }
        catch (DeploymentException dex) {
            dex.log();
            this.communicator.logError("Container " + container.getContainerInfo().getName() + " could not remove the components of application " + this.getModuleID());
        }
        catch (WarningException wex) {
            this.addWarnings(wex.getWarnings());
        }
        catch (Exception ex) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
            sdex.log();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (OutOfMemoryError oofmer) {
            throw oofmer;
        }
        catch (Error error) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, error);
            sdex.log();
        }
    }
}

