/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExceptionInfo;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.ReferenceResolver;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import java.util.Properties;

public abstract class ParallelAdapter
extends ApplicationTransaction
implements Runnable {
    private Object receiveMonitor = new Object();
    private int receiveMonitorCounter = 0;
    private static final byte MAKE_ALL_PHASES = 0;
    private static final byte MAKE_ALL_PHASES_LOCAL = 1;
    private static final byte MAKE_ALL_PHASES_AND_WAIT = 2;
    private static final byte MAKE_ALL_PHASES_LOCAL_AND_WAIT = 3;
    private byte make_all = 0;
    protected ReferenceResolver resolver = null;
    protected boolean sendResponse = false;
    protected int sendToClusterID;
    protected boolean wholeCluster = false;
    protected Properties properties = null;
    protected int[] initiallyInfoes = null;

    protected void init(String applicationName, TransactionCommunicator communicator, String transType) throws DeploymentException {
        this.setModuleID(applicationName);
        this.setTransactionCommunicator(communicator);
        this.resolver = communicator.getReferenceResolver();
        this.setModuleType((byte)0);
        this.setTransactionType(transType);
    }

    public void run() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            switch (this.make_all) {
                case 0: {
                    this.makeAllPhasesImpl();
                    break;
                }
                case 1: {
                    try {
                        try {
                            super.makeAllPhasesLocal();
                        }
                        catch (Throwable th) {
                            this.addError(this.getStackTraceAsString(th));
                            Object var4_3 = null;
                            if (this.sendResponse) {
                                String[] warnings = null;
                                String[] errors = null;
                                if (this.currentStatistics != null) {
                                    warnings = this.currentStatistics.getWarnings();
                                    errors = this.currentStatistics.getErrors();
                                }
                                this.remote.sendRespond(this.getModuleID(), this.sendToClusterID, warnings, errors);
                            }
                            break;
                        }
                        Object var4_2 = null;
                        if (this.sendResponse) {
                            String[] warnings = null;
                            String[] errors = null;
                            if (this.currentStatistics != null) {
                                warnings = this.currentStatistics.getWarnings();
                                errors = this.currentStatistics.getErrors();
                            }
                            this.remote.sendRespond(this.getModuleID(), this.sendToClusterID, warnings, errors);
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (this.sendResponse) {
                            String[] warnings = null;
                            String[] errors = null;
                            if (this.currentStatistics != null) {
                                warnings = this.currentStatistics.getWarnings();
                                errors = this.currentStatistics.getErrors();
                            }
                            this.remote.sendRespond(this.getModuleID(), this.sendToClusterID, warnings, errors);
                        }
                        throw throwable;
                    }
                }
            }
            Object var8_13 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
    }

    public void runInTheSameThread() throws DeploymentException {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                switch (this.make_all) {
                    case 2: {
                        this.makeAllPhasesImpl();
                        this.sleepClientThread();
                        break;
                    }
                    case 3: {
                        super.makeAllPhasesLocal();
                    }
                }
            }
            catch (DeploymentException dex) {
                this.addError(this.getStackTraceAsString(dex));
                throw dex;
            }
            catch (Exception ex) {
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5082", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
                this.addError(this.getStackTraceAsString(ex));
                throw dex;
            }
            catch (Error th) {
                th.printStackTrace();
                this.addError(this.getStackTraceAsString(th));
                throw th;
            }
            Object var6_2 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
    }

    public void receiveRespond(int fromClusterID, String[] warnings, String[] errors) {
        this.serverFinished(fromClusterID, true, warnings, errors);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serverFinished(int clID, boolean remote, String[] warnings, String[] errors) {
        var5_5 = this.receiveMonitor;
        synchronized (var5_5) {
            if (remote) {
                remoteStat = new TransactionStatistics(clID);
                remoteStat.setModuleName(this.getModuleID());
                remoteStat.setErrors(errors);
                remoteStat.setWarnings(warnings);
                if (this.remoteStatistics == null) {
                    this.remoteStatistics = new TransactionStatistics[]{remoteStat};
                } else {
                    temp = new TransactionStatistics[this.remoteStatistics.length + 1];
                    System.arraycopy(this.remoteStatistics, 0, temp, 0, this.remoteStatistics.length);
                    temp[this.remoteStatistics.length] = remoteStat;
                    this.remoteStatistics = temp;
                }
            }
            super.removeServerID(clID);
            --this.receiveMonitorCounter;
            if (this.getOtherServerIDs().length != 0) return;
            try {
                this.setStatusInDB();
                var9_8 = null;
                ** GOTO lbl47
            }
            catch (Throwable var8_22) {
                block26: {
                    block25: {
                        var9_9 = null;
                        try {
                            if (!this.unregister()) break block25;
                            if (!this.wholeCluster) {
                                this.setServerIDs(this.remote.getServerIDs());
                            } else if (this.initiallyInfoes != null) {
                                if (this.foundCurrent(this.initiallyInfoes)) {
                                    temp = new int[this.initiallyInfoes.length - 1];
                                    j = 0;
                                    i = 0;
                                    while (true) {
                                        if (i >= this.initiallyInfoes.length) {
                                            this.initiallyInfoes = temp;
                                            break;
                                        }
                                        if (this.initiallyInfoes[i] != this.clusterID) {
                                            temp[j++] = this.clusterID;
                                        }
                                        ++i;
                                    }
                                }
                                this.setServerIDs(this.initiallyInfoes);
                            }
                            this.communicator.unregisterTransactionWithLock(this.getModuleID());
                            break block26;
lbl47:
                            // 1 sources

                            ** try [egrp 2[TRYBLOCK] [1 : 155->309)] { 
lbl48:
                            // 1 sources

                            if (this.unregister()) {
                                if (!this.wholeCluster) {
                                    this.setServerIDs(this.remote.getServerIDs());
                                } else if (this.initiallyInfoes != null) {
                                    if (this.foundCurrent(this.initiallyInfoes)) {
                                        temp = new int[this.initiallyInfoes.length - 1];
                                        j = 0;
                                        i = 0;
                                        while (i < this.initiallyInfoes.length) {
                                            if (this.initiallyInfoes[i] != this.clusterID) {
                                                temp[j++] = this.clusterID;
                                            }
                                            ++i;
                                        }
                                        this.initiallyInfoes = temp;
                                    }
                                    this.setServerIDs(this.initiallyInfoes);
                                }
                                this.communicator.unregisterTransactionWithLock(this.getModuleID());
                            } else {
                                this.communicator.unregisterTransactionWithoutLock(this.getModuleID());
                            }
                            var14_16 = null;
                            this.receiveMonitor.notify();
                        }
lbl71:
                        // 1 sources

                        catch (Throwable var13_20) {
                            var14_17 = null;
                            this.receiveMonitor.notify();
                            throw var13_20;
                        }
                    }
                    this.communicator.unregisterTransactionWithoutLock(this.getModuleID());
                }
                var14_18 = null;
                this.receiveMonitor.notify();
                throw var8_22;
                catch (Throwable var13_21) {
                    var14_19 = null;
                    this.receiveMonitor.notify();
                    throw var13_21;
                }
            }
            return;
        }
    }

    public void makeAllPhases() throws DeploymentException {
        this.make_all = 0;
        ThreadSystem threadCtx = this.communicator.getApplicationServiceContext().getCoreContext().getThreadSystem();
        threadCtx.startThread((Runnable)this, true, true);
    }

    public void makeAllPhasesLocal() throws DeploymentException {
        this.make_all = 1;
        ThreadSystem threadCtx = this.communicator.getApplicationServiceContext().getCoreContext().getThreadSystem();
        threadCtx.startThread((Runnable)this, true, true);
    }

    public void makeAllPhasesAndWait() throws DeploymentException {
        this.make_all = (byte)2;
        this.runInTheSameThread();
    }

    public void makeAllPhasesLocalAndWait() throws DeploymentException {
        this.make_all = (byte)3;
        this.runInTheSameThread();
    }

    private void sleepClientThread() throws DeploymentException {
        long timeout = 1200000L;
        Object object = this.receiveMonitor;
        synchronized (object) {
            try {
                if (this.receiveMonitorCounter != 0) {
                    this.receiveMonitor.wait(timeout);
                }
                String allErrors = this.getAllErrors();
                if (!this.atLeastOneServerOK() && !allErrors.equals("")) {
                    throw new ServerDeploymentException("deploy_5030", new String[]{allErrors});
                }
            }
            catch (InterruptedException iex) {
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5028", new String[]{"finishing " + this.getTransactionType() + " in whole server ", this.getTransactionType(), this.getModuleID()}, iex);
                dex.log();
            }
        }
    }

    public void removeServerID(int serverID) {
        if (this.initiallyInfoes != null && this.initiallyInfoes.length > 0) {
            int i = 0;
            while (i < this.initiallyInfoes.length) {
                if (this.initiallyInfoes[i] == serverID) {
                    this.serverFinished(serverID, true, null, new String[]{"Cluster element " + serverID + " was suddenly dropped."});
                    break;
                }
                ++i;
            }
        }
    }

    protected boolean foundCurrent(int[] ids) {
        int i = 0;
        while (i < ids.length) {
            if (ids[i] == this.clusterID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getAllErrors() {
        String res = "";
        TransactionStatistics[] all = this.getStatistics();
        String[] errors = null;
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (all[i] != null && all[i].getErrors() != null) {
                    errors = all[i].getErrors();
                    int j = 0;
                    while (j < errors.length) {
                        res = res + "server ID " + all[i].getClusterID() + ":" + errors[j] + "\n";
                        ++j;
                    }
                }
                ++i;
            }
        }
        return res;
    }

    private boolean atLeastOneServerOK() {
        TransactionStatistics[] all = this.getStatistics();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (all[i] != null && all[i].isOkResult()) {
                    return true;
                }
                ++i;
            }
        } else {
            return false;
        }
        return false;
    }

    public void makeAllPhasesImpl() {
        block17: {
            try {
                this.remoteStatistics = this.remote.notifyRemotely(this, false);
            }
            catch (DeploymentException dex) {
                dex.log();
                this.currentStatistics.addErrors(new String[]{"Error occurred while opertaion " + this.getTransactionType() + " with application " + this.getModuleID() + " notifyed other cluster elements.For more information look at log file of Deploy Service."});
            }
            try {
                try {
                    this.makeAllPhasesOnOneServer();
                }
                catch (DeploymentException dex) {
                    if (!this.communicator.isMarkedForShutdown()) {
                        this.addError(this.getStackTraceAsString(dex));
                        dex.log();
                    }
                    Object var6_4 = null;
                    if (this.foundCurrent(this.getOtherServerIDs())) {
                        this.serverFinished(this.clusterID, false, null, null);
                    }
                    break block17;
                }
                catch (Exception ex) {
                    if (!this.communicator.isMarkedForShutdown()) {
                        ServerDeploymentException dex = new ServerDeploymentException("deploy_5082", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
                        dex.log();
                        this.addError(this.getStackTraceAsString(ex));
                    }
                    Object var6_5 = null;
                    if (this.foundCurrent(this.getOtherServerIDs())) {
                        this.serverFinished(this.clusterID, false, null, null);
                    }
                    break block17;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (Error th) {
                    if (!this.communicator.isMarkedForShutdown()) {
                        th.printStackTrace();
                        this.addError(this.getStackTraceAsString(th));
                    }
                    Object var6_6 = null;
                    if (this.foundCurrent(this.getOtherServerIDs())) {
                        this.serverFinished(this.clusterID, false, null, null);
                    }
                }
                Object var6_3 = null;
                if (this.foundCurrent(this.getOtherServerIDs())) {
                    this.serverFinished(this.clusterID, false, null, null);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.foundCurrent(this.getOtherServerIDs())) {
                    this.serverFinished(this.clusterID, false, null, null);
                }
                throw throwable;
            }
        }
    }

    protected abstract void setStatusInDB();

    protected void saveStatus(byte status) {
        try {
            this.openHandler();
            try {
                Configuration deployConfig = this.openApplicationConfiguration("deploy", 1);
                deployConfig.modifyConfigEntry("BYTE:AppStatus", (Object)new Byte(status), true);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.commitHandler();
                throw throwable;
            }
            this.commitHandler();
            {
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"saving status " + status + " of application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
        }
    }

    protected void saveException() {
        ExceptionInfo exceptionInfo = this.communicator.getExceptionInfo(this.getModuleID());
        if (exceptionInfo == null) {
            return;
        }
        ConfigurationHandler oldHandler = this.getHandler();
        try {
            try {
                this.openHandler();
                try {
                    Configuration serverDeployAppConfig = DUtils.getSubConfiguration(this.getHandler(), "deploy/" + this.getProviderName(), this.getComponentName(), "" + this.communicator.getClusterID());
                    DUtils.setSerializedObject(serverDeployAppConfig, "STR:ExceptionInfo", exceptionInfo.decode(), "on exception info.");
                    Object var5_5 = null;
                    this.setWriteAccess(true);
                    this.communicator.trace(200, "Save Exception: Commit handler of transaction " + this.getTransactionType());
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.setWriteAccess(true);
                    this.communicator.trace(200, "Save Exception: Commit handler of transaction " + this.getTransactionType());
                    this.commitHandler();
                    throw throwable;
                }
                this.commitHandler();
                Object var7_8 = null;
                this.setHandler(oldHandler);
            }
            catch (Throwable thr) {
                this.communicator.logThrowable((Throwable)((Object)new ServerDeploymentException("deploy_5082", new String[]{"saving exception during transaction " + this.getTransactionType() + " with application " + this.getModuleID()}, thr)));
                Object var7_9 = null;
                this.setHandler(oldHandler);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.setHandler(oldHandler);
            throw throwable;
        }
    }

    protected void deleteException() {
        if (this.communicator.getExceptionInfo(this.getModuleID()) == null) {
            return;
        }
        ConfigurationHandler oldHandler = this.getHandler();
        try {
            try {
                this.openHandler();
                try {
                    Configuration serverDeployAppConfig = DUtils.getSubConfiguration(this.getHandler(), "deploy/" + this.getProviderName(), this.getComponentName(), "" + this.communicator.getClusterID());
                    this.communicator.setExceptionInfo(this.getModuleID(), null);
                    if (serverDeployAppConfig.existsFile("STR:ExceptionInfo")) {
                        serverDeployAppConfig.deleteFile("STR:ExceptionInfo");
                    }
                    Object var4_4 = null;
                    this.setWriteAccess(true);
                    this.communicator.trace(200, "Delete Exception: Commit handler of transaction " + this.getTransactionType());
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.setWriteAccess(true);
                    this.communicator.trace(200, "Delete Exception: Commit handler of transaction " + this.getTransactionType());
                    this.commitHandler();
                    throw throwable;
                }
                this.commitHandler();
                Object var6_7 = null;
                this.setHandler(oldHandler);
            }
            catch (Throwable thr) {
                this.communicator.logThrowable((Throwable)((Object)new ServerDeploymentException("deploy_5082", new String[]{"deleting exception during transaction " + this.getTransactionType() + " with application " + this.getModuleID()}, thr)));
                Object var6_8 = null;
                this.setHandler(oldHandler);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.setHandler(oldHandler);
            throw throwable;
        }
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public void removeServerIDInitially(int serverID) {
        super.removeServerID(serverID);
    }

    public void setReceiveMonitorCounter(int counter) {
        this.receiveMonitorCounter = counter;
    }

    public int getReceiveMonitorCounter() {
        return this.receiveMonitorCounter;
    }

    public void setInitiallyInfoes(int[] iinfoes) {
        this.initiallyInfoes = iinfoes;
    }

    public int[] getInitiallyInfoes() {
        return this.initiallyInfoes;
    }
}

