/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.ApplicationLoader;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class LanguageLibTransaction
extends ApplicationTransaction {
    private File[] tempJars = null;
    private String[] newJars = new String[0];
    private String sep = File.separator;
    private ApplicationLoader loader = null;
    private String[] existingJars = new String[0];
    private String[] existingJarsReceived = new String[0];

    public LanguageLibTransaction(String appName, TransactionCommunicator com, String[] jars) throws DeploymentException {
        if (appName == null) {
            throw new ServerDeploymentException("deploy_5012", new String[]{"", "deployLangLib"});
        }
        this.init(appName, com);
        if (jars == null || jars.length == 0) {
            throw new ServerDeploymentException("deploy_5049", new String[]{this.getTransactionType(), this.getModuleID()});
        }
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        if (info == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
        }
        this.makeFiles(jars);
    }

    private void init(String appName, TransactionCommunicator com) throws DeploymentException {
        this.setTransactionCommunicator(com);
        this.setModuleID(appName);
        this.setTransactionType("deployLangLib");
        this.setModuleType((byte)0);
    }

    private void makeFiles(String[] jars) throws DeploymentException {
        Vector<File> temp = new Vector<File>();
        File file = null;
        int i = 0;
        while (i < jars.length) {
            if (jars[i] != null) {
                file = new File(jars[i]);
                if (file.exists()) {
                    temp.add(file);
                } else {
                    throw new ServerDeploymentException("deploy_5050", new String[]{file.getAbsolutePath()});
                }
            }
            ++i;
        }
        this.tempJars = new File[temp.size()];
        temp.toArray(this.tempJars);
    }

    public LanguageLibTransaction(String appName, TransactionCommunicator com, String[] jars, boolean local) throws DeploymentException {
        this.init(appName, com);
        if (jars != null) {
            this.tempJars = new File[jars.length];
            int i = 0;
            while (i < jars.length) {
                this.tempJars[i] = new File(jars[i]);
                ++i;
            }
        }
    }

    public void begin() throws DeploymentException {
        String string = "." + this.sep + "temp" + this.sep + "deploy" + this.sep + "work" + this.sep + "deployLanguageLib" + this.sep + this.getModuleID() + this.sep;
    }

    public void prepare() throws DeploymentException {
        this.registerLanLib(false);
        this.communicator.logInfo("Language libraries were deployed to application [" + this.getModuleID() + "].");
        this.communicator.logInfo("Language libraries were deployed successfully. To start using these resources, please, restart the application.");
    }

    public void commit() {
        this.loader.addResource((Resource)new JarsResource(this.newJars));
    }

    private void registerLanLib(boolean isLocal) throws DeploymentException {
        File newFile = null;
        String[] buffer = null;
        String jar = null;
        int i = 0;
        while (i < this.tempJars.length) {
            jar = "." + this.sep + "temp" + this.sep + "deploy" + this.sep + "work" + this.sep + "applications" + this.sep + this.getModuleID() + this.sep + "language_libs" + this.sep + this.tempJars[i].getName();
            newFile = new File(jar);
            if (newFile.exists()) {
                buffer = new String[this.existingJars.length + 1];
                System.arraycopy(this.existingJars, 0, buffer, 0, this.existingJars.length);
                buffer[this.existingJars.length] = jar;
                this.existingJars = buffer;
                buffer = new String[this.existingJarsReceived.length + 1];
                System.arraycopy(this.existingJarsReceived, 0, buffer, 0, this.existingJarsReceived.length);
                buffer[this.existingJarsReceived.length] = this.tempJars[i].getPath();
                this.existingJarsReceived = buffer;
                this.communicator.logWarning("Language library " + newFile.getName() + " from application [" + this.getModuleID() + "] already exists and will be replaced.");
            } else {
                buffer = new String[this.newJars.length + 1];
                System.arraycopy(this.newJars, 0, buffer, 0, this.newJars.length);
                buffer[this.newJars.length] = jar;
                this.newJars = buffer;
                try {
                    FileUtils.copyFile((File)this.tempJars[i], (File)newFile);
                }
                catch (IOException ex) {
                    throw new ServerDeploymentException("deploy_5051", new String[]{this.tempJars[i].getAbsolutePath(), newFile.getAbsolutePath()}, ex);
                }
            }
            ++i;
        }
        if (!isLocal) {
            DeploymentInfo deployment = null;
            LoadContext loadContext = this.communicator.getApplicationServiceContext().getCoreContext().getLoadContext();
            ApplicationLoader loader = (ApplicationLoader)((Object)loadContext.getClassLoader(this.getModuleID()));
            deployment = this.communicator.getApplicationInfo(this.getModuleID());
            if (deployment == null) {
                throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), String.valueOf(this.clusterID), this.getTransactionType()});
            }
            deployment.addLanguageLibs(this.newJars);
        }
        try {
            int i2 = 0;
            while (i2 < this.existingJars.length) {
                ++i2;
            }
        }
        catch (Exception ioex) {
            new ServerDeploymentException("Error occurred while trying to update allready existing language library jars for applivation: " + this.getModuleID() + "\n" + ioex.toString()).log();
        }
    }

    public void beginLocal() throws DeploymentException {
        if (this.tempJars != null) {
            int i = 0;
            while (i < this.tempJars.length) {
                if (!this.tempJars[i].exists()) {
                    throw new ServerDeploymentException("deploy_5050", new String[]{this.tempJars[i].getAbsolutePath()});
                }
                ++i;
            }
        } else {
            throw new ServerDeploymentException("deploy_5049", new String[]{this.getTransactionType(), this.getModuleID()});
        }
    }

    public void prepareLocal() throws DeploymentException {
        this.registerLanLib(false);
        this.communicator.logInfo("Language libraries were deployed to application [" + this.getModuleID() + "].");
        this.communicator.logInfo("Language libraries were deployed successfully. To start using these resources, please, restart the application.");
    }

    public void commitLocal() {
        this.loader.addResource((Resource)new JarsResource(this.newJars));
        FileUtils.deleteDirectory((File)new File("." + this.sep + "temp" + this.sep + "deploy" + this.sep + "work" + this.sep + "deployLanguageLib" + this.sep + this.getModuleID()));
    }

    public void rollback() {
    }

    public void rollbackLocal() {
        FileUtils.deleteDirectory((File)new File("." + this.sep + "temp" + this.sep + "deploy" + this.sep + "work" + this.sep + "deployLanguageLib" + this.sep + this.getModuleID()));
    }

    public void rollbackPrepare() {
    }

    public void rollbackPrepareLocal() {
        this.rollbackLocal();
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }
}

