/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.jar.EARReader;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.DeployUtilTransaction;
import com.sap.engine.services.deploy.server.application.RemoveTransaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DeploymentTransaction
extends DeployUtilTransaction {
    private boolean clearAfterFailure = true;

    public DeploymentTransaction(String appName, TransactionCommunicator communicator, Hashtable containerProps, String[] containerNames) throws DeploymentException {
        this.setModuleID(appName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)0);
        this.setTransactionType("deploy");
        this.setClearAfterFailure(this.clearAfterFailure);
        if (containerNames == null) {
            throw new ServerDeploymentException("deploy_5040", new String[]{String.valueOf(this.clusterID), this.getTransactionType(), this.getModuleID()});
        }
        ContainerInterface cont = null;
        int i = 0;
        while (i < containerNames.length) {
            cont = communicator.getContainer(containerNames[i]);
            if (cont != null) {
                this.addContainer(cont, (Properties)containerProps.get(containerNames[i]));
            }
            ++i;
        }
    }

    public DeploymentTransaction(String earFilePath, String[] remoteSupport, Properties props, TransactionCommunicator communicator, boolean clearAfterFailure) throws DeploymentException {
        this.remoteSupport = remoteSupport;
        this.props = props;
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)0);
        this.setTransactionType("deploy");
        this.setClearAfterFailure(clearAfterFailure);
        this.moduleFile = new File(earFilePath);
        try {
            this.reader = new EARReader(this.moduleFile.getAbsolutePath());
            this.reader.webServicesCheck();
            this.descr = this.reader.getEARDescriptor();
        }
        catch (IOException ioex) {
            throw new ServerDeploymentException("deploy_5041", new String[]{earFilePath}, ioex);
        }
        if (this.descr == null) {
            this.reader.clear();
            throw new ServerDeploymentException("deploy_5042", new String[]{earFilePath});
        }
        if (this.reader.getErrorMsg(true) != null && !this.reader.getErrorMsg(true).equals("")) {
            communicator.logInfo(this.reader.getErrorMsg(true));
        }
        if (this.reader.getErrorMsg(false) != null && !this.reader.getErrorMsg(false).equals("")) {
            communicator.logWarning(this.reader.getErrorMsg(false));
        }
        if (this.descr.getDisplayName() == null) {
            this.reader.clear();
            throw new ServerDeploymentException("deploy_5012", new String[]{"", this.getTransactionType()});
        }
        this.setComponentName(this.descr.getDisplayName());
        if (this.descr.getProviderName() != null) {
            this.setProviderName(this.descr.getProviderName());
        }
    }

    public DeploymentTransaction(String moduleFilePath, String containerName, String[] remoteSupport, Properties props, TransactionCommunicator communicator, boolean clearAfterFailure) throws DeploymentException {
        this.remoteSupport = remoteSupport;
        this.props = props;
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)1);
        this.setTransactionType("deploy");
        this.setClearAfterFailure(clearAfterFailure);
        this.moduleFile = new File(moduleFilePath);
        ArrayList<String> suitableContainers = new ArrayList<String>();
        if (containerName != null && communicator.getContainer(containerName) != null) {
            suitableContainers.add(containerName);
        } else {
            String contName = null;
            if (moduleFilePath.lastIndexOf(46) != -1) {
                String extension = moduleFilePath.substring(moduleFilePath.lastIndexOf(46));
                if (extension.equalsIgnoreCase(".jar")) {
                    contName = this.getContainerNameForJarFile();
                    if (contName != null) {
                        suitableContainers.add(contName);
                    }
                } else {
                    ContainerInterface cont = null;
                    Enumeration enumeration = communicator.getContainers();
                    String[] contExts = null;
                    ContainerInfo cinfo = null;
                    while (enumeration.hasMoreElements()) {
                        cont = (ContainerInterface)enumeration.nextElement();
                        cinfo = cont.getContainerInfo();
                        if (cinfo.isJ2EEContainer()) {
                            contExts = cinfo.getFileExtensions();
                            if (!this.foundString(extension, contExts)) continue;
                            suitableContainers.add(cinfo.getName());
                            continue;
                        }
                        if (!this.findInNonJ2EEContainer(extension, cinfo)) continue;
                        suitableContainers.add(cinfo.getName());
                    }
                }
            } else {
                throw new ServerDeploymentException("deploy_5044", new String[]{this.moduleFile.getName(), this.getTransactionType()});
            }
        }
        if (suitableContainers.size() == 0) {
            throw new ServerDeploymentException("deploy_5014", new String[]{this.moduleFile.getName()});
        }
        String contNames = "";
        this.singleContainers = new String[suitableContainers.size()];
        suitableContainers.toArray(this.singleContainers);
        int i = 0;
        while (i < this.singleContainers.length) {
            contNames = contNames + this.singleContainers[i] + "; ";
            ++i;
        }
        communicator.logInfo("As container name for component " + this.moduleFile.getName() + " has not been specified, deploy service used the mechanism for identifying components and found the following suitable containers: " + contNames);
        ContainerInfo info = null;
        ContainerInterface cont = communicator.getContainer(this.singleContainers[0]);
        if (cont != null) {
            info = cont.getContainerInfo();
            String module = info.isJ2EEContainer() ? info.getJ2EEModuleName() : info.getModuleName();
            String name = null;
            if (props.getProperty("application_name") != null) {
                name = props.getProperty("application_name");
                if (!name.trim().equals("")) {
                    this.setComponentName(name);
                } else {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                }
            } else {
                try {
                    name = cont.getApplicationName(this.moduleFile);
                    if (name != null && !name.trim().equals("")) {
                        this.setModuleID(name);
                    } else {
                        this.setComponentName(module + "_" + this.moduleFile.getName());
                    }
                }
                catch (DeploymentException dex) {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"getting name of application " + module + "_" + this.moduleFile.getName()}, th);
                    sdex.log();
                }
            }
            if (props.getProperty("provider_name") != null) {
                this.setProviderName(props.getProperty("provider_name"));
            }
        }
    }

    protected ContainerInterface[] findContainersHandlingFile(String fileName) {
        Enumeration enumc = this.communicator.getContainers();
        Vector<ContainerInterface> res = new Vector<ContainerInterface>();
        while (enumc.hasMoreElements()) {
            ContainerInterface ci = (ContainerInterface)enumc.nextElement();
            String[] fnames = ci.getContainerInfo().getFileNames();
            if (fnames == null) continue;
            int i = 0;
            while (i < fnames.length) {
                if (fnames[i].endsWith(fileName)) {
                    res.add(ci);
                }
                ++i;
            }
        }
        if (res.size() == 0) {
            return null;
        }
        ContainerInterface[] resci = new ContainerInterface[res.size()];
        res.toArray(resci);
        return resci;
    }

    public void begin() throws DeploymentException, ComponentNotDeployedException {
        this.communicator.trace(200, "Start deploying application [" + this.getModuleID() + "]");
        this.loader = null;
        String[] apps = this.communicator.listApplications();
        if (apps != null) {
            boolean exist = false;
            int i = 0;
            while (i < apps.length) {
                if (this.getModuleID().equals(apps[i])) {
                    exist = true;
                    this.childTransaction = new RemoveTransaction(this.getModuleID(), this.communicator);
                    this.communicator.registerTransactionWithoutLock(this.childTransaction);
                    this.childTransaction.makeAllPhases();
                    this.childTransaction = null;
                    this.communicator.registerTransactionWithoutLock(this);
                    break;
                }
                ++i;
            }
            if (!exist) {
                this.checkAndClear();
            }
        }
        this.openHandler();
        this.config = this.createApplicationConfiguration("apps");
        this.deployConfig = this.createApplicationConfiguration("deploy");
        try {
            if (this.config == null || this.deployConfig == null) {
                this.commitHandler();
            }
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, cex);
        }
        if (this.config == null || this.deployConfig == null) {
            this.openHandler();
            if (this.config == null) {
                this.config = this.createApplicationConfiguration("apps");
            }
            if (this.deployConfig == null) {
                this.deployConfig = this.createApplicationConfiguration("deploy");
            }
        }
        this.commonBegin();
        this.deployment.setStatus((byte)0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare deploying application " + this.getModuleID());
        if (this.containers == null || this.containers.length == 0) {
            throw new ServerDeploymentException("deploy_5036", new String[]{this.getModuleID(), this.getTransactionType()});
        }
        this.communicator.bindLoader(this, this.getModuleID(), this.deployment);
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].prepareDeploy(this.getModuleID(), this.config);
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"preparing deploy of application " + this.getModuleID()}, th);
            }
            ++i;
        }
        try {
            this.deployment.setDeploymentDuration(System.currentTimeMillis() - this.deployment.getDeploymentDuration());
            this.deployConfig.modifyConfigEntry("MILLISECONDS:deploymentDuration", (Object)new Long(this.deployment.getDeploymentDuration()), true);
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5048", new String[]{this.getModuleID(), this.getTransactionType()}, cex);
        }
        try {
            try {
                this.commitHandler();
            }
            catch (ConfigurationException ce) {
                this.setHandler(null);
                throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, ce);
            }
            Object var8_9 = null;
            if (this.getModuleType() == 0) {
                if (this.reader == null) return;
                this.reader.clear();
                return;
            }
            if (this.tempDirForStandAlone == null) return;
            FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.getModuleType() == 0) {
                if (this.reader == null) throw throwable;
                this.reader.clear();
                throw throwable;
            }
            if (this.tempDirForStandAlone == null) throw throwable;
            FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
            throw throwable;
        }
    }

    public void commit() {
        this.communicator.trace(200, "Commit deploying application " + this.getModuleID());
        this.communicator.addApplicationInfo(this.getModuleID(), this.deployment, false);
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].commitDeploy(this.getModuleID());
            }
            catch (WarningException e) {
                this.addWarnings(e.getWarnings());
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing deployment of application " + this.getModuleID()}, th);
                sdex.log();
            }
            ++i;
        }
        try {
            this.communicator.removeApplicationLoader(this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.communicator.unregisterReferences(this.getModuleID());
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        this.communicator.trace(200, "Rollback deploying application " + this.getModuleID());
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                try {
                    this.containers[i].rollbackDeploy(this.getModuleID());
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking deployment of application " + this.getModuleID()}, th);
                    sdex.log();
                }
                ++i;
            }
        }
        this.communicator.removeApplicationInfo(this.getModuleID());
        if (this.getHandler() != null) {
            try {
                this.rollbackHandler();
            }
            catch (ConfigurationException cex) {
                new ServerDeploymentException("deploy_5082", new String[]{"deployment rollback for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
            }
        }
        try {
            this.openHandler();
        }
        catch (DeploymentException e) {
            e.log();
        }
        if (this.getHandler() != null) {
            try {
                this.config = this.openApplicationConfiguration("apps", 1);
                if (this.config != null) {
                    this.config.deleteConfiguration();
                }
            }
            catch (ConfigurationException cex) {
                this.communicator.trace(300, "Cannot delete configuration <apps>. It might be missing.");
            }
            catch (DeploymentException dex) {
                this.communicator.trace(300, "Cannot delete configuration <apps>. It might be missing.");
            }
            try {
                this.deployConfig = this.openApplicationConfiguration("deploy", 1);
                if (this.deployConfig != null) {
                    this.deployConfig.deleteConfiguration();
                }
            }
            catch (ConfigurationException cex) {
                this.communicator.trace(300, "Cannot delete configuration <deploy>. It might be missing.");
            }
            catch (DeploymentException dex) {
                this.communicator.trace(300, "Cannot delete configuration <deploy>. It might be missing.");
            }
            try {
                this.commitHandler();
            }
            catch (ConfigurationException cex) {
                new ServerDeploymentException("deploy_5082", new String[]{"deployment rollback for application " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
            }
        }
        if (this.clearAfterFailure) {
            this.deleteDirectory(new File(this.communicator.getAppsWorkDir() + this.getModuleID()));
        }
        try {
            this.communicator.unregisterEARloader(this.loader, this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.loader = null;
        if (this.reader != null) {
            this.reader.clear();
        }
        if (this.tempDirForStandAlone != null) {
            FileUtils.deleteDirectory((File)this.tempDirForStandAlone);
        }
        if (this.moduleFile.getAbsolutePath().replace('\\', '/').indexOf("temp/deploy/work/deploying/") != -1) {
            this.moduleFile.delete();
        }
    }

    private void deleteDirectory(File file) {
        if (file == null) {
            return;
        }
        String[] errors = DUtils.deleteDirectory(file);
        int i = 0;
        while (i < errors.length) {
            this.communicator.logError(errors[i]);
            ++i;
        }
    }

    public void rollbackPrepare() {
        this.communicator.trace(200, "Rollback prepare deploying application " + this.getModuleID());
        try {
            this.communicator.removeApplicationLoader(this.getModuleID());
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        this.rollback();
    }

    public void beginLocal() throws DeploymentException {
        this.checkAndClear();
        this.communicator.trace(200, "Begin local deploying application " + this.getModuleID());
        try {
            this.openHandler();
            if (this.getHandler() == null) {
                this.communicator.logInfo("Configuration manager is not available - can not open configuration.");
            } else {
                this.config = this.openApplicationConfiguration("apps", 0);
            }
            DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID(), false, false, this.config, this.openApplicationConfiguration("deploy", 0));
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this.commitHandler();
            }
            catch (ConfigurationException e) {
                new ServerDeploymentException("deploy_5082", new String[]{"local deploying of application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
            }
            throw throwable;
        }
        try {
            this.commitHandler();
        }
        catch (ConfigurationException e) {
            new ServerDeploymentException("deploy_5082", new String[]{"local deploying of application " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
        }
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].notifyDeployedComponents(this.getModuleID(), this.contProperties[i]);
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"notifying deployment of application " + this.getModuleID()}, th);
                sdex.log();
            }
            ++i;
        }
    }

    public void prepareLocal() throws DeploymentException {
    }

    public void commitLocal() {
        this.communicator.unregisterReferences(this.getModuleID());
        this.setSuccessfullyFinished(true);
    }

    public void rollbackLocal() {
    }

    public void rollbackPrepareLocal() {
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }

    protected String[] makeComponents(File[] componentFiles, ContainerDeploymentInfo containerInfo, Properties contProps, ContainerInterface cont) throws DeploymentException {
        ApplicationDeployInfo tempInfo = null;
        Object filesForCLEntries = null;
        if (cont == null) {
            return null;
        }
        if (componentFiles != null) {
            String contName = cont.getContainerInfo().getName();
            try {
                this.communicator.trace(200, "Start deploying on container " + contName);
                tempInfo = cont.deploy(componentFiles, containerInfo, contProps);
            }
            catch (DeploymentException de) {
                this.addContainer(cont, this.props);
                throw de;
            }
            catch (Exception th) {
                this.addContainer(cont, this.props);
                throw new ServerDeploymentException("deploy_5089", new String[]{this.getModuleID(), contName}, th);
            }
            catch (OutOfMemoryError oofmer) {
                this.addContainer(cont, this.props);
                throw oofmer;
            }
            catch (ThreadDeath td) {
                this.addContainer(cont, this.props);
                throw td;
            }
            catch (Error err) {
                this.addContainer(cont, this.props);
                throw new ServerDeploymentException("deploy_5089", new String[]{this.getModuleID(), contName}, err);
            }
            return this.processApplicationDeployInfo(tempInfo, cont);
        }
        return null;
    }

    public String[] getResult() {
        return this.allComponents;
    }

    private void checkAndClear() {
        File appRootDir = new File(this.communicator.getAppsWorkDir() + this.getModuleID());
        if (appRootDir.exists() && appRootDir.isDirectory()) {
            this.deleteDirectory(appRootDir);
        }
    }

    public void setClearAfterFailure(boolean clearAfterFailure) {
        this.clearAfterFailure = clearAfterFailure;
    }

    protected Hashtable getConcernedContainers(Hashtable allContFiles, ContainerDeploymentInfo containerInfo) throws DeploymentException {
        Enumeration enumeration = allContFiles.keys();
        Hashtable<ContainerInterface, Object> contsProps = new Hashtable<ContainerInterface, Object>();
        while (enumeration.hasMoreElements()) {
            String contName = (String)enumeration.nextElement();
            contsProps.put(this.communicator.getContainer(contName), ((Hashtable)this.props).clone());
        }
        return contsProps;
    }
}

