/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.EARClassLoader;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.jar.EARReader;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.DeploymentTransaction;
import com.sap.engine.services.deploy.server.application.UpdateTransaction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public abstract class DeployUtilTransaction
extends ApplicationTransaction {
    protected DeploymentInfo deployment = null;
    protected String[] allComponents = null;
    protected Configuration config = null;
    protected Configuration deployConfig = null;
    protected EARReader reader = null;
    protected File moduleFile = null;
    protected String[] remoteSupport = null;
    protected Properties props = null;
    protected SimpleEarDescriptor descr = null;
    protected ClassLoader loader = null;
    protected String[] singleContainers = null;
    protected File tempDirForStandAlone = null;

    protected String[] processApplicationDeployInfo(ApplicationDeployInfo tempInfo, ContainerInterface cont) throws DeploymentException {
        String[] components = null;
        String[] filesForCLEntries = null;
        String contName = cont.getContainerInfo().getName();
        if (tempInfo != null) {
            components = tempInfo.getDeployedComponentNames();
        }
        if (components != null && components.length > 0) {
            this.deployment.addContainerName(contName);
        }
        if (tempInfo != null && (this instanceof DeploymentTransaction && components != null && components.length > 0 || this instanceof UpdateTransaction)) {
            String[] contFilesForCL;
            String[] supportedTypes;
            Properties resTypes;
            this.deployment.addDeployedComponents(contName, components);
            if (tempInfo.isOptionalContainer()) {
                this.deployment.addOptionalContainer(contName);
            }
            if ((resTypes = tempInfo.getDeployedResources_Types()) != null) {
                Enumeration<?> keys = resTypes.propertyNames();
                String key = null;
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    this.deployment.addDeployedComponent_ResTypes(key, new String[]{resTypes.getProperty(key)});
                }
            }
            if ((supportedTypes = cont.getContainerInfo().getResourceTypes()) != null && supportedTypes.length > 0) {
                resTypes = new Properties();
                int i = 0;
                while (i < components.length) {
                    this.deployment.addDeployedComponent_ResTypes(components[i], supportedTypes);
                    ++i;
                }
            }
            if (tempInfo.getLoaderName() != null) {
                this.deployment.setLoaderName(tempInfo.getLoaderName());
            }
            Properties resRefs = tempInfo.getResourceReferences();
            Properties refResTypes = tempInfo.getResReferenceTypes();
            if (resRefs != null) {
                Enumeration<?> resources = resRefs.propertyNames();
                String resource = null;
                while (resources.hasMoreElements()) {
                    resource = (String)resources.nextElement();
                    String type = null;
                    type = ((Hashtable)refResTypes).get(resource) != null ? refResTypes.getProperty(resource) : "weak";
                    type = type.equals("weak") ? "weak" : "hard";
                    this.deployment.addResource(DUtils.encodeResourceType(resource, resRefs.getProperty(resource), type));
                }
            }
            this.clearRemovedResourceRefs(tempInfo.getRemovedResourceReferences());
            if (tempInfo.getReferences() != null) {
                ReferenceObjectIntf[] containerRefs = tempInfo.getReferences();
                ReferenceObject temp = null;
                int i = 0;
                while (i < containerRefs.length) {
                    temp = new ReferenceObject();
                    temp.setReferenceProviderName(containerRefs[i].getReferenceProviderName());
                    temp.setReferenceTarget(containerRefs[i].getReferenceTarget());
                    temp.setReferenceTargetType(containerRefs[i].getReferenceTargetType());
                    temp.setReferenceType(containerRefs[i].getReferenceType());
                    if (this instanceof DeploymentTransaction) {
                        this.communicator.addReferenceInternally(this.getModuleID(), temp);
                    } else {
                        this.communicator.addReferenceInternally(this.deployment, temp);
                    }
                    ++i;
                }
            }
            if (components != null) {
                components = DUtils.addToElements(components, " - " + (cont.getContainerInfo().isJ2EEContainer() ? cont.getContainerInfo().getJ2EEModuleName().toUpperCase() : cont.getContainerInfo().getModuleName().toUpperCase()));
                this.allComponents = DUtils.concatArrays(this.allComponents, components);
            }
            if ((contFilesForCL = tempInfo.getFilesForClassloader()) != null && contFilesForCL.length > 0) {
                filesForCLEntries = this.getCLFilesForDB(contFilesForCL, contName);
            }
            this.addContainer(cont, tempInfo.getDeployProperties());
            this.communicator.logDebug("Container " + cont.getContainerInfo().getName() + " accepted components of the application " + this.getModuleID());
        }
        if (tempInfo != null && tempInfo.getWarnings() != null) {
            String[] w = new String[tempInfo.getWarnings().size()];
            tempInfo.getWarnings().toArray(w);
            this.addWarnings(w);
        }
        return filesForCLEntries;
    }

    private void clearRemovedResourceRefs(Properties removedResRefs) {
        if (removedResRefs != null) {
            Enumeration keys = ((Hashtable)removedResRefs).keys();
            String resName = null;
            String resType = null;
            while (keys.hasMoreElements()) {
                resName = (String)keys.nextElement();
                resType = removedResRefs.getProperty(resName);
                this.deployment.removeResource(DUtils.encodeResourceType(resName, resType, "weak"));
                this.deployment.removeResource(DUtils.encodeResourceType(resName, resType, "hard"));
            }
        }
    }

    protected void modifyDeploymentInfoInConfiguration() throws ConfigurationException, IOException, ServerDeploymentException {
        if (this.deployment.getReferences() != null) {
            DUtils.setSerializedObject(this.config, "HASH_STR_STR:Reference_type", DUtils.decodeReferenceObjectArray(this.deployment.getReferences()), "of references.");
        } else if (this.config.existsFile("HASH_STR_STR:Reference_type")) {
            this.config.deleteFile("HASH_STR_STR:Reference_type");
        }
        this.config.modifyConfigEntry("STR:ApplicationName", (Object)this.getModuleID(), true);
        this.config.modifyConfigEntry("BOOL:IsStandAloneArchive", (Object)new Boolean(this.deployment.isStandAloneArchive()), true);
        if (this.deployment.getRemoteSupport() != null) {
            this.config.modifyConfigEntry("STR[]:RemoteSupport", (Object)this.deployment.getRemoteSupport(), true);
        } else if (this.config.existsConfigEntry("STR[]:RemoteSupport")) {
            this.config.deleteConfigEntry("STR[]:RemoteSupport");
        }
        if (this instanceof DeploymentTransaction) {
            this.communicator.setLocalApplicationStatus(this.getModuleID(), this.deployment.getStatus());
            this.deployConfig.modifyConfigEntry("BYTE:AppStatus", (Object)new Byte(this.deployment.getStatus()), true);
        }
        this.deployConfig.modifyConfigEntry("BYTES:appArchiveSize", (Object)new Long(this.deployment.getAppArchiveSize()), true);
        this.deployConfig.modifyConfigEntry("TIME:timeOfLastRedeployment", (Object)this.deployment.getTimeOfLastRedeployment(), true);
        this.deployConfig.modifyConfigEntry("INT:numberOfRedeploys", (Object)new Integer(this.deployment.getNumberOfRedeploys()), true);
        this.deployConfig.modifyConfigEntry("STR:StartUp", (Object)new Integer(this.deployment.getStartUp()), true);
        this.config.modifyConfigEntry("PROPS_STR_STR:ApplicationProperties", (Object)this.deployment.getProperties(), true);
        if (this.deployment.getContainerFilesForClassLoader() != null) {
            DUtils.setSerializedObject(this.config, "STR[]:AppLoaderFilePaths", this.deployment.getContainerFilesForClassLoader(), "of class loader files of container.");
            this.deployment.setContainerFilesForClassLoader(DUtils.getRealPaths(this.communicator.getAppsWorkDir(), this.deployment.getContainerFilesForClassLoader()));
        } else if (this.config.existsFile("STR[]:AppLoaderFilePaths")) {
            this.config.deleteFile("STR[]:AppLoaderFilePaths");
        }
        if (this.deployment.getContainerNames() != null) {
            this.config.modifyConfigEntry("STR[]:ContainerNames", (Object)this.deployment.getContainerNames(), true);
        } else if (this.config.existsConfigEntry("STR[]:ContainerNames")) {
            this.config.deleteConfigEntry("STR[]:ContainerNames");
        }
        if (this.deployment.getOptionalContainers() != null) {
            this.config.modifyConfigEntry("STR[]:optionalContainers", (Object)this.deployment.getOptionalContainers(), true);
        } else if (this.config.existsConfigEntry("STR[]:optionalContainers")) {
            this.config.deleteConfigEntry("STR[]:optionalContainers");
        }
        if (this.deployment.getDeployedComponents() != null) {
            DUtils.setSerializedObject(this.config, "HASH_STR_STR[]:Cont_CompNames", this.deployment.getDeployedComponents(), "of deployed components.");
        } else if (this.config.existsFile("HASH_STR_STR[]:Cont_CompNames")) {
            this.config.deleteFile("HASH_STR_STR[]:Cont_CompNames");
        }
        if (this.deployment.getDeployedComponents_Types() != null) {
            DUtils.setSerializedObject(this.config, "HASH_STR_STR[]:Res_Types", this.deployment.getDeployedComponents_Types(), "the types of deployed resources.");
        } else if (this.config.existsFile("HASH_STR_STR[]:Res_Types")) {
            this.config.deleteFile("HASH_STR_STR[]:Res_Types");
        }
        String[] internalLibs = this.deployment.getInternalLibraries();
        if (internalLibs != null) {
            File lib = null;
            Hashtable<String, byte[]> lib_crc = new Hashtable<String, byte[]>();
            int i = 0;
            while (i < internalLibs.length) {
                lib = new File(this.communicator.getAppsWorkDir() + this.getModuleID() + File.separator + internalLibs[i].replace('/', File.separatorChar));
                this.config.updateFileByKey(internalLibs[i], lib, true);
                lib_crc.put(internalLibs[i], HashUtils.generateFileHash((File)lib));
                internalLibs[i] = this.communicator.getAppsWorkDir() + this.getModuleID() + File.separator + internalLibs[i].replace('/', File.separatorChar);
                ++i;
            }
            DUtils.setSerializedObject(this.config, "HASH_STR_BYTE[]:LibFileName_CRC", lib_crc, "of names of the internal libraries and their CRC.");
        } else if (this.config.existsFile("HASH_STR_BYTE[]:LibFileName_CRC")) {
            this.config.deleteFile("HASH_STR_BYTE[]:LibFileName_CRC");
        }
        this.deployment.setInternalLibraries(internalLibs);
        if (this.deployment.getLoaderName() != null) {
            this.config.modifyConfigEntry("STR:Loader", (Object)this.deployment.getLoaderName(), true);
        } else if (this.config.existsConfigEntry("STR:Loader")) {
            this.config.deleteConfigEntry("STR:Loader");
        }
        if (this.deployment.getAdditionalClasspath() != null) {
            this.config.modifyConfigEntry("STR:AdditionalClasspath", (Object)this.deployment.getAdditionalClasspath(), true);
        } else if (this.config.existsConfigEntry("STR:AdditionalClasspath")) {
            this.config.deleteConfigEntry("STR:AdditionalClasspath");
        }
        if (this.deployment.getResources() != null) {
            DUtils.setSerializedObject(this.config, "STR[]:EncodeResources", this.deployment.getResources(), "of encodedResources.");
        } else if (this.config.existsFile("STR[]:EncodeResources")) {
            this.config.deleteFile("STR[]:EncodeResources");
        }
        this.config.modifyConfigEntry("STR:Failover", (Object)this.deployment.getFailOverValue(), true);
        if (this.deployment.getDeployedFileNames() != null) {
            DUtils.setSerializedObject(this.config, "HASH_STR_STR[]:Cont_FileNames", this.deployment.getDeployedFileNames(), "of deployed file names.");
        } else if (this.config.existsFile("HASH_STR_STR[]:Cont_FileNames")) {
            this.config.deleteFile("HASH_STR_STR[]:Cont_FileNames");
        }
    }

    protected String[] getCLFilesForDB(String[] clFiles, String contName) throws DeploymentException {
        if (clFiles == null) {
            return null;
        }
        String[] res = new String[clFiles.length];
        File file = null;
        int i = 0;
        while (i < clFiles.length) {
            clFiles[i] = clFiles[i].replace('\\', File.separatorChar);
            clFiles[i] = clFiles[i].replace('/', File.separatorChar);
            file = new File(clFiles[i]);
            if (!file.isAbsolute()) {
                clFiles[i] = file.getAbsolutePath();
            }
            if (!clFiles[i].startsWith(this.communicator.getAppsWorkDir())) {
                if (contName != null) {
                    throw new ServerDeploymentException("deploy_5016", new String[]{clFiles[i], "container " + contName, this.communicator.getAppsWorkDir()});
                }
                throw new ServerDeploymentException("deploy_5016", new String[]{clFiles[i], "deploy service", this.communicator.getAppsWorkDir()});
            }
            res[i] = clFiles[i].substring(this.communicator.getAppsWorkDir().length());
            ++i;
        }
        return res;
    }

    protected void commonBegin() throws DeploymentException {
        this.deployment = new DeploymentInfo();
        if (this.moduleType == 0) {
            try {
                this.deployment.setInternalLibraries(this.reader.getAdditionalLibrariesEntries(this.communicator.getAppsWorkDir() + this.getModuleID()));
                this.deployment.setFailOverValue(this.reader.getDescriptor().getFailOverValue());
                this.deployment.setStartUp(this.reader.getDescriptor().getStartUp());
            }
            catch (IOException ioex) {
                throw new ServerDeploymentException("deploy_5046", new String[]{this.getModuleID(), this.getTransactionType()}, ioex);
            }
        } else {
            this.extractStandAlone();
        }
        this.deployment.setApplicationName(this.getModuleID());
        this.deployment.setAppArchiveSize(this.moduleFile.length());
        this.deployment.setTimeOfLastRedeployment(new Date(System.currentTimeMillis()).toString());
        if (this instanceof UpdateTransaction) {
            int counter = ((UpdateTransaction)this).oldDeployment.getNumberOfRedeploys();
            this.deployment.setNumberOfRedeploys(++counter);
        } else {
            this.deployment.setNumberOfRedeploys(0);
        }
        this.deployment.setDeploymentDuration(System.currentTimeMillis());
        this.deployment.setStandAloneArchive(this.moduleType == 1);
        this.deployment.setRemoteSupport(this.remoteSupport);
        if (this instanceof UpdateTransaction) {
            this.deployment.setStatus(((UpdateTransaction)this).oldDeployment.getStatus());
        } else {
            this.deployment.setStatus((byte)0);
        }
        this.deployment.setProperties(this.props);
        if (this.moduleType == 0) {
            this.deployment.setAdditionalClasspath(this.descr.getClassPath());
        }
        if (this instanceof DeploymentTransaction) {
            this.communicator.addApplicationInfo(this.getModuleID(), this.deployment, true);
        }
        this.processReferences();
        Hashtable allContFiles = null;
        if (this.moduleType == 0) {
            try {
                this.loader = new EARClassLoader(this.getModuleID(), this.moduleFile.getAbsolutePath(), this.communicator.getRootDirectory() + File.separator, this.getClass().getClassLoader());
            }
            catch (IOException ioe) {
                throw new ServerDeploymentException("deploy_5101", new String[]{this.moduleFile.getAbsolutePath()}, ioe);
            }
            this.communicator.registerEARloader(this.loader, this.deployment);
        } else {
            allContFiles = this.registerRarLoader();
        }
        this.allComponents = DUtils.concatArrays(this.allComponents, new String[]{"Application : " + this.getModuleID(), ""});
        try {
            try {
                ContainerDeploymentInfo containerInfo = new ContainerDeploymentInfo();
                if (this.moduleType == 0) {
                    ArrayList<ContainerInfo> cinfoes = new ArrayList<ContainerInfo>();
                    Enumeration conts = this.communicator.getContainers();
                    while (conts.hasMoreElements()) {
                        cinfoes.add(((ContainerInterface)conts.nextElement()).getContainerInfo());
                    }
                    ContainerInfo[] temp = new ContainerInfo[cinfoes.size()];
                    cinfoes.toArray(temp);
                    this.reader.setContainerInfoes(temp);
                    try {
                        allContFiles = this.reader.getAllContainerFiles();
                    }
                    catch (IOException ioex) {
                        throw new ServerDeploymentException("deploy_5055", new String[]{this.moduleFile.getAbsolutePath(), this.getTransactionType(), this.getModuleID()}, ioex);
                    }
                    this.fillContainerDeployInfo(containerInfo, (ClassLoader)((EARClassLoader)this.loader), allContFiles);
                    if (allContFiles == null) {
                        throw new RemoteException("No container components were recognized.");
                    }
                    this.fillAliases(allContFiles);
                } else {
                    int i = 0;
                    while (i < this.singleContainers.length) {
                        allContFiles.put(this.singleContainers[i], new File[]{this.moduleFile});
                        ++i;
                    }
                    this.fillContainerDeployInfo(containerInfo, this.loader, allContFiles);
                }
                this.deployment.setDeployedFileNames(DUtils.convertHashtable(allContFiles));
                Hashtable contsProps = this.getConcernedContainers(allContFiles, containerInfo);
                ContainerInterface[] concernedContainers = new ContainerInterface[contsProps.size()];
                Enumeration conts = contsProps.keys();
                int j = 0;
                while (conts.hasMoreElements()) {
                    concernedContainers[j++] = (ContainerInterface)conts.nextElement();
                }
                this.sortContainersDec(concernedContainers);
                if (this.config == null && this.deployConfig == null) {
                    this.config = this.openApplicationConfiguration("apps", 1);
                    this.deployConfig = this.openApplicationConfiguration("deploy", 1);
                }
                try {
                    this.uploadSpecialEARFiles();
                }
                catch (ConfigurationException cex) {
                    throw new ServerDeploymentException("deploy_5102", new String[]{this.getModuleID(), this.getTransactionType()}, cex);
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("deploy_5102", new String[]{this.getModuleID(), this.getTransactionType()}, ioex);
                }
                containerInfo.setConfigurationHandler(this.getHandler());
                containerInfo.setConfiguration(this.config);
                int i = 0;
                while (i < concernedContainers.length) {
                    String contName = concernedContainers[i].getContainerInfo().getName();
                    String[] contFilesForCL = this.makeComponents((File[])allContFiles.get(contName), containerInfo, (Properties)contsProps.get(concernedContainers[i]), concernedContainers[i]);
                    if (contFilesForCL != null) {
                        this.deployment.addContainerFilesForClassLoader(contFilesForCL);
                    }
                    ++i;
                }
                if (this.moduleFile.getAbsolutePath().replace('\\', '/').indexOf("temp/deploy/work/deploying/") != -1) {
                    this.moduleFile.delete();
                }
                this.communicator.trace(200, "Generation phase for application " + this.getModuleID() + " ended successfully.");
            }
            catch (Exception e) {
                this.communicator.logDebug("Rollback during generation, because : " + e.toString());
                throw new ServerDeploymentException("deploy_5047", new String[]{this.getModuleID()}, e);
            }
            Object var11_21 = null;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            this.communicator.unregisterEARloader(this.loader, this.getModuleID());
            this.loader = null;
            throw throwable;
        }
        this.communicator.unregisterEARloader(this.loader, this.getModuleID());
        this.loader = null;
        try {
            this.modifyDeploymentInfoInConfiguration();
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5048", new String[]{this.getModuleID(), this.getTransactionType()}, cex);
        }
        catch (IOException ioex) {
            throw new ServerDeploymentException("deploy_5048", new String[]{this.getModuleID(), this.getTransactionType()}, ioex);
        }
        this.communicator.getReferenceResolver().checkCycleReferences(this.getModuleID(), this.deployment.getReferences());
    }

    private void fillContainerDeployInfo(ContainerDeploymentInfo containerInfo, ClassLoader loader, Hashtable allContFiles) {
        containerInfo.setApplicationName(this.getModuleID());
        containerInfo.setStandAloneArchive(this.moduleType == 1);
        containerInfo.setLoader(loader);
        containerInfo.setRemoteSupportGenerators(this.remoteSupport);
        containerInfo.setConfiguration(this.config);
        containerInfo.setConfigurationHandler(this.getHandler());
        containerInfo.setFilesDistribution(allContFiles);
        Properties aliasesUris = new Properties();
        if (this.getModuleType() == 0) {
            containerInfo.setFileMappings(this.reader.getFileMappings());
            containerInfo.setEarDescriptor(this.descr);
            try {
                J2EEModule[] modules = this.reader.getEARDescriptor().getWEBs();
                if (modules != null) {
                    int i = 0;
                    while (i < modules.length) {
                        ((Hashtable)aliasesUris).put(modules[i].getContextRoot(), modules[i].getUri());
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                new ServerDeploymentException("deploy_5041", new String[]{this.getModuleID()}, e).log();
            }
        } else {
            Enumeration<?> names = this.props.propertyNames();
            String name = null;
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                if (!name.startsWith("web:")) continue;
                ((Hashtable)aliasesUris).put(name.substring("web:".length()), this.props.getProperty(name));
            }
            String moduleName = this.moduleFile.getName();
            if (moduleName.endsWith(".war") && ((Hashtable)aliasesUris).size() == 0) {
                String alias = null;
                alias = moduleName.substring(0, moduleName.lastIndexOf(46));
                ((Hashtable)aliasesUris).put(alias, moduleName);
                ((Hashtable)this.props).put("web:" + alias, moduleName);
            }
        }
        containerInfo.setAliasesUris(aliasesUris);
    }

    private void extractStandAlone() throws DeploymentException {
        this.tempDirForStandAlone = new File(this.communicator.getRootDirectory() + File.separator + System.currentTimeMillis());
        JarExtractor util = new JarExtractor();
        try {
            new ZipFile(this.moduleFile);
        }
        catch (IOException ioex) {
            return;
        }
        try {
            util.extractJar(this.moduleFile.getAbsolutePath(), this.tempDirForStandAlone.getAbsolutePath());
        }
        catch (IOException ioex) {
            ServerDeploymentException sde = new ServerDeploymentException("deploy_5045", new String[]{this.moduleFile.getAbsolutePath(), this.tempDirForStandAlone.getAbsolutePath(), this.getTransactionType(), this.getModuleID()}, ioex);
            throw sde;
        }
    }

    private Hashtable registerRarLoader() throws DeploymentException {
        String[] jarFiles = null;
        Vector<String> all = new Vector<String>();
        JarExtractor util = new JarExtractor();
        Hashtable<String, File[]> allContFiles = new Hashtable<String, File[]>();
        File moduleLogConfig = null;
        Object tmp_path = null;
        try {
            moduleLogConfig = this.getFileNonCaseSensitive(this.tempDirForStandAlone, new String[]{"META-INF", "log-configuration.xml"});
            if (moduleLogConfig != null && moduleLogConfig.exists()) {
                ContainerInterface[] logConts = this.findContainersHandlingFile("META-INF/log-configuration.xml");
                if (logConts != null) {
                    int i = 0;
                    while (i < logConts.length) {
                        allContFiles.put(logConts[i].getContainerInfo().getName(), new File[]{moduleLogConfig});
                        ++i;
                    }
                }
            } else {
                moduleLogConfig = null;
            }
        }
        catch (Exception e) {
            throw new ServerDeploymentException("deploy_5051", new String[]{moduleLogConfig.getAbsolutePath(), tmp_path}, e);
        }
        if (this.moduleFile.getName().toLowerCase().endsWith(".rar")) {
            String[] connectorJars = this.listRecursivelyArchives(this.tempDirForStandAlone);
            if (connectorJars != null) {
                int j = 0;
                while (j < connectorJars.length) {
                    all.add(connectorJars[j]);
                    ++j;
                }
            }
            jarFiles = new String[all.size()];
            all.toArray(jarFiles);
        } else {
            jarFiles = new String[]{this.moduleFile.getAbsolutePath()};
        }
        JarsResource jars = new JarsResource(jarFiles);
        this.loader = new ResourceLoader("Deployment:Runtime:" + this.getModuleID(), (Resource)jars, this.getClass().getClassLoader(), null);
        this.communicator.registerEARloader(this.loader, this.deployment);
        return allContFiles;
    }

    private String[] listRecursivelyArchives(File outputDir) {
        Vector files = new Vector();
        if (outputDir.isDirectory()) {
            this.list(outputDir, files);
        }
        Object[] res = new String[files.size()];
        files.copyInto(res);
        return res;
    }

    private void list(File file, Vector all) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.list(files[i], all);
            } else if (files[i].getName().toLowerCase().endsWith(".jar") || files[i].getName().toLowerCase().endsWith(".zip") || files[i].getName().toLowerCase().endsWith(".war")) {
                all.add(files[i].getAbsolutePath());
            }
            ++i;
        }
    }

    private void uploadSpecialEARFiles() throws IOException, ConfigurationException {
        Configuration propertiesConfig = null;
        propertiesConfig = this.config.existsSubConfiguration("appcfg") ? this.config.getSubConfiguration("appcfg") : this.config.createSubConfiguration("appcfg");
        this.uploadSAPPropertiesFile(propertiesConfig);
        this.uploadSAPManifestFile(propertiesConfig);
    }

    private void uploadSAPPropertiesFile(Configuration propertiesConfig) throws IOException, ConfigurationException {
        File sapPropertiesFile = null;
        sapPropertiesFile = this.getModuleType() == 0 ? this.reader.extractFileNonCaseSensitive("META-INF/sap.application.global.properties") : this.getFileNonCaseSensitive(this.tempDirForStandAlone, new String[]{"META-INF", "sap.application.global.properties"});
        this.deployment.setApplicationConfigurationPath(propertiesConfig.getPath());
        if (sapPropertiesFile != null && sapPropertiesFile.exists()) {
            ByteArrayOutputStream baos;
            block9: {
                FileInputStream fis = new FileInputStream(sapPropertiesFile);
                baos = new ByteArrayOutputStream();
                try {
                    byte[] buffer = new byte[1024];
                    int read = 0;
                    while ((read = fis.read(buffer)) > -1) {
                        baos.write(buffer, 0, read);
                    }
                    Configuration appProperties = null;
                    byte[] res = baos.toByteArray();
                    if (propertiesConfig.existsSubConfiguration("application.global.properties")) {
                        appProperties = propertiesConfig.getSubConfiguration("application.global.properties");
                        appProperties.getPropertySheetInterface().updatePropertyEntries(res);
                    } else {
                        appProperties = propertiesConfig.createSubConfiguration("application.global.properties", 1);
                        appProperties.getPropertySheetInterface().createPropertyEntries(res);
                    }
                    Object var10_9 = null;
                    if (fis == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (fis != null) {
                        fis.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                    throw throwable;
                }
                fis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private void uploadSAPManifestFile(Configuration propertiesConfig) throws IOException, ConfigurationException {
        File manifestFile = null;
        manifestFile = this.getModuleType() == 0 ? this.reader.extractFileNonCaseSensitive("META-INF/SAP_MANIFEST.MF") : this.getFileNonCaseSensitive(this.tempDirForStandAlone, new String[]{"META-INF", "SAP_MANIFEST.MF"});
        if (manifestFile != null && manifestFile.exists()) {
            Configuration manifestConfig = null;
            if (propertiesConfig.existsSubConfiguration("SAP_MANIFEST")) {
                manifestConfig = propertiesConfig.getSubConfiguration("SAP_MANIFEST");
                manifestConfig.updateFile(manifestFile);
            } else {
                manifestConfig = propertiesConfig.createSubConfiguration("SAP_MANIFEST");
                manifestConfig.addFileEntry(manifestFile);
            }
            this.deployment.setSAPManifestConfiguration(manifestConfig.getPath());
        }
    }

    public File getFileNonCaseSensitive(File dir, String[] path) {
        if (path == null) {
            return null;
        }
        String[] children = null;
        int j = 0;
        int i = 0;
        while (i < path.length) {
            if (path[i] != null) {
                children = dir.list();
                if (children != null) {
                    j = 0;
                    while (j < children.length) {
                        if (children[j].equalsIgnoreCase(path[i])) {
                            dir = new File(dir, children[j]);
                            break;
                        }
                        ++j;
                    }
                    if (j == children.length) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            ++i;
        }
        return dir;
    }

    private void processReferences() throws DeploymentException {
        int i;
        ArrayList<ReferenceObject> additionalRefs = new ArrayList<ReferenceObject>();
        try {
            ReferenceObjectIntf[] refObjs;
            if (this.moduleType == 0 && (refObjs = this.reader.getDescriptor().getReferences()) != null && refObjs.length > 0) {
                ReferenceObject temp = null;
                i = 0;
                while (i < refObjs.length) {
                    temp = new ReferenceObject();
                    temp.setReferenceProviderName(refObjs[i].getReferenceProviderName());
                    temp.setReferenceTarget(refObjs[i].getReferenceTarget());
                    temp.setReferenceTargetType(refObjs[i].getReferenceTargetType());
                    temp.setReferenceType(refObjs[i].getReferenceType());
                    additionalRefs.add(temp);
                    ++i;
                }
            }
        }
        catch (IOException ioex) {
            throw new ServerDeploymentException("deploy_5041", new String[]{this.getModuleID()}, ioex);
        }
        ReferenceObject[] previousRefs = this.communicator.getAdditionalReferences(this.getModuleID());
        if (previousRefs != null) {
            int i2 = 0;
            while (i2 < previousRefs.length) {
                additionalRefs.add(previousRefs[i2]);
                ++i2;
            }
        }
        ReferenceObject[] addRefs = new ReferenceObject[additionalRefs.size()];
        additionalRefs.toArray(addRefs);
        i = 0;
        while (i < addRefs.length) {
            this.communicator.addReferenceInternally(this.deployment, addRefs[i]);
            ++i;
        }
    }

    private void fillAliases(Hashtable allContFiles) throws DeploymentException {
        Enumeration conts = allContFiles.keys();
        ContainerInterface cont = null;
        while (conts.hasMoreElements()) {
            cont = this.communicator.getContainer((String)conts.nextElement());
            if (cont == null || !cont.getContainerInfo().isJ2EEContainer() || !cont.getContainerInfo().getJ2EEModuleName().equals("web")) continue;
            J2EEModule[] modules = null;
            try {
                modules = this.reader.getEARDescriptor().getWEBs();
            }
            catch (IOException e) {
                throw new ServerDeploymentException("deploy_5041", new String[]{this.getModuleID()}, e);
            }
            String key = null;
            String value = null;
            if (modules == null) break;
            int i = 0;
            while (i < modules.length) {
                key = modules[i].getUri();
                value = modules[i].getContextRoot();
                ((Hashtable)this.props).put("web:" + value, key);
                ++i;
            }
            break block2;
        }
    }

    protected ContainerInterface[] findContainersHandlingFile(String fileName) {
        Enumeration enumc = this.communicator.getContainers();
        fileName = fileName.replace(File.separatorChar, '/');
        Vector<ContainerInterface> res = new Vector<ContainerInterface>();
        while (enumc.hasMoreElements()) {
            ContainerInterface ci = (ContainerInterface)enumc.nextElement();
            String[] fnames = ci.getContainerInfo().getFileNames();
            if (fnames == null) continue;
            int i = 0;
            while (i < fnames.length) {
                if (fnames[i].replace(File.separatorChar, '/').endsWith(fileName)) {
                    res.add(ci);
                }
                ++i;
            }
        }
        if (res.size() == 0) {
            return null;
        }
        ContainerInterface[] resci = new ContainerInterface[res.size()];
        res.toArray(resci);
        return resci;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getContainerNameForJarFile() throws DeploymentException {
        ContainerInterface cinterf;
        block11: {
            JarFile jar = null;
            cinterf = null;
            try {
                try {
                    jar = new JarFile(this.moduleFile);
                    Enumeration<JarEntry> entries = jar.entries();
                    JarEntry entry = null;
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        if (entry.getName().equalsIgnoreCase("meta-inf/ejb-jar.xml")) {
                            cinterf = this.getContainer("ejb");
                        } else {
                            if (!entry.getName().equalsIgnoreCase("META-INF/application-client.xml")) continue;
                            cinterf = this.getContainer("java");
                        }
                        break;
                    }
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("deploy_5043", new String[]{this.moduleFile.getAbsolutePath()}, ioex);
                }
                Object var6_6 = null;
                if (jar == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (jar == null) throw throwable;
                try {
                    jar.close();
                    throw throwable;
                }
                catch (IOException ioex) {
                    throw new ServerDeploymentException("deploy_5043", new String[]{this.moduleFile.getAbsolutePath()}, ioex);
                }
            }
            try {}
            catch (IOException ioex) {
                throw new ServerDeploymentException("deploy_5043", new String[]{this.moduleFile.getAbsolutePath()}, ioex);
            }
            jar.close();
        }
        if (cinterf == null) return null;
        return cinterf.getContainerInfo().getName();
    }

    private ContainerInterface getContainer(String moduleName) {
        Enumeration conts = this.communicator.getContainers();
        ContainerInterface cont = null;
        while (conts.hasMoreElements()) {
            cont = (ContainerInterface)conts.nextElement();
            if (!moduleName.equalsIgnoreCase(cont.getContainerInfo().getJ2EEModuleName())) continue;
            return cont;
        }
        return null;
    }

    protected boolean foundString(String str, String[] arr) {
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (str.equalsIgnoreCase(arr[i].toLowerCase())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean findInNonJ2EEContainer(String extension, ContainerInfo cinfo) {
        String[] names = cinfo.getFileNames();
        if (this.foundString(this.moduleFile.getName(), names)) {
            return true;
        }
        names = cinfo.getFileExtensions();
        return this.foundString(extension, names);
    }

    protected void findSuitableContainersForStandAlone(ArrayList suitableContainers) throws DeploymentException {
        String contName = null;
        String moduleFilePath = this.moduleFile.getName();
        if (moduleFilePath.lastIndexOf(46) != -1) {
            String extension = moduleFilePath.substring(moduleFilePath.lastIndexOf(46));
            if (extension.equalsIgnoreCase(".jar")) {
                contName = this.getContainerNameForJarFile();
                if (contName != null) {
                    suitableContainers.add(contName);
                }
            } else {
                ContainerInterface cont = null;
                Enumeration enumeration = this.communicator.getContainers();
                String[] contExts = null;
                ContainerInfo cinfo = null;
                while (enumeration.hasMoreElements()) {
                    cont = (ContainerInterface)enumeration.nextElement();
                    cinfo = cont.getContainerInfo();
                    if (cinfo.isJ2EEContainer()) {
                        contExts = cinfo.getFileExtensions();
                        if (!this.foundString(extension, contExts)) continue;
                        suitableContainers.add(cinfo.getName());
                        continue;
                    }
                    if (!this.findInNonJ2EEContainer(extension, cinfo)) continue;
                    suitableContainers.add(cinfo.getName());
                }
            }
        } else {
            throw new ServerDeploymentException("deploy_5044", new String[]{this.moduleFile.getName(), this.getTransactionType()});
        }
    }

    protected void defineModuleIDforStandAlone() {
        ContainerInfo info = null;
        ContainerInterface cont = this.communicator.getContainer(this.singleContainers[0]);
        if (cont != null) {
            info = cont.getContainerInfo();
            String module = info.isJ2EEContainer() ? info.getJ2EEModuleName() : info.getModuleName();
            String name = null;
            if (this.props.getProperty("application_name") != null) {
                name = this.props.getProperty("application_name");
                if (!name.trim().equals("")) {
                    this.setComponentName(name);
                } else {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                }
            } else {
                try {
                    name = cont.getApplicationName(this.moduleFile);
                    if (name != null && !name.trim().equals("")) {
                        this.setModuleID(name);
                    } else {
                        this.setComponentName(module + "_" + this.moduleFile.getName());
                    }
                }
                catch (DeploymentException dex) {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    this.setComponentName(module + "_" + this.moduleFile.getName());
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"getting name of application " + module + "_" + this.moduleFile.getName()}, th);
                    sdex.log();
                }
            }
            if (this.props.getProperty("provider_name") != null) {
                this.setProviderName(this.props.getProperty("provider_name"));
            }
        }
    }

    protected abstract Hashtable getConcernedContainers(Hashtable var1, ContainerDeploymentInfo var2) throws DeploymentException;

    protected abstract String[] makeComponents(File[] var1, ContainerDeploymentInfo var2, Properties var3, ContainerInterface var4) throws DeploymentException;
}

