/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExceptionInfo;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.RemoteCaller;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StartTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;

public abstract class ApplicationTransaction
implements DTransaction {
    protected TransactionCommunicator communicator = null;
    protected RemoteCaller remote = null;
    protected int clusterID;
    protected byte moduleType;
    protected String transactionType;
    protected DTransaction childTransaction = null;
    private boolean unregisterAfterFinish = false;
    protected ContainerInterface[] containers = null;
    protected Properties[] contProperties = null;
    private int[] infoes = null;
    private String providerName = "sap.com";
    private String compName = null;
    private ConfigurationHandler handler = null;
    private boolean writeAccess = false;
    private long beginTime = 0L;
    private Serializable serObject = null;
    protected TransactionStatistics[] remoteStatistics = null;
    protected TransactionStatistics currentStatistics = null;
    private boolean needToMakeTransaction = true;
    private boolean okFinished = false;
    private char lockType = (char)88;

    public void setTransactionCommunicator(TransactionCommunicator communicator) throws DeploymentException {
        this.communicator = communicator;
        this.remote = communicator.getRemoteCaller();
        this.clusterID = communicator.getClusterID();
        this.infoes = this.remote.getServerIDs();
        this.currentStatistics = new TransactionStatistics(this.clusterID);
        if (this.getModuleID() != null) {
            this.currentStatistics.setModuleName(this.getModuleID());
        }
    }

    public String getModuleID() {
        if (this.providerName == null && this.compName == null) {
            return null;
        }
        return this.providerName + "/" + this.compName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setModuleID(String id) throws DeploymentException {
        int index = id.indexOf("/");
        if (index != -1 && index != 0) {
            this.setProviderName(id.substring(0, index));
            if (index == id.length() - 1) throw new ServerDeploymentException("deploy_5012", new String[]{id, this.transactionType});
            this.setComponentName(id.substring(index + 1));
        } else {
            this.setProviderName("sap.com");
            this.setComponentName(id);
        }
        if (this.currentStatistics == null) return;
        this.currentStatistics.setModuleName(this.getModuleID());
    }

    public byte getModuleType() {
        return this.moduleType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public DTransaction getChildTransaction() {
        return this.childTransaction;
    }

    public void setComponentName(String compName) {
        this.compName = DUtils.replaceForbiddenSymbols(compName);
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getComponentName() {
        return this.compName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setModuleType(byte moduleType) {
        this.moduleType = moduleType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public void setChildTransaction(DTransaction childTransaction) {
        this.childTransaction = childTransaction;
    }

    public ContainerInterface[] getAffectedContainers() {
        return this.containers;
    }

    public Properties getContainerProperties(int index) {
        return index >= 0 && index < this.contProperties.length ? this.contProperties[index] : null;
    }

    public ConfigurationHandler getHandler() {
        return this.handler;
    }

    protected void setHandler(ConfigurationHandler h) {
        this.handler = h;
    }

    public void setWriteAccess(boolean access) {
        this.writeAccess = access;
    }

    protected void commitHandler() throws ConfigurationException {
        block7: {
            if (this.handler == null) {
                return;
            }
            try {
                if (this.writeAccess) {
                    this.handler.commit();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.handler.closeAllConfigurations();
                }
                catch (ConfigurationException cex) {
                    this.communicator.logThrowable(cex);
                }
                this.handler = null;
                throw throwable;
            }
            try {
                this.handler.closeAllConfigurations();
                break block7;
            }
            catch (ConfigurationException cex) {
                this.communicator.logThrowable(cex);
            }
            {
            }
        }
        this.handler = null;
        this.communicator.trace(200, "Commit handler of transaction " + this.getTransactionType());
    }

    public void rollbackHandler() throws ConfigurationException {
        block7: {
            if (this.handler == null) {
                return;
            }
            try {
                if (this.writeAccess) {
                    this.handler.rollback();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.handler.closeAllConfigurations();
                }
                catch (ConfigurationException cex) {
                    this.communicator.logThrowable(cex);
                }
                this.handler = null;
                throw throwable;
            }
            try {
                this.handler.closeAllConfigurations();
                break block7;
            }
            catch (ConfigurationException cex) {
                this.communicator.logThrowable(cex);
            }
            {
            }
        }
        this.handler = null;
        this.communicator.trace(200, "Rollback handler of transaction " + this.getTransactionType());
    }

    protected Configuration createApplicationConfiguration(String root) throws DeploymentException {
        if (root == null) {
            throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), " root configuration is null"});
        }
        Configuration appConfig = null;
        try {
            this.writeAccess = true;
            appConfig = this.handler.createSubConfiguration(root + "/" + this.getProviderName() + "/" + this.getComponentName());
            return appConfig;
        }
        catch (NameAlreadyExistsException naex) {
            try {
                appConfig = this.handler.openConfiguration(root + "/" + this.getProviderName() + "/" + this.getComponentName(), 1);
                return appConfig;
            }
            catch (ConfigurationException cex1) {
                this.communicator.logThrowable(cex1);
                throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), cex1.getMessage()}, cex1);
            }
        }
        catch (NameNotFoundException nnfe) {
            try {
                appConfig = this.handler.createSubConfiguration(root + "/" + this.getProviderName());
                return null;
            }
            catch (ConfigurationException cex) {
                throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), cex.getMessage()}, cex);
            }
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), cex.getMessage()}, cex);
        }
    }

    protected Configuration openApplicationConfiguration(String rootName, int access) throws DeploymentException {
        if (this.getHandler() == null) {
            throw new ServerDeploymentException("deploy_5011", new String[]{rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), this.getModuleID(), this.getTransactionType(), " handler is null."});
        }
        if (rootName == null) {
            throw new ServerDeploymentException("deploy_5011", new String[]{rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), this.getModuleID(), this.getTransactionType(), " root configuration name is null."});
        }
        if (access != 0 && access != 1) {
            throw new ServerDeploymentException("deploy_5011", new String[]{rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), this.getModuleID(), this.getTransactionType(), " access is none read, nor write."});
        }
        if (access == 1) {
            this.writeAccess = true;
        }
        try {
            return this.getHandler().openConfiguration(rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), access);
        }
        catch (NameNotFoundException nnfex) {
            if (access == 0) {
                return null;
            }
            throw new ServerDeploymentException("deploy_5011", new String[]{rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), this.getModuleID(), this.getTransactionType(), nnfex.getMessage()}, nnfex);
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5011", new String[]{rootName + "/" + this.getProviderName() + "/" + this.getComponentName(), this.getModuleID(), this.getTransactionType(), cex.getMessage()}, cex);
        }
    }

    protected void openHandler() throws DeploymentException {
        ConfigurationHandlerFactory factory = this.communicator.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
        if (factory == null) {
            throw new ServerDeploymentException("deploy_5027", new String[]{this.getTransactionType(), this.getModuleID(), " factory is null."});
        }
        try {
            this.handler = factory.getConfigurationHandler();
        }
        catch (ConfigurationException cex) {
            throw new ServerDeploymentException("deploy_5027", new String[]{this.getTransactionType(), this.getModuleID(), cex.getMessage()}, cex);
        }
        if (this.handler == null) {
            throw new ServerDeploymentException("deploy_5027", new String[]{this.getTransactionType(), this.getModuleID(), " returned handler is null."});
        }
        this.writeAccess = false;
    }

    protected void addContainer(ContainerInterface cont, Properties props) {
        this.containers = DUtils.addAsLastElement(this.containers, cont);
        this.contProperties = DUtils.addAsLastElement(this.contProperties, props);
    }

    protected void makeAllPhasesOnOneServer() throws DeploymentException {
        if (this instanceof StartTransaction || this instanceof StopTransaction) {
            ((ParallelAdapter)this).deleteException();
        }
        try {
            this.begin();
        }
        catch (DeploymentException rex) {
            this.rollbackPart(false, true, rex);
        }
        catch (Exception ex) {
            this.rollbackPart(false, true, ex);
        }
        catch (Error er) {
            this.rollbackPart(false, true, er);
        }
        try {
            this.prepare();
        }
        catch (DeploymentException rex) {
            this.rollbackPart(false, false, rex);
        }
        catch (Exception ex) {
            this.rollbackPart(false, false, ex);
        }
        catch (Error er) {
            this.rollbackPart(false, false, er);
        }
        try {
            this.commit();
        }
        catch (Exception ex) {
            ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
            if (!this.communicator.isMarkedForShutdown()) {
                dex.log();
            }
            throw dex;
        }
    }

    public void makeAllPhases() throws DeploymentException {
        try {
            this.makeAllPhasesOnOneServer();
            try {
                this.remoteStatistics = this.remote.notifyRemotely(this, true);
            }
            catch (DeploymentException dex) {
                dex.log();
                this.currentStatistics.addErrors(new String[]{"Error occurred while opertaion " + this.getTransactionType() + " with application " + this.getModuleID() + " notifyed other cluster elements.For more information look at log file of Deploy Service."});
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.finalActions();
            }
            catch (WarningException wex) {
                wex.log();
            }
            throw throwable;
        }
        try {
            this.finalActions();
        }
        catch (WarningException wex) {
            wex.log();
        }
    }

    protected void finalActions() throws WarningException, DeploymentException {
    }

    public void makeAllPhasesLocal() throws DeploymentException {
        try {
            if (this instanceof StartTransaction || this instanceof StopTransaction) {
                ((ParallelAdapter)this).deleteException();
            }
            try {
                this.beginLocal();
            }
            catch (DeploymentException rex) {
                this.rollbackPart(true, true, rex);
            }
            catch (Exception ex) {
                this.rollbackPart(true, true, ex);
            }
            catch (Error er) {
                this.rollbackPart(true, true, er);
            }
            try {
                this.prepareLocal();
            }
            catch (DeploymentException rex) {
                this.rollbackPart(true, false, rex);
            }
            catch (Exception ex) {
                this.rollbackPart(true, false, ex);
            }
            catch (Error er) {
                this.rollbackPart(true, false, er);
            }
            try {
                this.commitLocal();
            }
            catch (Exception ex) {
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
                dex.log();
                throw dex;
            }
            Object var5_10 = null;
            if (this.unregister()) {
                this.communicator.unregisterTransactionWithLock(this.getModuleID());
            } else {
                this.communicator.unregisterTransactionWithoutLock(this.getModuleID());
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (this.unregister()) {
                this.communicator.unregisterTransactionWithLock(this.getModuleID());
            } else {
                this.communicator.unregisterTransactionWithoutLock(this.getModuleID());
            }
            throw throwable;
        }
    }

    private void rollbackPart(boolean local, boolean begin, Throwable th) throws DeploymentException {
        ServerDeploymentException sdex;
        block14: {
            if (this instanceof StartTransaction) {
                this.communicator.setExceptionInfo(this.getModuleID(), new ExceptionInfo(this.communicator.getClusterID(), "startApp", th));
                ((StartTransaction)this).saveException();
            }
            sdex = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, th);
            if (!this.communicator.isMarkedForShutdown()) {
                sdex.log();
            }
            try {
                if (local) {
                    if (begin) {
                        this.rollbackLocal();
                    } else {
                        this.rollbackPrepareLocal();
                    }
                } else if (begin) {
                    this.rollback();
                } else {
                    this.rollbackPrepare();
                }
            }
            catch (Exception ex) {
                ServerDeploymentException dex1 = new ServerDeploymentException("deploy_5029", new String[]{this.getTransactionType(), this.getModuleID()}, ex);
                if (this.communicator.isMarkedForShutdown()) break block14;
                dex1.log();
            }
        }
        if (th instanceof DeploymentException) {
            throw (DeploymentException)th;
        }
        if (th instanceof Exception) {
            throw sdex;
        }
        if (th instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)th;
        }
        if (th instanceof ThreadDeath) {
            throw (ThreadDeath)th;
        }
        throw sdex;
    }

    public void addWarnings(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarnings(w);
        }
    }

    public void addWarning(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addWarning(w);
        }
    }

    public void addErrors(String[] w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addErrors(w);
        }
    }

    public void addError(String w) {
        if (this.currentStatistics != null) {
            this.currentStatistics.addError(w);
        }
    }

    public int[] getOtherServerIDs() {
        return this.infoes;
    }

    public void setUnregister(boolean unregister) {
        this.unregisterAfterFinish = unregister;
    }

    public boolean unregister() {
        return this.unregisterAfterFinish;
    }

    public void removeServerID(int serverID) {
        int i = 0;
        while (i < this.infoes.length) {
            if (this.infoes[i] == serverID) {
                int[] temp = new int[this.infoes.length - 1];
                System.arraycopy(this.infoes, 0, temp, 0, i);
                if (i < this.infoes.length - 1) {
                    System.arraycopy(this.infoes, i + 1, temp, i, this.infoes.length - i - 1);
                }
                this.infoes = temp;
                return;
            }
            ++i;
        }
    }

    protected void setServerIDs(int[] ids) {
        this.infoes = ids;
    }

    protected void sortContainersDec(ContainerInterface[] conts) {
        int index = 0;
        ContainerInterface temp = null;
        if (conts == null) {
            return;
        }
        int i = 0;
        while (i < conts.length - 1) {
            temp = conts[i];
            index = i;
            int j = i + 1;
            while (j < conts.length) {
                if (temp.getContainerInfo().getPriority() < conts[j].getContainerInfo().getPriority()) {
                    temp = conts[j];
                    index = j;
                }
                ++j;
            }
            conts[index] = conts[i];
            conts[i] = temp;
            ++i;
        }
    }

    protected void sortContainersInc(ContainerInterface[] conts) {
        int index = 0;
        ContainerInterface temp = null;
        if (conts == null) {
            return;
        }
        int i = 0;
        while (i < conts.length - 1) {
            temp = conts[i];
            index = i;
            int j = i + 1;
            while (j < conts.length) {
                if (temp.getContainerInfo().getPriority() > conts[j].getContainerInfo().getPriority()) {
                    temp = conts[j];
                    index = j;
                }
                ++j;
            }
            conts[index] = conts[i];
            conts[i] = temp;
            ++i;
        }
    }

    public void setBeginTime(long begin) {
        this.beginTime = begin;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public Serializable getSerializableForSend() {
        return this.serObject;
    }

    protected void setSerializable(Serializable serObject) {
        this.serObject = serObject;
    }

    public TransactionStatistics[] getStatistics() {
        if (this.remoteStatistics != null) {
            TransactionStatistics[] temp = new TransactionStatistics[this.remoteStatistics.length + 1];
            System.arraycopy(this.remoteStatistics, 0, temp, 0, this.remoteStatistics.length);
            temp[this.remoteStatistics.length] = this.currentStatistics;
            return temp;
        }
        return new TransactionStatistics[]{this.currentStatistics};
    }

    public void setStatistics(TransactionStatistics[] stats) {
        this.remoteStatistics = stats;
    }

    public TransactionStatistics getCurrentStatistics() {
        return this.currentStatistics;
    }

    protected void makeNestedTransaction(DTransaction nested) throws DeploymentException, ComponentNotDeployedException {
        this.childTransaction = nested;
        this.communicator.registerTransactionWithoutLock(this.childTransaction);
        try {
            this.childTransaction.makeAllPhases();
            Object var3_2 = null;
            this.childTransaction = null;
            this.communicator.registerTransactionWithoutLock(this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.childTransaction = null;
            this.communicator.registerTransactionWithoutLock(this);
            throw throwable;
        }
    }

    protected void makeNestedParallelTransaction(ParallelAdapter nested) throws DeploymentException {
        this.childTransaction = nested;
        nested.setUnregister(false);
        this.communicator.registerTransactionWithoutLock(this.childTransaction);
        try {
            nested.makeAllPhasesAndWait();
            Object var3_2 = null;
            if (this.childTransaction.getCurrentStatistics() != null) {
                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
            }
            this.childTransaction = null;
            this.communicator.registerTransactionWithoutLock(this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.childTransaction.getCurrentStatistics() != null) {
                this.addWarnings(this.childTransaction.getCurrentStatistics().getWarnings());
                this.addErrors(this.childTransaction.getCurrentStatistics().getErrors());
            }
            this.childTransaction = null;
            this.communicator.registerTransactionWithoutLock(this);
            throw throwable;
        }
    }

    protected void createProviderConfiguration(String root) throws DeploymentException {
        if (this.getHandler() == null) {
            throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), " handler is null"});
        }
        this.writeAccess = true;
        try {
            Configuration providerConfig = null;
            providerConfig = this.getHandler().createSubConfiguration(root + "/" + this.getProviderName());
        }
        catch (NameAlreadyExistsException naex) {
            new ServerDeploymentException("deploy_5082", new String[]{"creating provider configuration for application: " + this.getModuleID() + ".\nReason: " + naex.toString()}, naex).log();
        }
        catch (ConfigurationException cex) {
            new ServerDeploymentException("deploy_5082", new String[]{"creating provider configuration for application: " + this.getModuleID() + ".\nReason: " + cex.toString()}, cex).log();
            throw new ServerDeploymentException("deploy_5013", new String[]{this.getTransactionType(), this.getModuleID(), cex.getMessage()}, cex);
        }
    }

    public boolean needForTransaction() {
        return this.needToMakeTransaction;
    }

    protected void setNeedForTransation(boolean need) {
        this.needToMakeTransaction = need;
    }

    public boolean isSuccessfullyFinished() {
        return this.needForTransaction() ? this.okFinished : true;
    }

    protected void setSuccessfullyFinished(boolean ok) {
        this.okFinished = ok;
    }

    public char getLockType() {
        return this.lockType;
    }

    public void setLockType(char lockType) {
        this.lockType = lockType;
    }

    protected DeploymentInfo readDeploymentInfoFromDB() throws DeploymentException {
        DeploymentInfo info = null;
        try {
            this.openHandler();
            Configuration config = null;
            if (this.getHandler() == null) {
                this.communicator.trace(200, "Configuration manager is not available - can not open configuration for application " + this.getModuleID());
            } else {
                config = this.openApplicationConfiguration("apps", 0);
            }
            info = this.communicator.getApplicationInfo(this.getModuleID(), false, false, config, this.openApplicationConfiguration("deploy", 0));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.commitHandler();
            }
            catch (ConfigurationException e) {
                new ServerDeploymentException("deploy_5082", new String[]{"reading deployment information from DB for application: " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
            }
            throw throwable;
        }
        try {
            this.commitHandler();
        }
        catch (ConfigurationException e) {
            new ServerDeploymentException("deploy_5082", new String[]{"reading deployment information from DB for application: " + this.getModuleID() + ".\nReason: " + e.toString()}, e).log();
        }
        return info;
    }

    protected String getStackTraceAsString(Throwable th) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public TransactionCommunicator getTransactionCommunicator() {
        return this.communicator;
    }

    public abstract void cancel() throws WarningException;

    public abstract void stop() throws WarningException;

    public abstract void rollbackPrepareLocal();

    public abstract void rollbackPrepare();

    public abstract void rollbackLocal();

    public abstract void rollback();

    public abstract void commitLocal();

    public abstract void commit();

    public abstract void prepareLocal() throws DeploymentException;

    public abstract void prepare() throws DeploymentException;

    public abstract void beginLocal() throws DeploymentException, ComponentNotDeployedException;

    public abstract void begin() throws DeploymentException, ComponentNotDeployedException;
}

