/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server.application;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.StartTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class AddAppInfoChangeTransaction
extends ApplicationTransaction {
    private boolean needRestart = false;
    private AdditionalAppInfo additionalInfo = null;
    private int[] needRestartServers = new int[0];

    public AddAppInfoChangeTransaction(String applicationName, TransactionCommunicator communicator, AdditionalAppInfo additionalInfo) throws DeploymentException {
        if (applicationName == null || additionalInfo == null) {
            throw new ServerDeploymentException("deploy_5012", new String[]{"", "appInfoChange"});
        }
        this.setModuleID(applicationName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)1);
        this.setTransactionType("appInfoChange");
        this.additionalInfo = additionalInfo;
        this.setSerializable((Serializable)additionalInfo);
    }

    public AddAppInfoChangeTransaction(String applicationName, TransactionCommunicator communicator, AdditionalAppInfo additionalInfo, String[] containerNames) throws DeploymentException {
        this.setModuleID(applicationName);
        this.setTransactionCommunicator(communicator);
        this.setModuleType((byte)1);
        this.setTransactionType("appInfoChange");
        this.additionalInfo = additionalInfo;
        if (containerNames == null || containerNames.length == 0) {
            throw new ServerDeploymentException("deploy_5040", new String[]{String.valueOf(this.clusterID), this.getTransactionType(), this.getModuleID()});
        }
        ContainerInterface ci = null;
        DeploymentInfo info = communicator.getApplicationInfo(this.getModuleID());
        if (info == null && (info = this.readDeploymentInfoFromDB()) == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), communicator.getClusterIDName(), "make runtime changes"});
        }
        int i = 0;
        while (i < containerNames.length) {
            ci = communicator.getContainer(containerNames[i]);
            if (ci != null) {
                this.addContainer(ci, null);
            } else {
                if (!info.isOptionalContainer(containerNames[i])) {
                    throw new ServerDeploymentException("deploy_5006", new String[]{containerNames[i], this.getTransactionType(), this.getModuleID()});
                }
                this.addWarning("Optional container " + containerNames[i] + " is not active at the moment.");
            }
            ++i;
        }
    }

    public void begin() throws DeploymentException {
        this.communicator.trace(200, "Begin phase of operation " + this.getTransactionType());
        DeploymentInfo deployment = this.communicator.getApplicationInfo(this.getModuleID());
        if (deployment == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{this.getModuleID(), this.communicator.getClusterIDName(), "make runtime changes"});
        }
        ContainerInterface container = null;
        String[] contNames = deployment.getContainerNames();
        if (contNames == null || contNames.length == 0) {
            throw new ServerDeploymentException("deploy_5033", new String[]{this.getModuleID(), this.getTransactionType()});
        }
        int i = 0;
        while (i < contNames.length) {
            container = this.communicator.getContainer(contNames[i]);
            if (container != null) {
                try {
                    if (container.acceptedAppInfoChange(this.getModuleID(), this.additionalInfo)) {
                        this.addContainer(container, null);
                    }
                }
                catch (DeploymentException de) {
                    throw de;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    throw new ServerDeploymentException("deploy_5082", new String[]{"accepting changes in additional information for application " + this.getModuleID()}, th);
                }
                this.needRestart = this.needRestart || container.needStopOnAppInfoChanged(this.getModuleID(), this.additionalInfo);
            } else {
                if (!deployment.isOptionalContainer(contNames[i])) {
                    throw new ServerDeploymentException("deploy_5006", new String[]{contNames[i], this.getTransactionType(), this.getModuleID()});
                }
                this.addWarning("Optional container " + contNames[i] + " is not active at the moment.");
            }
            ++i;
        }
        if (this.containers == null) {
            throw new ServerDeploymentException("deploy_5095", new String[]{this.getModuleID()});
        }
        boolean bl = this.needRestart = this.needRestart && deployment.getStatus() == 1;
        if (this.needRestart) {
            int[] servers = this.communicator.getClusterIDs(null);
            ArrayList<Integer> temp = new ArrayList<Integer>();
            String appStatus = null;
            if (servers != null) {
                ClusterElement cEment = null;
                int i2 = 0;
                while (i2 < servers.length) {
                    try {
                        cEment = this.communicator.getApplicationServiceContext().getClusterContext().getClusterMonitor().getParticipant(servers[i2]);
                        if (this.communicator.getApplicationServiceContext() != null && cEment != null && (appStatus = this.communicator.getApplicationStatus(this.getModuleID(), cEment.getName())) != null && appStatus.equals("STARTED")) {
                            temp.add(new Integer(servers[i2]));
                        }
                    }
                    catch (RemoteException re) {
                        ServerDeploymentException de = new ServerDeploymentException("deploy_5030", new String[]{"while getting status of " + this.getModuleID() + "."}, re);
                        de.log();
                    }
                    ++i2;
                }
            }
            if (temp.size() > 0) {
                this.needRestartServers = new int[temp.size()];
                int i3 = 0;
                while (i3 < temp.size()) {
                    this.needRestartServers[i3] = (Integer)temp.get(i3);
                    ++i3;
                }
            }
            this.childTransaction = new StopTransaction(this.getModuleID(), this.communicator, this.needRestartServers, false);
            if (this.childTransaction.needForTransaction()) {
                this.childTransaction.setUnregister(false);
                this.makeNestedParallelTransaction((ParallelAdapter)this.childTransaction);
            }
        }
        try {
            this.openHandler();
            Configuration config = null;
            Configuration deployConfig = null;
            config = this.openApplicationConfiguration("apps", 1);
            deployConfig = this.openApplicationConfiguration("deploy", 1);
            config.modifyConfigEntry("STR:Failover", (Object)this.additionalInfo.getFailOverValue(), true);
            deployConfig.modifyConfigEntry("STR:StartUp", (Object)new Integer(this.additionalInfo.getStartUp()), true);
            int i4 = 0;
            while (i4 < this.containers.length) {
                try {
                    this.containers[i4].makeAppInfoChange(this.getModuleID(), this.additionalInfo, config);
                }
                catch (WarningException wex) {
                    this.addWarnings(wex.getWarnings());
                }
                catch (DeploymentException de) {
                    throw de;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    throw new ServerDeploymentException("deploy_5082", new String[]{"appying changes in additional information of application " + this.getModuleID()}, th);
                }
                ++i4;
            }
            this.commitHandler();
        }
        catch (ConfigurationException e) {
            throw new ServerDeploymentException("deploy_5026", new String[]{this.getTransactionType(), this.getModuleID()}, e);
        }
    }

    public void beginLocal() throws DeploymentException {
        this.communicator.trace(200, "Begin local phase of operation " + this.getTransactionType());
        if (this.containers == null) {
            throw new ServerDeploymentException("deploy_5095", new String[]{this.getModuleID()});
        }
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].notifyAppInfoChanged(this.getModuleID());
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"notifying " + this.getTransactionType() + " of application " + this.getModuleID()}, th);
                sdex.log();
            }
            ++i;
        }
        DeploymentInfo info = this.communicator.getApplicationInfo(this.getModuleID());
        info.setFailOverValue(this.additionalInfo.getFailOverValue());
        info.setStartUp(this.additionalInfo.getStartUp());
    }

    public void prepare() throws DeploymentException {
        this.communicator.trace(200, "Prepare phase of operation " + this.getTransactionType());
    }

    public void prepareLocal() throws DeploymentException {
        this.communicator.trace(200, "Prepare local phase of operation " + this.getTransactionType());
    }

    public void commit() {
        this.communicator.trace(200, "Commit phase of operation " + this.getTransactionType());
        int i = 0;
        while (i < this.containers.length) {
            try {
                this.containers[i].appInfoChangedCommit(this.getModuleID());
            }
            catch (WarningException wex) {
                this.addWarnings(wex.getWarnings());
            }
            catch (OutOfMemoryError oofme) {
                throw oofme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing " + this.getTransactionType() + " of application " + this.getModuleID()}, th);
                sdex.log();
            }
            ++i;
        }
        DeploymentInfo deployment = this.communicator.getApplicationInfo(this.getModuleID());
        try {
            deployment.setFailOverValue(this.additionalInfo.getFailOverValue());
            deployment.setStartUp(this.additionalInfo.getStartUp());
        }
        catch (BaseIllegalArgumentException foex) {
            foex.log();
        }
        this.restartApp();
        this.setSuccessfullyFinished(true);
    }

    public void commitLocal() {
        this.communicator.trace(200, "Commit local phase of operation " + this.getTransactionType());
        this.setSuccessfullyFinished(true);
    }

    public void rollback() {
        block14: {
            this.communicator.trace(200, "Rollback phase of operation " + this.getTransactionType());
            try {
                if (this.containers != null) {
                    int i = 0;
                    while (i < this.containers.length) {
                        try {
                            this.containers[i].appInfoChangedRollback(this.getModuleID());
                        }
                        catch (WarningException wex) {
                            this.addWarnings(wex.getWarnings());
                        }
                        catch (OutOfMemoryError oofme) {
                            throw oofme;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable th) {
                            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking " + this.getTransactionType() + " of application " + this.getModuleID()}, th);
                            sdex.log();
                        }
                        ++i;
                    }
                }
                this.restartApp();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (this.getHandler() != null) {
                        this.rollbackHandler();
                    }
                }
                catch (ConfigurationException rex) {
                    new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + rex.toString()}, rex).log();
                }
                this.setSuccessfullyFinished(false);
                throw throwable;
            }
            try {
                if (this.getHandler() != null) {
                    this.rollbackHandler();
                }
                break block14;
            }
            catch (ConfigurationException rex) {
                new ServerDeploymentException("deploy_5082", new String[]{"rollback phase of operation " + this.getTransactionType() + " for application " + this.getModuleID() + ".\nReason: " + rex.toString()}, rex).log();
            }
            {
            }
        }
        this.setSuccessfullyFinished(false);
    }

    private void restartApp() {
        if (this.needRestart) {
            try {
                this.childTransaction = new StartTransaction(this.getModuleID(), this.communicator, this.needRestartServers);
                if (this.childTransaction.needForTransaction()) {
                    this.childTransaction.setUnregister(false);
                    this.makeNestedParallelTransaction((ParallelAdapter)this.childTransaction);
                }
            }
            catch (DeploymentException rex) {
                rex.log();
            }
        }
    }

    public void rollbackLocal() {
        this.communicator.trace(200, "Rollback local phase of operation " + this.getTransactionType());
    }

    public void rollbackPrepare() {
    }

    public void rollbackPrepareLocal() {
        this.communicator.trace(200, "Rollback prepare local phase of operation " + this.getTransactionType());
    }

    public void stop() throws WarningException {
    }

    public void cancel() throws WarningException {
    }
}

